<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'study_material_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');

    // ✅ allow sorting by category_name instead of category_id
    $allowedSortFields = ['study_material_id', 'title', 'category_name', 'is_block'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'study_material_id';
    }
    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    $searchQuery = "WHERE sm.is_deleted != 1";
    $searchParams = [];

    // ✅ search also on category_name instead of id
    if (!empty($searchValue)) {
        $searchLike = "%$searchValue%";
        $searchQuery .= " AND (sm.title LIKE ? OR cm.category_name LIKE ?)";
        $searchParams = [$searchLike, $searchLike];

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR sm.is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR sm.is_block = ?";
            $searchParams[] = '0';
        }
    }

    // ✅ total records count (no JOIN needed)
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM study_material WHERE is_deleted != 1")->fetchColumn();

    // ✅ filtered count with JOIN
    if (!empty($searchParams)) {
        $filteredStmt = $pdo->prepare("
            SELECT COUNT(*) 
            FROM study_material sm
            LEFT JOIN category_master cm ON sm.category_id = cm.category_id
            $searchQuery
        ");
        $filteredStmt->execute($searchParams);
        $filteredRecords = $filteredStmt->fetchColumn();
    } else {
        $filteredRecords = $totalRecords;
    }

    // ✅ Fetch paginated data with category_name
    $dataSql = "
        SELECT sm.study_material_id,
               sm.title,
               sm.actual_file_name,
               sm.original_file_name,
               sm.vimeo_link,
               sm.is_block,
               cm.category_name
        FROM study_material sm
        LEFT JOIN category_master cm ON sm.category_id = cm.category_id
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $finalParams = array_merge($searchParams, [$start, $length]);
    $dataStmt = $pdo->prepare($dataSql);
    $dataStmt->execute($finalParams);
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);
} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}