<?php
require_once('../includes/connection.php');

header('Content-Type: application/json');

try {
    // Check if the incoming request has study material IDs
    if (!isset($_POST['ids']) || empty($_POST['ids'])) {
        echo json_encode([
            "status" => "error",
            "message" => "No study materials selected."
        ]);
        exit;
    }

    // Validate and sanitize the IDs
    $ids = array_filter(array_map('intval', explode(',', $_POST['ids'])));
    if (empty($ids)) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid study material IDs."
        ]);
        exit;
    }

    // Validate the submodule ID (from GET, base64-decoded)
    $submoduleId = isset($_GET['id']) ? $_GET['id'] : null;
    if (!$submoduleId || !is_numeric($submoduleId)) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid submodule ID."
        ]);
        exit;
    }

    // Prepare the comma-separated string for study material IDs
    $studyMaterials = implode(',', $ids);

    // Use prepared statements for security
    $query = "UPDATE submodule_master SET study_material = :study_material WHERE submodule_id = :submodule_id";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':study_material', $studyMaterials);
    $stmt->bindParam(':submodule_id', $submoduleId, PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Study materials assigned successfully!"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Error updating study materials."
        ]);
    }

} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Unexpected error: " . $e->getMessage()
    ]);
}
?>
