<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'submodule_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');
    $submodule_id = $_POST['submodule_id'] ?? '';

    // Validate sort direction
    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    // Whitelist sort fields
    $allowedSortFields = ['submodule_name', 'is_block', 'module_id', 'submodule_id'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'submodule_id';
    }

    // Base WHERE clause
    $searchQuery = "WHERE sm.is_deleted != 1";
    $searchParams = [];

    // Filter by submodule_id
    if (!empty($submodule_id)) {
        $searchQuery .= " AND sm.submodule_id = ?";
        $searchParams[] = $submodule_id;
    }

    // Search keyword
    if (!empty($searchValue)) {
        $like = "%$searchValue%";
        $searchQuery .= " AND (sm.submodule_name LIKE ?";
        $searchParams[] = $like;

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR sm.is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR sm.is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    // Total records (unfiltered)
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM submodule_master WHERE is_deleted != 1")->fetchColumn();

    // Total records (filtered)
    $countSql = "SELECT COUNT(*) FROM submodule_master sm $searchQuery";
    $countStmt = $pdo->prepare($countSql);
    $countStmt->execute($searchParams);
    $filteredRecords = $countStmt->fetchColumn();

    // Fetch paginated & filtered records
    $dataSql = "
        SELECT
            sm.submodule_id,
            sm.submodule_name,
            sm.module_id,
            sm.is_block,
            mm.module_name
        FROM
            submodule_master sm
        JOIN
            module_master mm ON sm.module_id = mm.module_id
        $searchQuery
        ORDER BY sm.$sortField $sortDir
        LIMIT :start, :length
    ";

    $dataStmt = $pdo->prepare($dataSql);

    // Bind dynamic search parameters
    foreach ($searchParams as $index => $param) {
        $dataStmt->bindValue($index + 1, $param);
    }

    // Bind LIMIT values
    $dataStmt->bindValue(':start', $start, PDO::PARAM_INT);
    $dataStmt->bindValue(':length', $length, PDO::PARAM_INT);

    $dataStmt->execute();
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => 'Server Error: ' . $e->getMessage()
    ]);
}
?>