<?php
header('Content-Type: application/json');
require_once('../includes/connection.php');

try {
    $draw = $_POST['draw'] ?? 1;
    $start = (int)($_POST['start'] ?? 0);
    $length = (int)($_POST['length'] ?? 10);
    $searchValue = $_POST['search']['value'] ?? '';
    $sortField = $_POST['sortField'] ?? 'testimonial_id';
    $sortDir = strtoupper($_POST['sortDir'] ?? 'DESC');

    $allowedSortFields = ['testimonial_id','testimonial_name', 'learner_since', 'testimonial_text', 'is_block'];
    if (!in_array($sortField, $allowedSortFields)) {
        $sortField = 'testimonial_id';
    }

    if (!in_array($sortDir, ['ASC', 'DESC'])) {
        $sortDir = 'DESC';
    }

    $searchQuery = "WHERE is_deleted != 1";
    $searchParams = [];

    if (!empty($searchValue)) {
        $searchLike = "%$searchValue%";
        $searchQuery .= " AND (testimonial_name LIKE ? OR learner_since LIKE ? OR testimonial_text LIKE ?";
        $searchParams = [$searchLike, $searchLike, $searchLike];

        if (stripos($searchValue, 'inactive') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '1';
        } elseif (stripos($searchValue, 'active') !== false) {
            $searchQuery .= " OR is_block = ?";
            $searchParams[] = '0';
        }

        $searchQuery .= ")";
    }

    // Total records count
    $totalRecords = $pdo->query("SELECT COUNT(*) FROM testimonial_master WHERE is_deleted != 1")->fetchColumn();

    // Filtered records count
    if (!empty($searchParams)) {
        $filteredStmt = $pdo->prepare("SELECT COUNT(*) FROM testimonial_master $searchQuery");
        $filteredStmt->execute($searchParams);
        $filteredRecords = $filteredStmt->fetchColumn();
    } else {
        $filteredRecords = $totalRecords;
    }

    // Fetch paginated data
    $dataSql = "
        SELECT testimonial_id, testimonial_name, learner_since, testimonial_text, is_block
        FROM testimonial_master
        $searchQuery
        ORDER BY $sortField $sortDir
        LIMIT ?, ?
    ";
    $dataStmt = $pdo->prepare($dataSql);
    $finalParams = array_merge($searchParams, [$start, $length]);
    $dataStmt->execute($finalParams);
    $data = $dataStmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'draw' => intval($draw),
        'recordsTotal' => intval($totalRecords),
        'recordsFiltered' => intval($filteredRecords),
        'data' => $data
    ]);
} catch (Exception $e) {
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}