<?php

require_once('../includes/connection.php');
require('../vendor/autoload.php');

$clientId = "5aa41d66ac6c8c8f7ac864af4455b38e58124df5";
$clientSecret = "f9VSklt+8WdIEFjYZAR5Q+gdo6Nu6z+ZgJWPpcCeuQWsEpOG8ksBRHLJlnRgl0mJ6QyJv6Khcf5tiP4AplxYCpoeTlKisXZAUz5LombPknL7wTfpSmbdtupJGW/7OBM5";
$accessToken = "59049690f9eb19c23cd3aaa17a2c759e";

use Vimeo\Vimeo;

// File upload check
if ($_FILES['study_files']['error'] === UPLOAD_ERR_OK) {
    $fileTmp = $_FILES['study_files']['tmp_name'];
    $fileName = $_FILES['study_files']['name'];
    $fileType = mime_content_type($fileTmp);
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    $title = $_POST['vidtitle'];
    $desc = $_POST['viddesc'];
    $course_category = $_POST['course_category'];
    
    $allowedVideoTypes = ['video/mp4', 'video/avi', 'video/mov', 'video/mkv'];
    $allowedDocTypes = ['application/pdf', 'image/jpeg', 'image/png'];

    // === Upload to Vimeo if it's a video ===
    if (in_array($fileType, $allowedVideoTypes)) {
        $client = new Vimeo($clientId, $clientSecret, $accessToken);
        
        try {
            $uri = $client->upload($fileTmp, [
                "name" => $title,
                "description" => $desc,
            ]);

            // Check transcoding status
            $response = $client->request($uri . '?fields=transcode.status');

            if ($response['body']['transcode']['status'] === 'complete') {
                $statusMsg = 'Your video finished transcoding.';
            } elseif ($response['body']['transcode']['status'] === 'in_progress') {
                $statusMsg = 'Video uploaded successfully';
            } else {
                $statusMsg = 'Your video encountered an error during transcoding.';
            }

            // Get Vimeo video link
            $response = $client->request($uri . '?fields=link');
            $video_link = $response['body']['link'];
            $get_vid_id = explode("/", $video_link)[3]; // Extract video ID

            // Save to DB
            $sql = "INSERT INTO study_material (vimeo_link, title, description, category_id) 
                    VALUES (:vimeo_link, :title, :description, :category_id)";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':vimeo_link', $get_vid_id);
            $stmt->bindParam(':title', $title);
            $stmt->bindParam(':description', $desc);
            $stmt->bindParam(':category_id', $course_category);
            $stmt->execute();

            echo json_encode(['success' => true, 'message' => $statusMsg]);

        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Vimeo Upload Error: ' . $e->getMessage()]);
        }

    }
    // === Upload to local folder if it's PDF or JPG ===
    elseif (in_array($fileType, $allowedDocTypes)) {
        $uploadDir = '../study/';
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        $newFilePath = $uploadDir . basename($fileName);

        if (move_uploaded_file($fileTmp, $newFilePath)) {
            // Insert into DB (if needed)
            $sql = "INSERT INTO study_material (actual_file_name, title, description, category_id) 
                    VALUES (:actual_file_name, :title, :description, :category_id)";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':actual_file_name', $fileName);
            $stmt->bindParam(':title', $title);
            $stmt->bindParam(':description', $desc);
            $stmt->bindParam(':category_id', $course_category);
            $stmt->execute();

            echo json_encode(['success' => true, 'message' => 'File uploaded successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to move file to folder.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Unsupported file type.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Error with the uploaded file.']);
}
