<?php
require_once('../includes/connection.php');

header('Content-Type: application/json');

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['otp_input'])) {

    $otp = $data['otp_input'];
    // Validate OTP
    if (empty($otp)) {
        echo json_encode(['status' => 'error', 'message' => 'Please enter the OTP.']);
        exit;
    }
    if ($otp == $_SESSION['otp']) {
        
        $username = $_SESSION['email_id'];
        $sql = "SELECT * FROM user_master WHERE email_id = :username AND is_block !=1";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->execute();

        $user = $stmt->fetch(PDO::FETCH_ASSOC);        
        
            $_SESSION['user_id'] = $user['user_id'];
            $_SESSION['email_id'] = $user['email_id'];
            $_SESSION['category'] = $user['category'];
            $_SESSION['user_name'] = $user['user_name'];
            $_SESSION['institute_id'] = $user['institute_id'];
            
        echo json_encode(['status' => 'success', 'message' => 'OTP verified successfully. Logging in...']);
    } else {
        // Invalid OTP
        echo json_encode(['status' => 'error', 'message' => 'Please enter correct OTP']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'OTP is required.']);
}
?>