<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="shortcut icon" href="images/favicon.svg" type="image/x-icon">
    <link rel="icon" href="images/favicon.svg" type="image/x-icon">

    <title>EPIC LMS - Course</title>

    <link rel="stylesheet" href="assets/font-awesome/css/font-awesome.css">
    <link rel="stylesheet" href="assets/ionicons/css/ionicons.css">
    <link rel="stylesheet" href="css/master_style.css">
    <link rel="stylesheet" href="css/_all-skins.css">
    <link rel="stylesheet" href="css/custom.css">
    <link rel="stylesheet" href="assets/select2/dist/js/select2.min.css">
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css"/>
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css"/>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body { color: #5C2C8B; }
        .containers{ margin-left: 60px; margin-right: 60px; }
        .navbar { height: 100px; background: white; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1); display: flex; align-items: center; padding: 0 20px; }
        .navbar img { height: 100px; }
        .section { display: flex; align-items: center; justify-content: center; padding: 20px; }
        .left-section { display: flex; flex-direction: column; align-items: center; justify-content: center; height: 100%; }
        .btn-container { display: flex; gap: 10px; margin-top: 10px; }
        .left-section img { width: 100%; max-width: 350px; }
        .btn-custom { border-radius: 10px; font-size: 16px; text-transform: uppercase; padding: 10px 20px; margin: 5px; }
        .btn-start { background: #5C2C8B; color: white; }
        .btn-trial { background: white; border: 2px solid #5C2C8B; color: #5C2C8B; }
        .right-section h1 { font-size: 40px; font-weight: bold; }
        .right-section p { font-size: 15px; color: #5C2C8B; }
        .right-section p span { font-weight: bold; }
        .description { font-size: 14px; color: #707070; font-weight: normal; }
        .divider { border-top: 1px solid grey; margin: 10px 0; }
        .info-box1 { box-shadow: 0px 3px 6px #00000029; border: 0.30000001192092896px solid #5D2B8B; border-radius: 10px; padding: 20px; margin-top: 20px; text-align: center; }
        .info-box1 .col-md-4 { padding: 0 15px; }
        .info-box1 .col-md-4:not(:last-child) { border-right: 1px solid #5D2B8B; }
        .info-box1 h4 { font-size: 18px; font-weight: bold; }
        .info-box1 p { font-size: 14px; margin: 5px 0; }
        @media (max-width: 768px) {
            .section { flex-direction: column; text-align: center; }
            .info-box1 .col-md-4 { border-right: none; border-bottom: 1px solid #5D2B8B; padding-bottom: 10px; margin-bottom: 10px; }
            .info-box1 .col-md-4:last-child { border-bottom: none; }
        }
        .tab-container { margin-top: 20px; }
        .shadow-tabs { box-shadow: 0px 3px 6px #00000029; border: 0.3px solid #5D2B8B; border-radius: 10px; display: flex; width: 100%; }
        .nav-tabs .nav-item { flex: 1; text-align: center; }
        .nav-tabs .nav-link { color: #5C2C8B; font-weight: bold; padding: 12px 15px; border-radius: 10px 10px 0 0; text-align: center; }
        .nav-tabs .nav-link.active { background-color: #5C2C8B; color: white; font-weight: bold; }
        .full-width-content { width: 100%; padding: 20px; font-size: 16px; font-weight: bold; color: #333; }
        .course-info-section { margin-top: 20px; }
        .title { font-size: 40px; font-weight: normal; color: #5C2C8B; margin-bottom: 15px; }
        .small-title { font-size: 18px; font-weight: bold; color: #5D2B8B; margin-bottom: 15px; text-align: left !important; }
        .small-title1 { font-size: 18px; font-weight: bold; color: #5D2B8B; margin-bottom: 10px; }
        .learning-list { list-style: none; padding-left: 0; margin: 0; }
        .learning-list li { font-size: 16px; color: #5C2C8B; font-weight: normal; display: flex; align-items: flex-start; text-align: left; gap: 10px; margin-bottom: 8px; }
        .arrow-icon { width: 14px; height: 14px; flex-shrink: 0; margin-top: 3px; }
        .skills-tags { display: flex; flex-wrap: wrap; gap: 10px; }
        .skill-tag { background: #F2E9FD; padding: 8px 12px; border-radius: 5px; font-size: 14px; color: #333; }
        .info-box1 .row { display: flex; justify-content: space-between; }
        .info-box1 .col-md-4 { flex: 1; padding-right: 15px; border-right: 1px solid #ccc; }
        .info-box1 .col-md-4:last-child { border-right: none; padding-right: 0; }
        .module-para{ font-size: 20px; color: #707070; font-weight: normal; margin-bottom: 15px; }
        .box { border: 1px solid #5D2B8B; border-radius: 5px; padding: 20px; background: #fff; margin: 20px 0; }
        .box-header { border-bottom: none !important; margin-bottom: 0px; }
        .box-title { font-size: 20px; color: #5D2B8B; font-weight: bold; }
        .box-body { display: flex; align-items: center; gap: 20px; flex-wrap: wrap; }
        .item { display: flex; align-items: center; font-size: 16px; }
        .img-icon { width: 14px; height: 14px; margin-right: 10px; }
        .item span { font-size: 14px; color: #707070; margin-right: 10px; font-weight: normal; }
        .testimonial-card { border: 1px solid #5D2B8B; border-radius: 5px; padding: 20px; background: #fff; margin: 10px; text-align: left; }
        .testimonial-name { font-weight: bold; color: #5D2B8B; margin-bottom: 2px; }
        .testimonial-role { font-size: 14px; color: #5D2C8B; margin-bottom: 10px; }
        .testimonial-text { font-size: 16px; color: #5D2B8B; margin-bottom: 10px; font-weight: normal; }
        .star-rating { color: gold; font-size: 18px; }
        .slick-slide { padding: 10px; }
        .course-card { background: #FFFFFF 0% 0% no-repeat padding-box; border: 1px solid #5D2B8B; border-radius: 10px; overflow: hidden; transition: 0.3s ease-in-out; margin-bottom: 20px; }
        .course-card:hover { transform: translateY(-5px); }
        .course-image { width: 100%; height: auto; }
        .course-title { background: #5D2B8B 0% 0% no-repeat padding-box; color: white; padding: 12px; text-align: center; font-size: 18px; font-weight: bold; }
        .course-body { padding: 15px; font-size: 14px; color: #707070; text-align: left; }
        .course-text { font-size: 16px; color: #707070; font-weight: normal; }
        .faq-section { margin: auto; padding: 35px; border: 1px solid #5D2B8B; border-radius: 5px; }
        .accordion-item { border-bottom: 1px solid #5D2B8B; overflow: hidden; }
        .accordion-button { background: none !important; color: #5D2B8B !important; font-weight: normal; border: none; box-shadow: none; font-size: 16px; }
        .accordion-button:focus { box-shadow: none; }
        .accordion-button:not(.collapsed) { color: #5D2B8B !important; }
        .accordion-body { color: #5D2B8B; padding: 15px; }
    </style>
</head>
<body>
    <nav class="navbar">
        <img src="images/epic-logo.svg" alt="EPIC LMS">
    </nav>

    <div class="containers">
        <section class="section">
            <div class="row">
                <div class="col-md-4 left-section">
                    <img id="courseImage" src="images/course1.png" alt="Course">
                    <br>
                    <div class="btn-container">
                        <a id="startCourseBtn" href="start_course.html" class="btn btn-primary btn-start">START NOW!</a>
                        <a href="course_master.php" class="btn btn-secondary btn-trial">Free Trial</a>
                    </div>
                </div>
                <div class="col-md-8 right-section">
                    <h1 id="courseTitle">Clinical Data Management Basics</h1>
                    <p><span>Mentors:</span> <span id="courseMentors">Mr. Deven K. Babre, Mr. Tushar Deshpande</span></p>
                    <!--<p><span>Industry Expert:</span> <span id="courseExperts">Dr. Suneela Dhaneshwar</span></p>-->
                    <p><span>Category:</span> <span id="courseCategory">N/A</span></p> <div class="divider"></div>
                    <p class="description" id="courseDescription">This course presents critical concepts and practical methods to support planning, collection, storage, and dissemination of data in clinical research. Understanding and implementing solid data management principles is critical for any scientific domain. Regardless of your current (or anticipated) role in the research enterprise, a strong working knowledge and skill set in data management principles and practice will increase your productivity and improve your science. Our goal is to use these modules to help you learn and practice this skill set.</p>
                    <div class="info-box1 row">
                        <div class="col-md-4">
                            <h4><span id="numModules">10</span> Modules</h4>
                            <p><span id="numVideos">10</span> videos</p>
                            <p><span id="numDocuments">10</span> Documents</p>
                        </div>
                        <div class="col-md-4">
                            <h4><span id="courseLevel">Beginner level</span></h4>
                            <p>No prior experience</p>
                            <p>required</p>
                        </div>
                        <div class="col-md-4">
                            <h4>Flexible schedule</h4>
                            <p>Approx. <span id="approxHours">25</span> hours</p>
                            <p>Learn at your own pace</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="tab-container">
            <ul class="nav nav-tabs shadow-tabs" id="courseTabs">
                <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="tab" href="#courseInfo">Course Information</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#modules">Modules</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#testimonials">Testimonials & Reviews</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#proposedCourses">Proposed Courses</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#faqs">FAQs</a>
                </li>
            </ul>

            <div class="tab-content full-width-content">
                <div id="courseInfo" class="tab-pane active">
                    <div class="course-info-section">
                        <h2 class="title">Course Information</h2>

                        <div class="info-box1">
                            <h4 class="small-title">What You'll Learn</h4>
                            <div class="row" id="whatYoullLearn">
                            </div>
                        </div>

                        <div class="info-box1">
                            <h4 class="small-title">Skills You'll Gain</h4>
                            <div class="skills-tags" id="skillsYoullGain">
                            </div>
                        </div>

                        <div class="info-box1">
                            <div class="row">
                                <div class="col-md-4">
                                    <h4 class="small-title1">Details to know</h4>
                                    <p>Shareable certificate</p>
                                    <p>Add to your LinkedIn profile</p>
                                </div>
                                <div class="col-md-4">
                                    <h4 class="small-title1">Assessments</h4>
                                    <!--<p><span id="numAssignments">6</span> assignments</p>-->
                                    <p><span id="numQuizzes">10</span> Quizzes</p>
                                </div>
                                <div class="col-md-4">
                                    <h4 class="small-title1">Language</h4>
                                    <p id="courseLanguage">English</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="modules" class="tab-pane">
                    <div class="module-section">
                        <h2 class="title">Modules</h2>
                        <div id="moduleIntroduction">
                            <h4 class="small-title">INTRODUCTION</h4>
                            <p class="module-para" id="introParagraph1">This course presents critical concepts and practical methods to support planning, collection, storage, and dissemination of data in clinical research.</p>
                            <p class="module-para" id="introParagraph2">Understanding and implementing solid data management principles is critical for any scientific domain. Regardless of your current (or anticipated) role in the research enterprise, a strong working knowledge and skill set in data management principles and practice will increase your productivity and improve your science. Our goal is to use these modules to help you learn and practice this skill set.</p>
                        </div>
                        <div id="modulesContent">
                        </div>
                    </div>
                </div>

                <div id="testimonials" class="tab-pane">
                    <div class="testimonial-section">
                        <h2 class="title">Testimonials & Reviews</h2>
                        <div class="testimonial-slider">
                        </div>
                    </div>
                </div>

                <div id="proposedCourses" class="tab-pane">
                    <div>
                        <h2 class="title">Proposed Courses</h2>
                        <div class="row" id="proposedCoursesContent">
                        </div>
                    </div>
                </div>

                <div id="faqs" class="tab-pane">
                    <div class="faq-section">
                        <h2 class="title">FAQs</h2>
                        <div class="accordion" id="faqAccordion">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/jquery/dist/jquery.min.js"></script>
    <script src="assets/select2/dist/js/select2.full.js"></script>
    <script src="assets/moment/min/moment.min.js"></script>
    <script src="assets/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="assets/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="assets/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
    <script src="assets/timepicker/bootstrap-timepicker.min.js"></script>
    <script src="assets/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/vendor_components/jquery/dist/jquery.min.js"></script>
    <script src="assets/vendor_components/jquery-slimscroll/jquery.slimscroll.js"></script>
    <script src="assets/vendor_components/fastclick/lib/fastclick.js"></script>
    <script src="../js/template.js"></script>
    <script src="js/demo.js"></script>
    <script src="assets/vendor_plugins/bootstrap-slider/bootstrap-slider.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        $(document).ready(function() {
            // Function to fetch and display course data
            function fetchCourseData() {
                const urlParams = new URLSearchParams(window.location.search);
                const courseId = urlParams.get('id');
                
                const startButton = document.getElementById('startCourseBtn');
                
                if (courseId) {
                startButton.href = 'start_course.php?id=' + courseId;
                } else {
                    console.warn('No course ID found in URL. START NOW! button may not function as expected.');
                }

                if (!courseId) {
                    console.error("No course ID provided in the URL. Please provide an 'id' parameter (e.g., course.html?id=123).");
                    // Using an alert for visibility, consider a more graceful UI update
                    $('#courseContent').html('<p class="text-danger">No course ID specified. Please select a course to view.</p>');
                    return;
                }

                let apiUrl = 'apis/fetch_course_data.php?id=' + courseId; // Ensure this path is correct

                $.ajax({
                    url: apiUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data && !data.error) {
                            // Populate main course details
                            $('#courseImage').attr('src', data.course_img ? 'images/course_image/' + data.course_img : 'images/course1.png');
                            $('#courseTitle').text(data.course_title);

                            // Populate Mentors (now an array of objects)
                            if (data.mentors && data.mentors.length > 0) {
                                const mentorNames = data.mentors.map(mentor => mentor.mentor_name).join(', ');
                                $('#courseMentors').text(mentorNames);
                            } else {
                                $('#courseMentors').text('N/A');
                            }

                            // Populate Industry Experts (now an array of objects)
                            if (data.industry_experts && data.industry_experts.length > 0) {
                                const expertNames = data.industry_experts.map(expert => expert.expert_name).join(', '); // Assuming expert_name column
                                $('#courseExperts').text(expertNames);
                            } else {
                                $('#courseExperts').text('N/A');
                            }

                            $('#courseDescription').text(data.course_description);
                            $('#numModules').text(data.total_modules_count || 'N/A');
                            $('#numVideos').text(data.total_course_videos !== undefined && data.total_course_videos !== null ? data.total_course_videos : 'N/A');
                            $('#numDocuments').text(data.total_course_docs || 'N/A');
                            $('#courseLevel').text(data.level ? 'Level ' + data.level : 'Beginner level'); 
                            $('#approxHours').text(data.approx_hours || '25');
                            $('#numAssignments').text(data.no_of_assignments || 'N/A');
                            $('#numQuizzes').text(data.total_quizzes || 'N/A');
                            $('#courseLanguage').text( (data.language ? data.language.charAt(0).toUpperCase() + data.language.slice(1) : 'English') );

                            // Populate Course Category Name (now a direct string)
                            $('#courseCategory').text(data.course_category_name || 'N/A');


                            // Populate "What You'll Learn"
const whatYoullLearnContainer = $('#whatYoullLearn');
whatYoullLearnContainer.empty(); // Clear existing content

if (data.what_youll_learn && Array.isArray(data.what_youll_learn)) {
    const learningPoints = data.what_youll_learn; // Assume it's already an array
    const half = Math.ceil(learningPoints.length / 2);

    // Create the column wrappers with the list Uls inside
    let col1 = $('<div class="col-md-6"><ul class="learning-list"></ul></div>');
    let col2 = $('<div class="col-md-6"><ul class="learning-list"></ul></div>');

    learningPoints.forEach((point, index) => {
        // Ensure the point is a string to prevent potential issues
        const listItem = `<li><img src="images/triangle.png" class="arrow-icon">${String(point)}</li>`;
        if (index < half) {
            col1.find('ul').append(listItem);
        } else {
            col2.find('ul').append(listItem);
        }
    });

    whatYoullLearnContainer.append(col1).append(col2);
} else {
    // Optional: Handle cases where 'what_youll_learn' is missing or not an array
    console.warn("No 'what_youll_learn' data found or it's not an array.");
}


// Populate "Skills You'll Gain"
const skillsYoullGainContainer = $('#skillsYoullGain');
skillsYoullGainContainer.empty(); // Clear existing content

if (data.skills_gain && Array.isArray(data.skills_gain)) {
    const skills = data.skills_gain; // Assume it's already an array
    skills.forEach(skill => {
        // Ensure the skill is a string for rendering
        skillsYoullGainContainer.append(`<span class="skill-tag">${String(skill)}</span>`);
    });
} else {
    // Optional: Handle cases where 'skills_gain' is missing or not an array
    console.warn("No 'skills_gain' data found or it's not an array.");
}

                            // Populate Modules section - Still assumes this is a JSON string in course_draft table
                            const modulesContent = $('#modulesContent');
modulesContent.empty();

if (data.modules_details && Array.isArray(data.modules_details)) {
    data.modules_details.forEach((module, index) => {
        // Retrieve the pre-calculated counts directly from the module object
        // module_videos: videos directly in this module
        // module_docs: documents directly in this module
        // module_quizzes_count: quizzes directly associated with this module
        // submodules_count: number of submodules belonging to this module
        const moduleVideoCount = module.module_videos || 0;
        const moduleDocCount = module.module_docs || 0;
        const moduleQuizCount = module.combined_quizzes_count || 0;
        const submoduleCount = module.submodules_count || 0;

        // Note:
        // module.combined_videos and module.combined_docs contain the total
        // videos/documents for the module INCLUDING its submodules.
        // Use these if you want to show a combined total instead of just module-direct content.

        const moduleHtml = `
            <div class="box">
                <div class="box-header with-border">
                    <h4>Module ${index + 1}</h4>
                    <h4 class="small-title">${module.module_name}</h4>
                </div>
                <div class="box-body">
                    <div class="item">
                        <img src="images/play.svg" class="img-icon">
                        <span>${moduleVideoCount} Videos</span>
                    </div>
                    <div class="item">
                        <img src="images/doc.svg" class="img-icon">
                        <span>${moduleDocCount} Docs</span>
                    </div>
                    <div class="item">
                        <img src="images/doc.svg" class="img-icon">
                        <span>${moduleQuizCount} Quiz</span>
                    </div>
                    <div class="item">
                        <img src="images/doc.svg" class="img-icon"> <span>${submoduleCount} Submodules</span>
                    </div>
                </div>
            </div>
        `;
        modulesContent.append(moduleHtml);
    });
} else {
    console.warn("data.modules_details is missing or not an array.");
}

                            // Populate Testimonials (now 'testimonials_details' array of objects)
                            const testimonialSlider = $('.testimonial-slider');
                            // Only unslick if slick has been initialized, otherwise it will throw an error
                            if (testimonialSlider.hasClass('slick-initialized')) {
                                testimonialSlider.slick('unslick');
                            }
                            testimonialSlider.empty(); // Clear existing testimonials
                            if (data.testimonials_details && data.testimonials_details.length > 0) {
                                const testimonials = data.testimonials_details;
                                testimonials.forEach(testimonial => {
                                    // Corrected star character
                                    const stars = '⭐'.repeat(testimonial.rating || 0); // Assuming 'rating' field in testimonial
                                    const testimonialHtml = `
                                        <div class="testimonial-card">
                                            <p class="testimonial-name">${testimonial.testimonial_name}</p>
                                            <p class="testimonial-role">Learner since ${testimonial.learner_since}</p>
                                            <p class="testimonial-text">"${testimonial.testimonial_text}"</p>
                                            <div class="star-rating">⭐⭐⭐⭐</div>
                                        </div>
                                    `;
                                    testimonialSlider.append(testimonialHtml);
                                });
                                // Reinitialize slick carousel after adding new slides
                                
                            }

                            // Populate Proposed Courses (now 'proposed_courses_details' array of objects)
                            const proposedCoursesContent = $('#proposedCoursesContent');
                            proposedCoursesContent.empty();
                            if (data.proposed_courses_details && data.proposed_courses_details.length > 0) {
                                const proposedCourses = data.proposed_courses_details;
                                proposedCourses.forEach(course => {
                                    const courseHtml = `
                                        <div class="col-md-4">
                                            <div class="course-card">
                                                <img src="${course.course_img ? 'images/course_image/' + course.course_img : 'images/course1.png'}" alt="Course Image" class="course-image">
                                                <div class="course-title">${course.course_title}</div>
                                                <div class="course-body">
                                                    <p class="course-text">${course.course_description}</p>
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                    proposedCoursesContent.append(courseHtml);
                                });
                            }

                            // Populate FAQs (now 'faq_details' array of objects)
                            const faqAccordion = $('#faqAccordion');
                            faqAccordion.empty();
                            if (data.faq_details && data.faq_details.length > 0) {
                                const faqs = data.faq_details;
                                faqs.forEach((faq, index) => {
                                    const faqHtml = `
                                    
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="faqHeading${faq.faq_id}">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse${faq.faq_id}">
                                                    Q${index + 1} : ${faq.faq_question}
                                                </button>
                                            </h2>
                                            <div id="faqCollapse${faq.faq_id}" class="accordion-collapse collapse" aria-labelledby="faqHeading${faq.faq_id}" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                    ${faq.faq_answer}
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                    faqAccordion.append(faqHtml);
                                });
                            }

                        } else {
                            console.error('Error fetching course data:', data.error || 'No data received.');
                            $('#courseContent').html('<p class="text-danger">Failed to load course details. ' + (data.error || 'Please try again later.') + '</p>');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        $('#courseContent').html('<p class="text-danger">A network error occurred while fetching course data. Please check your internet connection and try again.</p>');
                    }
                });
            }

            // Initial call to fetch course data when the page loads
            fetchCourseData();
        });
    </script>
</body>
</html>