<?php
$page_name = 'Course Category List';
require_once('includes/connection.php');
require_once('includes/header.php');

$category_session = $_SESSION['category'];

$decoded_category_id = null;
if (isset($_GET['category_id'])) {
    $decoded_category_id = base64_decode($_GET['category_id']);
}
?>

<div id="page-loader" style="display:none;">
    <div class="loader" id="loader-2">
        <span></span><span></span><span></span>
    </div>
</div>

<div class="content-wrapper">
    <section class="content-header">
        <span style="margin-left: 10px;" id="category_name"></span>
        <ol class="breadcrumb">
            <li><a href="masters.php">Masters</a></li>
            <li class="active">Course Category</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-4 response-msg" id="responseMessage"></div>
                <div class="box-body table-padding">
                    <table id="dataGrid" class="table display">
                        <thead style="background: #FAF7FE;">
                            <tr>
                                <th>Sr. No.</th>
                                <th>Course Name</th>
                                <th>No Of Licenses</th>
                                <th>Course Fees</th>
                                <th>Start Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
const selectedCategoryId = <?php echo json_encode($decoded_category_id); ?>;

$(document).ready(function () {
    const dataTable = $('#dataGrid').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        language: { search: "Search:" },
        ajax: {
            url: 'apis/course_api.php',
            type: 'POST',
            data: function (d) {
                d.sortField = $('#sortField').val();
                d.sortDir = 'asc';
                d.category_id = selectedCategoryId;
            },
            beforeSend: function () {
                $('#page-loader').show();
            },
            complete: function (xhr) {
                $('#page-loader').hide();
                try {
                    const response = JSON.parse(xhr.responseText);
                    const data = response.data || [];
                    if (data.length === 0) {
                        $('#category_name').text("Category Name: Not Found");
                    } else {
                        $('#category_name').text("Category Name: " + data[0].course_category);
                    }
                } catch (e) {
                    $('#category_name').text("Category Name: Not Found");
                }
            },
            error: function (xhr, error, thrown) {
                console.error('Error loading data:', thrown);
            }
        },
        columns: [
            { data: null, render: (data, type, row, meta) => meta.row + meta.settings._iDisplayStart + 1 },
            { data: 'course_title' },
            { data: 'no_of_licenses' },
            { data: 'course_fees' },
            { data: 'start_date' },
            {
                data: 'course_id',
                render: (id, type, row) => {
                    const encId = btoa(id.toString());
                    const startDate = row.start_date;
                    const current_date = new Date().toISOString().split('T')[0];
                    let actions = ``;

                    if (startDate > current_date) {
                        actions += `<a href="add_course.php?course=${encId}">
                                        <img src="images/edit.svg" style="margin-left: 10px;" title="Edit" />
                                    </a>`;
                    }

                    actions += `<a href="course_details.php?id=${encId}" target="_blank">
                                    <img src="images/view.svg" style="margin-left: 10px; width: 24px;" title="View Course" />
                                </a>`;

                    if ('<?php echo $category_session; ?>' === 'superadmin') {
                        actions += `<a href="javascript:void(0);" class="delete-course" data-course-id="${id}">
                                        <img src="images/delete.svg" style="margin-left: 10px; width: 24px;" title="Delete Course" />
                                    </a>`;
                    }

                    actions += `<a href="javascript:void(0);">
                                    <i class="fa fa-clone duplicate-course" 
                                       data-course-id="${id}" 
                                       style="margin-left: 10px; background: #5D2B8B; border-radius: 50%; padding: 7px; color: #fff; font-size: 12px;" 
                                       title="Clone Course"></i>
                                </a>`;

                    if (row.is_publish == 1) {
                        actions += `<span style="margin-left: 10px; color: green; font-weight: bold;">Published</span>`;
                    } else {
                        actions += `<a href="javascript:void(0);">
                                        <i class="fa fa-upload publish-course" 
                                           data-course-id="${id}" 
                                           style="margin-left: 10px; background: #5D2B8B; border-radius: 50%; padding: 7px; color: #fff; font-size: 12px;" 
                                           title="Publish Course"></i>
                                    </a>`;
                    }

                    return actions;
                }
            }
        ],
        initComplete: function () {
            const searchInput = $('#dataGrid_filter input');
            const searchWidth = searchInput.outerWidth();
            const sortHtml = `<label style="margin-left: 10px;">
                                Sort By:
                                <select id="sortField" class="form-control input-sm" style="width: ${searchWidth}px; display:inline-block; margin-left:5px;">
                                    <option value="course_title">Course Name</option>
                                    <option value="no_of_licenses">Licenses</option>
                                    <option value="course_fees">Course Fees</option>
                                    <option value="start_date">Start Date</option>
                                </select>
                              </label>`;
            $('#dataGrid_filter').append(sortHtml);
        }
    });

    // Duplicate course
    $('#dataGrid').on('click', '.duplicate-course', function () {
        const courseId = $(this).data('course-id');
        if (confirm("Are you sure you want to duplicate this course?")) {
            $.post('apis/duplicate_course_api.php', { course_id: courseId }, function (data) {
                if (data.status === 'success') {
                    dataTable.ajax.reload();
                    showAlert(data.message, 'success');
                } else {
                    showAlert(data.message, 'danger');
                }
            }, 'json').fail(() => {
                showAlert('Failed to duplicate course. Please try again.', 'danger');
            });
        }
    });

    // Delete course
    $('#dataGrid').on('click', '.delete-course', function () {
        const courseId = $(this).data('course-id');
        if (!confirm("Are you sure you want to delete this course?")) return;

        $.ajax({
            url: 'apis/delete_course_api.php',
            method: 'POST',
            data: { course_id: courseId },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    showAlert(response.message, 'success');
                    dataTable.ajax.reload();
                } else {
                    showAlert(response.message, 'danger');
                }
            },
            error: function () {
                showAlert('An error occurred while deleting the course.', 'danger');
            }
        });
    });

    // Sort change
    $(document).on('change', '#sortField', function () {
        dataTable.ajax.reload();
    });

    // Publish course - only send course_id, nothing else
    $(document).on('click', '.publish-course', function () {
        const btn = $(this);
        const courseId = btn.data('course-id');
        if (!courseId) return alert('Error: No course ID found.');
        if (!confirm('Are you sure you want to publish this course?')) return;

        $.ajax({
            url: 'apis/publish_course_api.php',
            method: 'POST',
            data: { course_id: courseId },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    showAlert(response.message, 'success');
                    dataTable.ajax.reload();
                } else {
                    showAlert(response.message, 'danger');
                }
            },
            error: function () {
                alert('An error occurred while trying to publish the course.');
            }
        });
    });

});
</script>




</body>
</html>