<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['module_ids']) || !is_array($data['module_ids'])) {
        echo json_encode(["status" => "error", "message" => "Module IDs are required."]);
        exit;
    }

    $course_id = $data['course_id'];
    $incomingModules = $data['module_ids'];

    // Get current modules from DB for this course
    $existingModulesStmt = $pdo->prepare("SELECT module_id FROM course_module WHERE course_id = :course_id");
    $existingModulesStmt->execute([':course_id' => $course_id]);
    $existingModules = $existingModulesStmt->fetchAll(PDO::FETCH_COLUMN);

    $inserted = [];
    $duplicates = [];
    $deleted = [];

    // Add new modules or mark duplicates
    foreach ($incomingModules as $module_id) {
        if (in_array($module_id, $existingModules)) {
            $duplicates[] = $module_id;
        } else {
            $insertStmt = $pdo->prepare("INSERT INTO course_module (module_id, course_id) VALUES (:module_id, :course_id)");
            $insertStmt->execute([
                ':module_id' => $module_id,
                ':course_id' => $course_id
            ]);
            $inserted[] = $module_id;
        }
    }

    // Remove modules that are in DB but not in incoming list
    foreach ($existingModules as $module_id) {
        if (!in_array($module_id, $incomingModules)) {
            $deleteStmt = $pdo->prepare("DELETE FROM course_module WHERE course_id = :course_id AND module_id = :module_id");
            $deleteStmt->execute([
                ':course_id' => $course_id,
                ':module_id' => $module_id
            ]);
            $deleted[] = $module_id;
        }
    }

    // Build message
    $messages = [];
    if (!empty($inserted)) $messages[] = count($inserted) . " module(s) added successfully.";
    //if (!empty($duplicates)) $messages[] = count($duplicates) . " module(s) were already assigned";
    if (!empty($deleted)) $messages[] = count($deleted) . " module(s) removed.";

    echo json_encode([
        "status" => "success",
        "inserted" => $inserted,
        "duplicates" => $duplicates,
        "deleted" => $deleted,
        "message" => implode(" ", $messages)
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database Error: " . $e->getMessage()
    ]);
}
?>