<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

try {
    // Use $_POST for jQuery AJAX
    if (!isset($_POST['submodule_name']) || empty(trim($_POST['submodule_name']))) {
        echo json_encode(["status" => "error", "message" => "Submodule name is required."]);
        exit;
    }
    
    if (!isset($_POST['module_id']) || empty(trim($_POST['module_id']))) {
        echo json_encode(["status" => "error", "message" => "Module name is required."]);
        exit;
    }  
    
    if (!isset($_POST['course_id']) || empty(trim($_POST['course_id']))) {
        echo json_encode(["status" => "error", "message" => "Course ID is required."]);
        exit;
    }    

    $module_id = trim($_POST['module_id']);
    $submodule_name = trim($_POST['submodule_name']);
    $course_id = trim($_POST['course_id']);


    $checkSql = "SELECT submodule_name FROM submodule_master WHERE submodule_name = :submodule_name AND institute_id = :institute_id";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->execute([
        ':submodule_name' => $submodule_name,
        ':institute_id' => $institute_id
    ]);

    if ($checkStmt->fetch()) {
        echo json_encode([
            "status" => "error",
            "message" => "A submodule with this name already exists for this course."
        ]);
        exit;
    }
    
    
    // Insert into module_master
    $insertModuleSql = "INSERT INTO submodule_master (submodule_name, module_id, institute_id, created_by) VALUES (:submodule_name, :module_id, :institute_id, :created_by)";
    $stmt = $pdo->prepare($insertModuleSql);
    $stmt->bindParam(':submodule_name', $submodule_name);
    $stmt->bindParam(':module_id', $module_id);
    $stmt->bindParam(':institute_id', $institute_id);
    $stmt->bindParam(':created_by', $user_id);
    $stmt->execute();

    // Get the newly inserted module_id
    $newSubmoduleId = $pdo->lastInsertId();

    // Get current max sequence for this course_id
    $seqStmt = $pdo->prepare("SELECT MAX(sequence) FROM course_submodule WHERE course_id = :course_id");
    $seqStmt->execute([':course_id' => $course_id]);
    $maxSequence = $seqStmt->fetchColumn();
    $nextSequence = $maxSequence ? $maxSequence + 1 : 1;

    // Insert into course_module with sequence
    $insertCourseModuleSql = "INSERT INTO course_submodule (submodule_id, module_id, course_id, sequence) VALUES (:submodule_id, :module_id, :course_id, :sequence)";
    $stmt2 = $pdo->prepare($insertCourseModuleSql);
    $stmt2->bindParam(':submodule_id', $newSubmoduleId);
    $stmt2->bindParam(':module_id', $module_id); 
    $stmt2->bindParam(':course_id', $course_id);
    $stmt2->bindParam(':sequence', $nextSequence);
    $stmt2->execute();

    echo json_encode([
        "status" => "success",
        "message" => "Submodule created and assigned successfully.",
        "module_id" => $newSubmoduleId,
        "sequence" => $nextSequence
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database Error: " . $e->getMessage()
    ]);
}
?>