<?php
require_once('../includes/connection.php');
session_start();
header('Content-Type: application/json');

try {
    if (!isset($_SESSION['institute_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Institute not logged in']);
        exit;
    }

    $user_id = $_SESSION['user_id'];
    $institute_id = $_SESSION['institute_id'];
    $category = $_SESSION['category'];

    $isSuperadmin = ($category === 'superadmin' || $user_id == 1) ? 1 : 0;

    // Insert into course_master
    $stmt = $pdo->prepare("INSERT INTO course_master (institute_id, is_superadmin_course, created_by) VALUES (:institute_id, :is_superadmin_course, :created_by)");
    $stmt->bindParam(':institute_id', $institute_id);
    $stmt->bindParam(':is_superadmin_course', $isSuperadmin);
    $stmt->bindParam(':created_by', $user_id);
    $stmt->execute();

    $newCourseId = $pdo->lastInsertId();

    // If not superadmin, add entry to institute_courses
    if (!$isSuperadmin) {
        $insertCourseStmt = $pdo->prepare("INSERT INTO institute_courses (institute_id, course_id) VALUES (:institute_id, :course_id)");
        $insertCourseStmt->execute([
            ':institute_id' => $institute_id,
            ':course_id' => $newCourseId
        ]);
    }

    echo json_encode([
        'status' => 'success',
        'message' => 'Course created successfully',
        'course_id' => $newCourseId
    ]);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>