<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

$course_id = $_GET['course_id'] ?? null;

if (!$course_id) {
    echo json_encode(['status' => 'error', 'message' => 'Course ID is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT cm.*, im.folder_name
        FROM course_master cm
        JOIN institute_master im ON cm.institute_id = im.institute_id
        WHERE cm.course_id = ?
    ");
    $stmt->execute([$course_id]);
    $course = $stmt->fetch(PDO::FETCH_ASSOC);


    // Convert comma-separated fields to arrays for JS
    $course['mentor_ids'] = $course['mentor_ids'] ? explode(',', $course['mentor_ids']) : [];
    $course['industry_expert_ids'] = $course['industry_expert_ids'] ? explode(',', $course['industry_expert_ids']) : [];
    $course['testimonials'] = $course['testimonials'] ? explode(',', $course['testimonials']) : [];
    $course['proposed_courses'] = $course['proposed_courses'] ? explode(',', $course['proposed_courses']) : [];
    $course['faq_ids'] = $course['faq_ids'] ? explode(',', $course['faq_ids']) : [];

    echo json_encode(['status' => 'success', 'data' => $course]);
}
 catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>