<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');
$institute_id = $_SESSION['institute_id'];

try {
    $course_id = $_GET['course_id'] ?? null;
    if (!$course_id) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Missing course_id'
        ]);
        exit;
    }
    
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }
    

    // Step 1: Get modules assigned to course
    $stmt = $pdo->prepare("
        SELECT DISTINCT cm.module_id, mm.module_name, mm.study_material
        FROM course_module cm
        JOIN module_master mm ON cm.module_id = mm.module_id
        WHERE cm.course_id = ? ORDER BY sequence ASC");
    $stmt->execute([$course_id]);
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $finalData = [];

    foreach ($modules as $module) {
        $materialIds = array_filter(explode(',', $module['study_material']));
        $studyMaterials = [];

        if (!empty($materialIds)) {
            $placeholders = implode(',', array_fill(0, count($materialIds), '?'));
            $stmt = $pdo->prepare("
                SELECT study_material_id, title, vimeo_link, original_file_name, actual_file_name
                FROM study_material
                WHERE study_material_id IN ($placeholders)
            ");
            $stmt->execute($materialIds);
            $studyMaterials = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }

        $finalData[] = [
            'module_id' => $module['module_id'],
            'module_name' => $module['module_name'],
            'study_materials' => $studyMaterials,
            'folder_name' => $currentFolder
        ];
    }

    echo json_encode([
        'status' => 'success',
        'data' => $finalData
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'DB Erro: ' . $e->getMessage()
    ]);
}