<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');
$institute_id = $_SESSION['institute_id'];

try {
    $course_id = $_GET['course_id'] ?? null;
    if (!$course_id) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Missing course_id'
        ]);
        exit;
    }


    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }
    
    
    // Step 1: Get submodules assigned to course
    $stmt = $pdo->prepare("SELECT DISTINCT csm.submodule_id, csm.module_id, sm.submodule_name, sm.study_material,
        mm.module_name FROM course_submodule csm
        JOIN submodule_master sm ON csm.submodule_id = sm.submodule_id
        JOIN module_master mm ON csm.module_id = mm.module_id
        WHERE csm.course_id = ?
    ");
    
    $stmt->execute([$course_id]);
    $submodules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $finalData = [];

    foreach ($submodules as $submodule) {
        $materialIds = array_filter(explode(',', $submodule['study_material']));
        $studyMaterials = [];

        if (!empty($materialIds)) {
            $placeholders = implode(',', array_fill(0, count($materialIds), '?'));
            $stmt = $pdo->prepare("
                SELECT study_material_id, title, vimeo_link, actual_file_name, original_file_name
                FROM study_material
                WHERE study_material_id IN ($placeholders)
            ");
            $stmt->execute($materialIds);
            $studyMaterials = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }

        $finalData[] = [
            'module_id' => $submodule['module_id'],
            'module_name' => $submodule['module_name'],
            'submodule_id' => $submodule['submodule_id'],
            'submodule_name' => $submodule['submodule_name'],
            'study_materials' => $studyMaterials,
            'folder_name' => $currentFolder
        ];
    }

    echo json_encode([
        'status' => 'success',
        'data' => $finalData
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'DB Erro: ' . $e->getMessage()
    ]);
}