<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : 0;

    $sql = "
        SELECT 
            DISTINCT mm.module_id, 
            mm.module_name,
            CASE 
                WHEN cm.course_id IS NOT NULL THEN 1
                ELSE 0
            END AS is_selected
        FROM module_master mm
        LEFT JOIN course_module cm ON mm.module_id = cm.module_id AND cm.course_id = :course_id
        ORDER BY mm.module_name ASC
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':course_id', $course_id, PDO::PARAM_INT);
    $stmt->execute();
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($modules) {
        echo json_encode([
            "status" => "success",
            "data" => $modules
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No modules found"
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>