<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $course_id = isset($_POST['course_id']) ? intval($_POST['course_id']) : 0;
    $module_ids = $_POST['module_ids'] ?? '';

    // Convert module_ids string to integer array
    $moduleIdsArray = array_filter(array_map('intval', explode(',', $module_ids)));

    if (empty($moduleIdsArray)) {
        echo json_encode([
            "status" => "error",
            "message" => "No module IDs provided"
        ]);
        exit;
    }

    // Create placeholders for IN clause
    $placeholders = implode(',', array_fill(0, count($moduleIdsArray), '?'));

    $sql = "
        SELECT 
            DISTINCT smm.submodule_id, smm.module_id, 
            smm.submodule_name,
            CASE 
                WHEN csm.course_id IS NOT NULL THEN 1
                ELSE 0
            END AS is_selected
        FROM submodule_master smm
        LEFT JOIN course_submodule csm 
            ON smm.submodule_id = csm.submodule_id AND csm.course_id = ?
        WHERE smm.module_id IN ($placeholders)
        ORDER BY smm.submodule_name ASC
    ";

    $stmt = $pdo->prepare($sql);

    // Merge course_id with module IDs for execute
    $params = array_merge([$course_id], $moduleIdsArray);

    $stmt->execute($params);
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($modules) {
        echo json_encode([
            "status" => "success",
            "data" => $modules
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No submodules found"
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>