<?php
require_once('../includes/connection.php');
require_once('vimeo_upload.php');
header('Content-Type: application/json');
ignore_user_abort(true);
set_time_limit(0);

$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['action'] === 'upload_single_study_sub') {
    try {
        $submodule_id = intval($_POST['submodule_id'] ?? 0);
        $module_id = intval($_POST['module_id'] ?? 0);
        $title = trim($_POST['title'] ?? '');
        $file = $_FILES['file'] ?? null;
        $category_id = $_POST['category_id'] ?? null;

        if (!$title || !$file || !$module_id || !$institute_id || !$submodule_id) {
            echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
            exit;
        }
        
        
        if (!$category_id) {
            echo json_encode(['status' => 'error', 'message' => 'Missing category_id']);
            exit;
        }        

        $fileType = mime_content_type($file['tmp_name']);
        $isVideo = strpos($fileType, 'video/') === 0;

        $vimeo_link = '';
        $video_id = '';
        $actual_file_name = $file['name'];
        $original_file_name = $file['name'];
        $doc_type = 'file'; // default

        if ($isVideo) {
            // Upload video to Vimeo
            $uploadResult = uploadStudyMaterial($file, $title, '');
            if (!$uploadResult || !$uploadResult['success']) {
                echo json_encode([
                    'status' => 'error',
                    'message' => $uploadResult['message'] ?? 'Vimeo upload failed'
                ]);
                exit;
            }

            $vimeo_link = $uploadResult['video_link'];
            $video_id = $uploadResult['video_id'] ?? '';
            $doc_type = 'video';
            
            require('../includes/connection.php');

        } else {
            // Validate file extension
            $allowedExts = ['pdf', 'jpg', 'jpeg', 'png', 'ppt', 'pptx', 'txt'];
            $fileExt = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            if (!in_array($fileExt, $allowedExts)) {
                echo json_encode(['status' => 'error', 'message' => 'Unsupported file type.']);
                exit;
            }

            // Get folder_name from institute_master
            $stmt = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
            $stmt->execute([':institute_id' => $institute_id]);
            $folderName = $stmt->fetchColumn();

            if (!$folderName) {
                echo json_encode(['status' => 'error', 'message' => 'Institute folder not found. Please log in again and try.']);
                exit;
            }

            // Prepare upload path
            $uploadDir = "../institutes/$folderName/study_materials/";
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $encryptedName = hash('sha256', uniqid('', true)) . '.' . $fileExt;
            $targetPath = $uploadDir . $encryptedName;

            if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
                echo json_encode(['status' => 'error', 'message' => 'File upload failed']);
                exit;
            }

            $actual_file_name = $encryptedName;
        }

        // Insert study material
        $insertStmt = $pdo->prepare("
            INSERT INTO study_material (title, vimeo_link, original_file_name, actual_file_name, doc_type, institute_id, category_id)
            VALUES (:title, :vimeo_link, :original_file_name, :actual_file_name, :doc_type, :institute_id, :category_id)
        ");
        $insertStmt->execute([
            ':title' => $title,
            ':vimeo_link' => $vimeo_link,
            ':original_file_name' => $original_file_name,
            ':actual_file_name' => $actual_file_name,
            ':doc_type' => $doc_type,
            ':institute_id' => $institute_id,
            ':category_id' => $category_id
        ]);
        $study_material_id = $pdo->lastInsertId();

        // Attach to module
        $getStmt = $pdo->prepare("SELECT study_material FROM submodule_master WHERE submodule_id = :submodule_id");
        $getStmt->execute([':submodule_id' => $submodule_id]);
        $current = $getStmt->fetch(PDO::FETCH_ASSOC);

        $currentMaterialIds = $current && !empty($current['study_material'])
            ? explode(',', $current['study_material'])
            : [];

        if (!in_array($study_material_id, $currentMaterialIds)) {
            $currentMaterialIds[] = $study_material_id;
        }

        $updatedIds = implode(',', $currentMaterialIds);
        $updateStmt = $pdo->prepare("UPDATE submodule_master SET study_material = :study_material WHERE submodule_id = :submodule_id");
        $updateStmt->execute([
            ':study_material' => $updatedIds,
            ':submodule_id' => $submodule_id
        ]);

        echo json_encode([
            'status' => 'success',
            'video_id' => $video_id,
            'file' => $actual_file_name
        ]);

    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'Unexpected error: ' . $e->getMessage()]);
    }
    exit;
}