<?php
require_once('../includes/connection.php');
require('../vendor/autoload.php');

use Vimeo\Vimeo;

function uploadStudyMaterial($file, $title, $course_category)
{
    $clientId = "33aca9a43d56881867d184a6fd6812214c859d7f";
    $clientSecret = "RxhsebeBUpDtexh1NEy/wtvc6nygztKCQuLdumBH9brJxhYccpNdUDs2dbrBJgi8ERWF+5ey2jShRKRt5+zboo9Euza+5XIkgfnKhBSPEk0o9dT4W8FEZmUuKEl6td4b";
    $accessToken = "75e5b3cf9fecae07f07f254889398e20";

    $projectId = '25933804'; // question_videos folder
    $userId = '239261674';  // Your Vimeo user ID

    if ($file['error'] === UPLOAD_ERR_OK) {
        $fileTmp = $file['tmp_name'];
        $fileName = $file['name'];
        $fileType = mime_content_type($fileTmp);

        $allowedVideoTypes = ['video/mp4', 'video/avi', 'video/mov', 'video/mkv'];

        if (in_array($fileType, $allowedVideoTypes)) {
            $client = new Vimeo($clientId, $clientSecret, $accessToken);

            try {
                $uri = $client->upload($fileTmp, ["name" => $title]);

                $transcode = $client->request($uri . '?fields=transcode.status');
                $status = $transcode['body']['transcode']['status'];

                if ($status !== 'complete' && $status !== 'in_progress') {
                    return ['success' => false, 'message' => 'Video transcoding failed.'];
                }

                $videoId = str_replace('/videos/', '', $uri);

                $moveResponse = $client->request(
                    "/users/{$userId}/projects/{$projectId}/videos/{$videoId}",
                    [],
                    'PUT'
                );

                if ($moveResponse['status'] !== 204) {
                    return ['success' => false, 'message' => 'Failed to move video to folder.'];
                }

                $videoInfo = $client->request($uri . '?fields=link');
                $videoLink = $videoInfo['body']['link'];
                $get_vid_id = explode("/", $videoLink)[3];

                return [
                    'success' => true,
                    'message' => 'Video uploaded successfully.',
                    'video_link' => $videoLink,
                    'video_id' => $get_vid_id
                ];

            } catch (Exception $e) {
                return ['success' => false, 'message' => 'Vimeo Upload Error: ' . $e->getMessage()];
            }
        } else {
            return ['success' => false, 'message' => 'Unsupported video format.'];
        }
    } else {
        return ['success' => false, 'message' => 'Upload error with the file.'];
    }
}