<?php 
$page_name = 'Edit Course Category';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        EDIT COURSE CATEGORY
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="category_master.php">Category</a></li>
        <li class="active">Edit Course Category</li>
      </ol>
    </section>


    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">*All fields are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="categoryForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Category Name</label>
                                <input class="form-control" type="text" autocomplete="off" id="category_name" name="category_name" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                                    <input name="block_category" value="0" type="radio" id="Option_2" class="with-gap radio-col-red">
                                    <label for="Option_2">Active</label>
                                </div>
                                <div class="radio">
                                    <input name="block_category" value="1" type="radio" id="Option_1" class="with-gap radio-col-red">
                                    <label for="Option_1">Inactive</label>
                                </div>
                            </div>
                        </div>                        
                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="category_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </section>
  </div>
  
<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
    // Function to handle the form submission
    $('#categoryForm').on('submit', function(event) {
        event.preventDefault();

        const categoryName = $('#category_name').val();
        const status = $('input[name="block_category"]:checked').val();

        const urlParams = new URLSearchParams(window.location.search);
        const categoryId = urlParams.get('id');

        if (!categoryId) {
            alert('No category ID found in the URL!');
            return;
        }

        const requestData = {
            category_id: categoryId,
            category_name: categoryName,
            status: status,
        };

        $.ajax({
            url: 'apis/edit_category_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(requestData),
            success: function(data) {
                const responseMessage = $('#responseMessage');
                if (data.status === 'success') {
                    showAlert(data.message, 'success');
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function(error) {
                console.error('Error:', error);
                const responseMessage = $('#responseMessage');
                showAlert('An error occurred while updating the category.', 'danger');
            }
        });
    });

    const urlParams = new URLSearchParams(window.location.search);
    const categoryId = urlParams.get('id');

    if (categoryId) {
        prepopulateCategoryForm(categoryId);
    }
});

</script>

</body>
</html>