<?php
$page_name = 'Edit Institute';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            EDIT INSTITUTE
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php"> Masters</a></li>
            <li><a href="institute_master.php">Institute</a></li>
            <li class="active">Edit Institute</li>
        </ol>
    </section>


    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <p class="box-title">* Fields marked with an asterisk are required.</p>
                <div class="col-md-4 response-msg" id="responseMessage">
                </div>
            </div>

            <form id="instituteForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Institute Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="institute_name" name="institute_name" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone No. <span class="text-danger">*</span></label>
                                <input class="form-control" type="tel" pattern="\d{10}" maxlength="10" minlength="10" autocomplete="off" id="phone_no" name="phone_no" title="Please enter exactly 10 digits (numbers only)" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email ID <span class="text-danger">*</span></label>
                              <input class="form-control" type="email" autocomplete="new-email" id="email_id" name="email_id" pattern=".+\..{2,4}$" 
                              title="Please enter a valid email address" required />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Password <span class="text-danger">*</span></label>
                                    <input class="form-control" type="password" autocomplete="off" id="password" name="password" required>
                                        <span class="input-group-text password-eye" id="togglePassword">
                                            <i class="fa fa-eye" id="eyeIcon"></i> <!-- Eye Icon -->
                                        </span>                                        
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>City</label>
                                <input class="form-control" type="text" autocomplete="off" id="city" name="city">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>State</label>
                                <input class="form-control" type="text" autocomplete="off" id="state" name="state">
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Country</label>
                                <select class="form-control select2" id="country" name="country" data-placeholder="Select Country" style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Pincode</label>
                                <input class="form-control" type="text" autocomplete="off" id="pincode" name="pincode">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Select Course</label>
                                <select class="form-control select2" id="course" multiple="multiple" name="course[]" style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Institute Image</label>
                                <input class="form-control" type="file" autocomplete="off" id="institute_img" name="institute_img" accept="image/png, image/jpeg">
                            
                                    <div id="currentInstituteImage" style="margin-top:10px;">
            <img id="instituteImagePreview" src="" alt="Institute Image" style="max-height: 100px; border: 1px solid rgb(221, 221, 221); padding: 5px;">
        </div>
                            </div>
                        </div>                        

                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                                    <input name="block_institute" value="0" type="radio" id="Option_1" class="with-gap radio-col-red">
                                    <label for="Option_1">Active</label>
                                </div>
                                <div class="radio">
                                    <input name="block_institute" value="1" type="radio" id="Option_2" class="with-gap radio-col-red">
                                    <label for="Option_2">Inactive</label>
                                </div>
                            </div>
                        </div>

                    </div>

                    <hr>
                    <div class="box-header-title">
                        <p class="box-title">Contact Person Details</p>
                        <div class="col-md-4 response-msg" id="responseMessage">
                        </div>
                    </div>

                    <div class="row contact-group">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Contact Name</label>
                                <input class="form-control" type="text" name="contact_name[]">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Phone No.</label>
                                <input class="form-control" type="tel" pattern="\d{10}" maxlength="10" minlength="10" name="contact_phone[]" title="Please enter exactly 10 digits (numbers only)">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Email ID</label>
                                <input class="form-control" type="email" autocomplete="new-email" name="contact_email[]" pattern=".+\..{2,4}$" 
                              title="Please enter a valid email address">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <button type="button" class="btn btn-primary mb-25 mt-25 btn-circle" id="addMoreButton" style="border-radius: 50% !important;"><i class="fas fa-plus"></i></button>
                        </div>
                    </div>

                    <div id="additionalContactPersons"></div>


                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="institute_master.php" class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>


<?php require_once('includes/footer.php'); ?>

<script>

$(document).ready(function() {
    
        // Handle the "Add More" button click for contact persons
        // Use event delegation for dynamically added buttons
        $(document).on('click', '#addMoreButton', function() {
            const newInputHTML = `
                <div class="row contact-group">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Contact Name <span class="text-danger">*</span></label>
                            <input class="form-control" type="text" name="contact_name[]" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Phone No. <span class="text-danger">*</span></label>
                            <input class="form-control" type="tel" pattern="[0-9]{10}" maxlength="10" minlength="10" name="contact_phone[]" title="Please enter exactly 10 digits (numbers only)" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Email ID <span class="text-danger">*</span></label>
                            <input class="form-control" type="email" autocomplete="new-email" name="contact_email[]" pattern=".+\\..{2,4}$"
                              title="Please enter a valid email address" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-danger removeButton mb-25 mt-25 btn-circle" style="border-radius: 50% !important;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            `;
            $('#additionalContactPersons').append(newInputHTML);
        });

        // Event delegation for removing input fields
        $(document).on('click', '.removeButton', function() {
            $(this).closest('.contact-group').remove();
        });

        // Handle form submission
$('#instituteForm').on('submit', function(event) {
    event.preventDefault();

    const urlParams = new URLSearchParams(window.location.search);
    const instituteId = urlParams.get('id');

    if (!instituteId) {
        showAlert('No institute ID found in the URL!', 'danger');
        return;
    }

    const formData = new FormData();

    formData.append('institute_name', $('#institute_name').val());
    formData.append('phone_no', $('#phone_no').val());
    formData.append('email_id', $('#email_id').val());
    formData.append('password', $('#password').val());
    formData.append('city', $('#city').val());
    formData.append('state', $('#state').val());
    formData.append('country', $('#country').val());
    formData.append('pincode', $('#pincode').val());
    formData.append('block_institute', $('input[name="block_institute"]:checked').val());
    formData.append('institute_id', instituteId);

    // Append image file
    const imageFile = $('#institute_img')[0].files[0];
    if (imageFile) {
        formData.append('institute_img', imageFile);
    }

    // Append selected courses
    const selectedCourses = $('#course').val();
    if (selectedCourses && selectedCourses.length > 0) {
        selectedCourses.forEach(course => formData.append('selected_courses[]', course));
    }

    // Append contact persons
    $("input[name='contact_name[]']").each(function(i) {
        formData.append('contact_names[]', $(this).val());
    });
    $("input[name='contact_phone[]']").each(function(i) {
        formData.append('contact_phones[]', $(this).val());
    });
    $("input[name='contact_email[]']").each(function(i) {
        formData.append('contact_emails[]', $(this).val());
    });

    $.ajax({
        url: 'apis/edit_institute_api.php',
        method: 'POST',
        data: formData,
        contentType: false, // Important
        processData: false, // Important
        success: function(data) {
            if (data.status === 'success') {
                showAlert(data.message, 'success');
            } else {
                showAlert(data.message, 'danger');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            showAlert('An error occurred while submitting the form.', 'danger');
        }
    });
});

        
            const urlParams = new URLSearchParams(window.location.search);
    const employeeId = urlParams.get('id');

    if (employeeId) {
        prepopulateInstituteForm(employeeId);
    }

    });
</script>

</body>
</html>