<?php 
$page_name = 'Edit Module';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        EDIT MODULE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="module_master.php">Module</a></li>
        <li class="active">Edit Module</li>
      </ol>
    </section>


    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">*All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="moduleForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Module Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="module_name" name="module_name" required>
                            </div>
                        </div>
                        
                        

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Description (Optional)</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                                    <input name="block_module" value="0" type="radio" id="Option_2" class="with-gap radio-col-red">
                                    <label for="Option_2">Active</label>
                                </div>
                                <div class="radio">
                                    <input name="block_module" value="1" type="radio" id="Option_1" class="with-gap radio-col-red">
                                    <label for="Option_1">Inactive</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="module_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
        </div>
    </section>
  </div>
  
<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {
    const urlParams = new URLSearchParams(window.location.search);
    const moduleId = urlParams.get('id');

    if (moduleId) {
        prepopulateModuleForm(moduleId);
    }

    fetchSubmodules(); // Assuming you handle this elsewhere

    $('#moduleForm').on('submit', function (event) {
        event.preventDefault();

        if (!moduleId) {
            alert('No module ID found in the URL!');
            return;
        }

        const isActive = $("input[name='block_module']:checked").val();
        const formData = {
            module_name: $('#module_name').val(),
            description: $('#description').val(),
            module_id: moduleId,
            status: isActive
        };

        $.ajax({
            url: 'apis/edit_module_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            success: function (data) {
                if (data.status === 'success') {
                    showAlert(data.message, 'success');
                } else {
                    showAlert(data.message || 'Failed to update module.', 'danger');
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX Error:', error);
                showAlert('An error occurred while updating the module.', 'danger');
            }
        });
    });

});
</script>


</body>
</html>