<?php
$page_name = 'Edit Quiz';
require_once('includes/connection.php');
require_once('includes/header.php');
?>
<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">EDIT QUIZ</span>
    <ol class="breadcrumb">
      <li><a href="masters.php">Masters</a></li>
      <li><a href="quiz_master.php">Quiz</a></li>
      <li class="active">Edit Quiz</li>
    </ol>
  </section>
  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <p class="box-title">* Fields marked with an asterisk are required.</p>
        <div class="col-md-4 response-msg" id="responseMessage"></div>
      </div>
      <form id="quizForm" enctype="multipart/form-data">
        <div class="box-body">
          <div class="row">
            
            <div class="col-md-4">
              <div class="form-group">
                <label for="quizTitle">Quiz Title</label>
                <input type="text" id="quizTitle" name="quizTitle" class="form-control" required />
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label>Category Filter</label>
                <select class="form-control select2" id="category" name="category" style="width: 100%;"></select>
              </div>
            </div>
          </div>
        </div>
        <div class="box-body table-padding">
          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th><input type="checkbox" id="select-all" style="margin-top: -15px;" /></th>
                <th>Question</th>
                <th>Category</th>
                <th>Media</th>
              </tr>
            </thead>
          </table>
        </div>
        <div class="box-footer">
          <input type="hidden" name="selected_questions" id="selected_questions" />
          <button type="submit" class="btn btn-primary">Submit</button>
          <a href="quiz_master.php" class="btn btn-secondary">Back</a>
        </div>
      </form>
    </div>
  </section>
</div>
<?php require_once('includes/footer.php'); ?>
<script>
let dataTable;
let selectedQuestions = new Set();

$(document).ready(function () {
  populateCategories('category');

  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,
    language: { search: "Search:" },
    ajax: {
      url: 'apis/question_api.php',
      type: 'POST',
      data: function (d) {
        d.category_id = $('#category').val();
        d.criteria = 'quiz';
      },
      beforeSend: function () {
        $('#page-loader').show();
      },
      complete: function () {
        $('#page-loader').hide();
      }
    },
    columns: [
      {
        data: 'question_master_id',
        orderable: false,
        render: function (data) {
          const checked = selectedQuestions.has(data.toString()) ? 'checked' : '';
          return `<input type="checkbox" class="question-checkbox" value="${data}" ${checked}>`;
        }
      },
      { data: 'question' },
      { data: 'category_name' },
      { data: 'media' }
    ],
    initComplete: function () {
      $('#dataGrid_filter input[type=search]').addClass('responsive-input');
    }
  });

  $('#category').on('change', function () {
    dataTable.ajax.reload();
  });

  // Track checkbox changes
  $('#dataGrid').on('change', '.question-checkbox', function () {
    const id = this.value;
    this.checked ? selectedQuestions.add(id) : selectedQuestions.delete(id);

    const allVisible = $('#dataGrid .question-checkbox').length;
    const selectedVisible = $('#dataGrid .question-checkbox:checked').length;
    $('#select-all').prop('checked', allVisible > 0 && allVisible === selectedVisible);
  });

  // Handle "select all"
  $('#dataGrid').on('change', '#select-all', function () {
    const isChecked = this.checked;
    $('#dataGrid .question-checkbox').each(function () {
      this.checked = isChecked;
      const id = this.value;
      isChecked ? selectedQuestions.add(id) : selectedQuestions.delete(id);
    });
  });

  // Restore checkbox states on table redraw
  $('#dataGrid').on('draw.dt', function () {
    $('#dataGrid .question-checkbox').each(function () {
      const id = this.value;
      this.checked = selectedQuestions.has(id);
    });

    const allVisible = $('#dataGrid .question-checkbox').length;
    const selectedVisible = $('#dataGrid .question-checkbox:checked').length;
    $('#select-all').prop('checked', allVisible > 0 && allVisible === selectedVisible);
  });

  // Parse quizId from URL
  const urlParams = new URLSearchParams(window.location.search);
  const quizId = urlParams.get('id');

  // Submit form
  $('#quizForm').on('submit', function (e) {
    e.preventDefault();

    const selectedIds = Array.from(selectedQuestions);
    $('#selected_questions').val(JSON.stringify(selectedIds));

    const formData = new FormData(this);

    // ✅ Append quizId if present for edit operation
    if (quizId) {
      formData.append('quizId', quizId);
    }

    const endpoint = quizId ? 'apis/edit_quiz_api.php' : 'apis/add_quiz_api.php';

    fetch(endpoint, {
      method: 'POST',
      body: formData
    })
      .then(res => res.json())
      .then(response => {
        if (response.status === 'success') {
          showAlert(response.message, 'success');
        } else {
          showAlert(response.message, 'danger');
        }
      })
      .catch(error => {
        console.error(error);
        showAlert('An error occurred while processing your request.', 'danger');
      });
  });

  // Prepopulate form for editing
  if (quizId) {
    prepopulateQuizForm(quizId);
  }
});



</script>
</body>
</html>