<?php
$page_name = 'Edit Student';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            EDIT STUDENT
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php"> Masters</a></li>
            <li><a href="student_master.php">Student</a></li>
            <li class="active">Edit Student</li>
        </ol>
    </section>


    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-4 response-msg" id="responseMessage">
                </div>
            </div>

            <form id="studentForm" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="col-md-12">

                        <div class="form-group clearfix">
                            <label for="username" class="col-md-2 col-form-label text-color"><b>Personal Information</b></label>
                        </div>
                        
                        <div class="form-group clearfix">
                            <label for="email_address" class="col-md-2 col-form-label">Student Name</label>
                            <div class="col-md-4">
                                <input class="form-control" type="text" id="studentname" name="studentname" required>
                            </div>
                        </div>
                        
                        <div class="form-group clearfix">
                            <label for="email_address" class="col-md-2 col-form-label">Email Address</label>
                            <div class="col-md-4">
                                <input class="form-control" type="email" id="email_address" name="email_address" autocomplete="new-email" pattern=".+\..{2,4}$" 
                              title="Please enter a valid email address" oninput="updateUsername();"  required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label for="phone_number" class="col-md-2 col-form-label">Phone Number</label>
                            <div class="col-md-4">
                                <input class="form-control" type="tel" pattern="\d{10}" maxlength="10" minlength="10" autocomplete="off" id="phone_number" name="phone_number" title="Please enter exactly 10 digits (numbers only)" required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label for="date_of_birth" class="col-md-2 col-form-label">Date of Birth</label>
                            <div class="col-md-4">
                                <input class="form-control" type="date" id="date_of_birth" name="date_of_birth" required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label for="gender" class="col-md-2 col-form-label">Gender</label>
                            <div class="col-md-4">
                                <select class="form-control select2" id="gender" name="gender" style="width: 100%;" required>
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>

                            <div class="form-group clearfix">
                                <label class="col-md-2 col-form-label">Institute</label>
                                <div class="col-md-4">
                                <select class="form-control select2" id="institute" name="institute" style="width: 100%;" required>
                                    </select>
                                </div>    
                            </div>

                        <hr>

                        <div class="form-group clearfix">
                            <label for="username" class="col-md-2 col-form-label text-color"><b>Account Details</b></label>
                        </div>
                        
                        <div class="form-group clearfix">
                            <label for="username" class="col-md-2 col-form-label">Username</label>
                            <div class="col-md-4">
                                <input class="form-control" type="text" id="username" name="username" readonly>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label for="password" class="col-md-2 col-form-label">Password</label>
                            <div class="col-md-4">
                                <input class="form-control" type="password" id="password" name="password" value="*********" readonly>
                                <p class="help-block text-red">Password will be sent to the student's email address.</p>
                            </div>
                        </div>

                        <div class="box-footer mt-4" style="margin-top: 30px;">
                            <button type="submit" class="btn btn-primary" id="btnText">Register</button>
                            <button type="button" class="btn btn-secondary" onclick="window.location.href='student_master.php'">Cancel</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>


<?php require_once('includes/footer.php'); ?>

<script>

    function updateUsername() {
        const email = document.getElementById("email_address").value;
        document.getElementById("username").value = email;
    }

    $(document).ready(function () {


        $('#studentForm').on('submit', function (event) {
            event.preventDefault();

    const urlParams = new URLSearchParams(window.location.search);
    const instituteId = urlParams.get('id');

    if (!instituteId) {
        showAlert('No institute ID found in the URL!', 'danger');
        return;
    }  
    
        const $registerBtn = $('button[type="submit"]');
        $registerBtn.prop('disabled', true).text('Submitting...');
        
        
            const postData = {
                studentname: $('#studentname').val(),
                email_address: $('#email_address').val(),
                phone_number: $('#phone_number').val(),
                date_of_birth: $('#date_of_birth').val(),
                gender: $('#gender').val(),
                student_id: instituteId,
                institute_id: $('#institute').val()
            };

            $.ajax({
                url: 'apis/edit_student_api.php',
                type: 'POST',
                data: postData,
                dataType: 'json',
                success: function (data) {
                    if (data.status === 'success') {
                        showAlert(data.message, 'success');
                    } else {
                        showAlert(data.message, 'danger');
                    }
                    $registerBtn.prop('disabled', false).text('Register');
                },
                error: function (xhr, status, error) {
                    console.error('Error:', error);
                    showAlert('An error occurred while submitting the form.', 'danger');
                    $registerBtn.prop('disabled', false).text('Register');
                }
            });
        });
        
    const urlParams = new URLSearchParams(window.location.search);
    const employeeId = urlParams.get('id');

    if (employeeId) {
        prepopulateStudentForm(employeeId);
    }
    
    });
</script>
</body>
</html>