<?php 
$page_name = 'FAQ Master';
require_once('includes/connection.php');
require_once('includes/header.php');
?>


<div class="content-wrapper">
  <section class="content-header">
    <span style="margin-left: 10px;">FAQ Master</span>
    <a href="add_faq.php" style="float:right;" class="btn btn-primary">Add FAQ</a>
  </section>

  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg-table" id="responseMessage"></div>
        <div class="box-body table-padding">

          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th>Sr. No.</th>
                <th>Question</th>
                <th>Answer</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
          </table>

        </div>
      </div>
    </div>
  </section>
</div>


<?php require_once('includes/footer.php'); ?>

<script>
const sortState = {
  dir: 'desc',
  field: 'faq_id'
};

function deleteFaq(encodedId) {
  const decodedId = parseInt(atob(encodedId));
  if (confirm('Are you sure you want to delete this faq?')) {
    fetch('apis/delete_faq_api.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ faq_id: decodedId })
    })
    .then(res => res.json())
    .then(response => {
      if (response.status === 'success') {
        showAlert(response.message, 'success');
        dataTable.ajax.reload();
      } else {
        showAlert(response.message, 'danger');
      }
    })
    .catch(err => {
      console.error('Error:', err);
      alert('An error occurred while deleting.');
    });
  }
}

let dataTable;

const initDataTable = () => {
  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,
    columnDefs: [
      { width: "70px", targets: 0 },
      { width: "300px", targets: 1 },
      { width: "300px", targets: 2 },
      { width: "100px", targets: 3 },
      { width: "100px", targets: 4 },
    ],
    language: { search: "Search:" },
    ajax: {
      url: 'apis/faq_api.php',
      type: 'POST',
      data: d => {
        d.sortField = sortState.field;
        d.sortDir = sortState.dir;
      },
      beforeSend: () => $('#page-loader').show(),
      complete: () => $('#page-loader').hide()
    },
    columns: [
      {
        data: null,
        render: (d, t, r, meta) => meta.row + meta.settings._iDisplayStart + 1
      },
      { data: 'faq_question' },
      { data: 'faq_answer' },
      {
        data: 'is_block',
        render: data => data === '1' ? 'Inactive <span class="red-dot"></span>' : 'Active'
      },
      {
        data: 'faq_id',
        orderable: false,
        searchable: false,
        render: id => {
          const encId = btoa(id.toString());
          return `
            <a href="view_faq.php?id=${encId}"><img src="images/view.svg" /></a>
            <a href="edit_faq.php?id=${encId}"><img src="images/edit.svg" /></a>
            <a href="javascript:void(0);" onclick="deleteFaq('${encId}')">
              <img src="images/delete.svg" title="Delete FAQ" />
            </a>
          `;
        }
      }
    ],

    initComplete: () => {
      const w = $('#dataGrid_filter input').outerWidth();
      const sortUI = `
        <label style="margin-left:10px;">
          Sort By:
          <select id="sortField" class="form-control input-sm" style="width:${w}px;">
            <option value="faq_question">Question</option>
            <option value="faq_answer">Answer</option>
            <option value="is_block">Status</option>
          </select>
          <span id="sortToggleIcon" title="Sort Descending" style="cursor:pointer;">
            ${sortState.dir === 'desc' ? '▼' : '▲'}
          </span>
        </label>
      `;
      $('#dataGrid_filter').append(sortUI);

      $('#sortField').val(sortState.field).select2({
        placeholder: "Select Field",
        containerCssClass: 'select2-table-sort'
      });

      $('#dataGrid_length select').select2({
        minimumResultsForSearch: Infinity,
        containerCssClass: 'select2-table-sort'
      });
    }
  });
};

$(document).ready(() => {
  initDataTable();

  $(document).on('change', '#sortField', function () {
    sortState.field = $(this).val();
    dataTable.ajax.reload();
  });

  $(document).on('click', '#sortToggleIcon', function () {
    sortState.dir = (sortState.dir === 'desc') ? 'asc' : 'desc';
    $(this).text(sortState.dir === 'desc' ? '▼' : '▲')
           .attr('title', `Sort ${sortState.dir === 'desc' ? 'Descending' : 'Ascending'}`);
    dataTable.ajax.reload();
  });
});
</script>

</body>
</html>