<?php 
require_once('includes/login_header.php');
?>
<style>

@media only screen and (min-width: 769px) {
    .login-box {
        width: 30% !important;
    }
}
</style>
<body>
    <div class="login-box">
        <div class="login-box-body">
            <div class="row">
                <div class="col-md-12">
                    <p class="pl-15 mb-15 text-color">An email will be sent to your registered email ID.</p>

                    <form id="forgotPasswordForm" class="login-form">
                        <div class="error-message text-danger text-center"></div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="text-color">Email Address</label>
                                <input class="form-control login-textbox" type="email" autocomplete="off" id="email" name="email" required>
                            </div>
                        </div>


                        <div class="col-md-12" style="margin-bottom:20px;">
                            <button type="submit" class="btn btn-primary form-control" id="sendBtn">Send</button>
                        </div>            
                        <div class="success-message text-danger text-center"></div>
                    </form>

                    <div class="margin-top-30 text-center">
                        <p style="color:#5C2C8B;">Remember your password? <a href="index.php" class="text-info m-l-5 hover-underline" style="color:#5C2C8B;">Login here</a></p>
                    </div>

                </div>

                
            </div>
        </div>
    </div>

<?php require_once('includes/login_footer.php'); ?>

<script>
    $(document).ready(function () {
        $('#forgotPasswordForm').on('submit', function (e) {
            e.preventDefault();

            var email = $('#email').val();
            var sendBtn = $('#sendBtn');

            // Disable button and update text
            sendBtn.prop('disabled', true).text('Sending...');

            // Clear any previous messages
            $('.success-message').text('');
            $('.error-message').text('');

            $.ajax({
                url: 'apis/forgot_password.php',
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({ email: email }),
                success: function(response) {
                    console.log(response);
                    if (response.status) {
                        $('.success-message')
                            .removeClass('text-danger')
                            .addClass('text-success')
                            .text(response.message);
                        $('#email').val('');
                    } else {
                        $('.success-message')
                            .removeClass('text-success')
                            .addClass('text-danger')
                            .text(response.message);
                    }
                },
                error: function(xhr) {
                    $('.success-message')
                        .removeClass('text-success')
                        .addClass('text-danger')
                        .text('An error occurred. Please try again.');
                },
                complete: function () {
                    // Re-enable button and restore text after response (success or error)
                    sendBtn.prop('disabled', false).text('Send');
                }
            });
        });
    });
</script>


</body>
</html>