<?php
session_start();

$currentPage = basename($_SERVER['PHP_SELF']);

$page_class = isset($page_name) ? strtolower(str_replace(' ', '-', $page_name)) : '';


if (isset($_SESSION['category']) && $_SESSION['category'] != 'superadmin' && 
    ($currentPage == 'add_institute.php' || $currentPage == 'edit_institute.php' || $currentPage == 'institute_master.php')) {
    header("Location: access_denied.php");
    exit();
}

if (empty($_SESSION['category']) || empty($_SESSION['user_id']) || empty($_SESSION['email_id'])) {
    header("Location: logout.php");
    exit();
}

$category = $_SESSION['category'];
$user_id = $_SESSION['user_id'];
$email_id = $_SESSION['email_id'];
$institute_id = $_SESSION['institute_id'];
$user_name = $_SESSION['user_name'];

?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="shortcut icon" href="images/favicon.svg" type="image/x-icon">
    <link rel="icon" href="images/favicon.svg" type="image/x-icon">

    <title><?php echo $page_name; ?></title>

	<link rel="stylesheet" href="assets/bootstrap/css/bootstrap.css">

	<link rel="stylesheet" href="assets/font-awesome/css/font-awesome.css">

	<link rel="stylesheet" href="assets/ionicons/css/ionicons.css">

	<link rel="stylesheet" href="css/master_style.css">

	<link rel="stylesheet" href="css/_all-skins.css">
	
	<link rel="stylesheet" href="css/custom.css">
	
	<link rel="stylesheet" href="assets/select2/dist/js/select2.min.css">
	
	<link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
	
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  </head>
  
<div id="page-loader" style="display:none;">
  <div class="loader" id="loader-2">
    <span></span>
    <span></span>
    <span></span>
  </div>
</div>  
  
  <body class="hold-transition skin-blue sidebar-mini <?= $page_class ?>">
    <div class="wrapper">

  <header class="main-header">

    <a href="../../index.html" class="logo">
      <span class="logo-mini"><img src="images/short_logo.svg" /></span>
      <span class="logo-lg"><b>Cross</b>Admin</span>
    </a>
    <nav class="navbar navbar-static-top">
<a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
   <img src="images/left.svg" id="sidebar-toggle-icon" style="height: 20px;" />
</a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          
          <li>
            <a class="dropdown-toggle login-profile" data-toggle="dropdown">
                <?php echo $user_name; ?>
            </a>
          </li>          


<li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
              <i class="fa fa-user" style="font-size: 23px;
    color: #5D2B8B;"></i>
            </a>
            <ul class="dropdown-menu scale-up">
              <li class="user-footer">
                <div class="pull-left">
                  <a href="#" class="btn btn-default btn-flat">Settings</a>
                </div>
                <div class="pull-right">
                  <a href="logout.php" class="btn btn-default btn-flat">Sign out</a>
                </div>
              </li>
            </ul>
          </li>          
          
        </ul>
      </div>
    </nav>
  </header>

  <aside class="main-sidebar">
    <section class="sidebar">
      <div class="user-panel">
        <div class="image">
          <img src="images/logo.png" id="logo" class="img-circle" alt="User Image">
        </div>
      </div>

        <?php if($category == 'mentor' || $category == 'expert') {  ?>
        
        <ul class="sidebar-menu" data-widget="tree">
        <li>
          <a href="course_master_mentor.php">
            <img src="images/test.svg" style="height: 17px;margin-right: 11px;" />
            <span>Courses</span>
          </a>
        </li>
        </ul>
        <?php }
        
        else
        { ?>
        
      <ul class="sidebar-menu" data-widget="tree">
          

            <li class="<?= ($page_name == 'Dashboard') ? 'active-menu' : '' ?>">
                <a href="#">
                    <img src="images/dashboard-icon.svg" style="height: 17px; margin-right: 11px;" />
                    <span>Dashboard</span>
                </a>
            </li>
        
        <li class="<?= in_array($page_name, ['Masters', 'Institute Master', 'Add Institute', 'View Institute', 'Edit Institute', 'Student Master', 'Add Student', 'View Student','Edit Student'
        , 'Category Master', 'Add Course Category', 'Edit Course Category', 'Employee Master', 'Add Employee', 'Edit Employee', 'View Employee'
        , 'Testimonial Master', 'Add Testimonial', 'View Testimonial', 'Edit Testimonial', 'FAQ Master', 'Add FAQ', 'Edit FAQ', 'View FAQ',
        'Add Category', 'Edit Category', 'Category Master', 'Module Master', 'Add Module', 'Edit Module', 'Submodule Master', 'Edit Submodule', 'Add Submodule',
        'Mentor Master', 'Add Mentor', 'View Mentor', 'Edit Mentor']) ? 'active-menu' : '' ?>">
          <a href="masters.php">
            <img src="images/database.svg" style="height: 17px;margin-right: 11px;" />
            <span>Masters</span>
          </a>
        </li>

                <li>
          <a href="course_master.php">
            <img src="images/test.svg" style="height: 17px;margin-right: 11px;" />
            <span>Courses</span>
          </a>
        </li>        
        
        
        <li class="<?= in_array($page_name, ['Question Master', 'Edit Question', 'Add Question', 'View Question']) ? 'active-menu' : '' ?>">
          <a href="question_master.php">
            <img src="images/question.svg" style="height: 17px;margin-right: 11px;" />
            <span>Questions</span>
          </a>
        </li>
        
        
                <li>
          <a href="course_material_master.php">
            <img src="images/question.svg" style="height: 17px;margin-right: 11px;" />
            <span>Course Material</span>
          </a>
        </li>   
        
        <li class="<?= in_array($page_name, ['Quiz Master', 'Edit Quiz', 'Add Quiz', 'View Quiz']) ? 'active-menu' : '' ?>">
          <a href="quiz_master.php">
            <img src="images/test.svg" style="height: 17px;margin-right: 11px;" />
            <span>Quiz</span>
          </a>
        </li>
        
        <li class="<?= in_array($page_name, ['Assignment Master', 'Edit Assignment', 'Add Assignment', 'View Assignment']) ? 'active-menu' : '' ?>">
          <a href="assignment_master.php">
            <img src="images/test.svg" style="height: 17px;margin-right: 11px;" />
            <span>Assignment</span>
          </a>
        </li>        
        
        
                <li class="<?= ($page_name == 'Reports') ? 'active-menu' : '' ?>">
          <a href="#">
            <img src="images/report.svg" style="height: 17px;margin-right: 11px;" />
            <span>Reports</span>
          </a>
        </li>
        
        
        
        <li class="<?= ($page_name == 'Settings') ? 'active-menu' : '' ?>">
          <a href="#">
            <img src="images/settings.svg" style="height: 17px;margin-right: 11px;" />
            <span>Settings</span>
          </a>
        </li>        
       
      </ul>
      
      <?php } ?>
    </section>
</aside>