<script>
/*****************************************************/

// Function to pre-populate the form for institute
function populateInstitutes(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/institute_dropdown_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.institutes)) {
                let options = '<option value="">Select Institute</option>';
                data.institutes.forEach(function(institute) {
                    const selectedAttr = selectedId == institute.id ? 'selected' : '';
                    options += `<option value="${institute.id}" ${selectedAttr}>${institute.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');

            } else {
                console.error('Invalid response format from institute_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load institutes:', error);
        }
    });
}


function populateCourses(selectorId, selectedIds = []) {
    $.ajax({
        url: './apis/course_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.courses)) {
                let options = '<option value="">Select Course</option>';
                data.courses.forEach(function(course) {
                    const selectedAttr = selectedIds.includes(course.id.toString()) ? 'selected' : '';
                    options += `<option value="${course.id}" ${selectedAttr}>${course.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid course response format:', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load courses:', error);
        }
    });
}


function populateCountries(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/country_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.countries)) {
                let options = '<option value="">Select Country</option>';
                data.countries.forEach(function(country) {
                    const selectedAttr = selectedId == country.id ? 'selected' : '';
                    options += `<option value="${country.id}" ${selectedAttr}>${country.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load countries:', error);
        }
    });
}


function populateCategories(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/category_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.categories)) {
                let options = '<option value="">Select Category</option>';
                data.categories.forEach(function(category) {
                    const selectedAttr = selectedId == category.id ? 'selected' : '';
                    options += `<option value="${category.id}" ${selectedAttr}>${category.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load countries:', error);
        }
    });
}


function populateMentors(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.mentors)) {
                let options = '<option value="">Select Mentor</option>';
                data.mentors.forEach(function(mentor) {
                    const selectedAttr = selectedId == mentor.id ? 'selected' : '';
                    options += `<option value="${mentor.id}" ${selectedAttr}>${mentor.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load mentors:', error);
        }
    });
}


function populateIndustryExpert(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/expert_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.mentors)) {
                let options = '<option value="">Select Industry Expert</option>';
                data.mentors.forEach(function(mentor) {
                    const selectedAttr = selectedId == mentor.id ? 'selected' : '';
                    options += `<option value="${mentor.id}" ${selectedAttr}>${mentor.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from expert_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load mentors:', error);
        }
    });
}



function populateTestimonials(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.testimonials)) {
                let options = '<option value="">Select Testimonials</option>';
                data.testimonials.forEach(function(testimonial) {
                    const selectedAttr = selectedId == testimonial.id ? 'selected' : '';
                    options += `<option value="${testimonial.id}" ${selectedAttr}>${testimonial.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load testimonials:', error);
        }
    });
}


function populateProposedCourses(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.proposed_courses)) {
                let options = '<option value="">Select Proposed Courses</option>';
                data.proposed_courses.forEach(function(proposed_course) {
                    const selectedAttr = selectedId == proposed_course.id ? 'selected' : '';
                    options += `<option value="${proposed_course.id}" ${selectedAttr}>${proposed_course.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load testimonials:', error);
        }
    });
}



function populateFaqs(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.faqs)) {
                let options = '<option value="">Select FAQs</option>';
                data.faqs.forEach(function(faq) {
                    const selectedAttr = selectedId == faq.id ? 'selected' : '';
                    options += `<option value="${faq.id}" ${selectedAttr}>${faq.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load testimonials:', error);
        }
    });
}



function populateModules(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/module_dropdown_api.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.modules)) {
                let options = '<option value="">Select Module</option>';
                data.modules.forEach(function(module) {
                    const selectedAttr = selectedId == module.id ? 'selected' : '';
                    options += `<option value="${module.id}" ${selectedAttr}>${module.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load countries:', error);
        }
    });
}


function populateCoursesModules(selectorId, courseId, selectedId = null) {
    $.ajax({
        url: './apis/courses_modules_dropdown_api.php',
        type: 'GET',
        data: { course_id: courseId },
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.modules)) {
                let options = '<option value="">Select Module</option>';
                data.modules.forEach(function(module) {
                    const selectedAttr = selectedId == module.id ? 'selected' : '';
                    options += `<option value="${module.id}" ${selectedAttr}>${module.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from API', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load modules:', error);
        }
    });
}



function populateSubModules(selectorId, moduleId, selectedId = null) {
    $.ajax({
        url: './apis/dropdown_api.php',
        type: 'GET',
        dataType: 'json',
            data: {
      module_id: moduleId
    },
        success: function(data) {
            if (data && Array.isArray(data.sub_modules)) {
                let options = '<option value="">Select Submodule</option>';
                data.sub_modules.forEach(function(submodule) {
                    const selectedAttr = selectedId == submodule.id ? 'selected' : '';
                    options += `<option value="${submodule.id}" ${selectedAttr}>${submodule.name}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load countries:', error);
        }
    });
}

</script>