<?php require_once('prepopulate_dropdowns.php'); ?>
<script>
/*****************************************************/
// Function to pre-populate the form for editing a category
function prepopulateCategoryForm(categoryId) {
    $('#page-loader').show();
    $.ajax({
        url: `apis/get_category_single_api.php?id=${categoryId}`,
        method: 'GET',
        success: function(data) {
            $('#page-loader').show();
            if (data.status === 'success') {
                const category = data.category;
                $('#category_name').val(category.category_name);
                if (category.is_block == 1) {
                    $('#Option_1').prop('checked', true);
                } else {
                    $('#Option_2').prop('checked', true);
                }
                $('#page-loader').hide();
            } else {
                alert('Error fetching category data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        },
        complete: function() {
            $('#page-loader').hide();
        }
    });
}


// Function to pre-populate the form for editing a submodule
function prepopulateForm(submoduleId) {
    $.ajax({
        url: `apis/get_submodule_single_api.php?id=${submoduleId}`, // Using the refined API endpoint name
        method: 'GET',
        dataType: 'json', // Ensure jQuery expects JSON response
        success: function(data) {
            if (data.status === 'success' && data.submodule) {
                const submodule = data.submodule;
                $('#submodule_name').val(submodule.submodule_name);
                $('#description').val(submodule.description);
                $('#submodule_id_hidden').val(submoduleId); 

                populateModuleDropdown($('#module_id_select'), submodule.module_id);

            } else {
                // Assuming showAlert is defined globally
                showAlert(data.message || 'Error fetching submodule data.', 'danger');
                console.error('Error fetching submodule data:', data.message);
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.error('Error:', textStatus, errorThrown, jqXHR.responseText);
            // Assuming showAlert is defined globally
            showAlert('An error occurred while fetching submodule data. Please try again.', 'danger');
        }
    });
}


// Function to pre-populate the form for editing a module
function prepopulateModuleForm(moduleId) {
    $.ajax({
        url: `apis/get_module_single_api.php?id=${moduleId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const module = data.module;
                $('#module_name').val(module.module_name);
                $('#description').val(module.description);
                if (module.is_active == 1) {
                        $("#activeOption").prop("checked", true);
                    } else if (module.is_active == 0)  {
                        $("#inactiveOption").prop("checked", true);
                    }

                const selectedSubmodules = module.sub_module_id.split(',');
                $('#submodule_name').val(selectedSubmodules).trigger('change');
            } else {
                alert('Error fetching module data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}

// Function to pre-populate the form for editing a employee
function prepopulateEmployeeForm(employeeId) {
    $.ajax({
        url: `apis/get_employee_single_api.php?id=${employeeId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const employee = data.employee;

                $('#first_name').val(employee.first_name);
                $('#last_name').val(employee.last_name);
                $('#mobile_no').val(employee.phone_no);
                $('#email_id').val(employee.email_id);
                $('#password').val(atob(employee.password));
                $('#address').val(employee.address);

                // Corrected this line!
                var selectedRoles = employee.role_id.split(',');

                // Select roles in the multi-select dropdown
                $('#role_name').val(selectedRoles).trigger('change');

                if (employee.is_block == 1) {
                    $('#Option_1').prop('checked', true);
                } else {
                    $('#Option_2').prop('checked', true);
                }
            } else {
                alert('Error fetching employee data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}


// Function to pre-populate the form for editing a study material
function prepopulateStudyMaterialForm(studyId) {
    $.ajax({
        url: `apis/get_study_single_api.php?id=${studyId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                console.log(data)
                const material = data.study_material;

                $('#study_title').val(material.title);
                $('#description').val(material.description);

                $('#category').val(material.category_id).trigger('change');

                if (material.doc_type === 'file') {
                  // For local uploaded files
                  if (material.original_file_name) {
                    const studyUrl = 'institutes/' + material.folder_name + '/study_materials/' + material.actual_file_name;
                
                    $('#studyLink')
                      .attr('href', studyUrl)
                      .text(material.original_file_name)
                      .show();
                  } else {
                    $('#studyLink').hide();
                  }
                } else if (material.doc_type === 'video') {
                  // For Vimeo videos
                  if (material.vimeo_link) {
                    $('#studyLink')
                      .attr('href', material.vimeo_link)
                      .attr('target', '_blank') // open Vimeo in new tab
                      .text(material.original_file_name || material.title) // show file name or title
                      .show();
                  } else {
                    $('#studyLink').hide();
                  }
                }


                if (material.is_block == 1) {
                    $('#Option_2').prop('checked', true); 
                } else {
                    $('#Option_1').prop('checked', true);
                }
            } else {
                alert('Error fetching material data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}



// Function to pre-populate the form for editing a mentor
function prepopulateMentorForm(mentorId) {
    $.ajax({
        url: `apis/get_mentor_single_api.php?id=${mentorId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const mentor = data.mentor;
 
                $('#mentor_name').val(mentor.mentor_name);
                $('#phone_no').val(mentor.phone_no);
                $('#email_id').val(mentor.email_id);
                $('#password').val(mentor.password);
                $('#specialization').val(mentor.specialization);
                $('#linkedin_profile').val(mentor.linkedin_profile);
                
                $('#mentorImagePreview').attr('src', 'institutes/' + mentor.folder_name + '/mentor_images/' + mentor.photo).show();

if (mentor.cv) {
  const cvUrl = 'institutes/' + mentor.folder_name + '/mentor_images/' + mentor.cv;

  $('#mentorCVLink')
    .attr('href', cvUrl)
    .text('View Uploaded CV')
    .show();
} else {
  $('#mentorCVLink').hide();
}


                if (mentor.is_block == 1) {
                    $('#Option_1').prop('checked', true); 
                } else {
                    $('#Option_2').prop('checked', true);
                }
                
                if (mentor.industry_expert == 1) {
                    $('#industry_expert').prop('checked', true); 
                } else {
                    $('#industry_expert').prop('checked', false);
                }
                
            } else {
                alert('Error fetching mentor data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}


// Function to pre-populate the form for institute
function prepopulateInstituteForm(InstituteId) {
        $.ajax({
            url: `apis/get_institute_single_api.php?id=${InstituteId}`,
            method: 'GET',
            success: function (data) {
                if (data.status === 'success') {
                    const institute = data.institute;
                    
                    populateCountries('country', institute.country);
                    const selectedCourses = data.courses ? data.courses : [];
                    populateCourses('course', selectedCourses);
                    
                    $('#instituteImagePreview').attr('src', 'institutes/' + institute.folder_name + '/institute_images/' + institute.institute_img).show();

                    $('#institute_name').val(institute.institute_name);
                    $('#phone_no').val(institute.phone_no);
                    $('#email_id').val(institute.email_id);
                    $('#password').val(atob(institute.password));
                    $('#city').val(institute.city);
                    $('#state').val(institute.state);
                    $('#pincode').val(institute.pincode);

                    // Set block status
                    if (institute.is_block == 1) {
                        $('#Option_2').prop('checked', true);
                    } else {
                        $('#Option_1').prop('checked', true);
                    }
                    


            // Clear any existing additional contacts
            $('#additionalContactPersons').empty();

            // Populate contact person details
            if (data.contacts && Array.isArray(data.contacts)) {
                data.contacts.forEach((contact, index) => {
                    const isFirst = index === 0;
                    const html = `
                        <div class="row contact-group">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Contact Name <span class="text-danger">*</span></label>
                                    <input class="form-control" type="text" name="contact_name[]" value="${contact.contact_name}" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Phone No. <span class="text-danger">*</span></label>
                            <input class="form-control" type="tel" pattern="[0-9]{10}" maxlength="10" minlength="10" name="contact_phone[]" value="${contact.mobile_no}" title="Please enter exactly 10 digits (numbers only)" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Email ID <span class="text-danger">*</span></label>
                            <input class="form-control" type="email" autocomplete="new-email" name="contact_email[]" pattern=".+\\..{2,4}$"
                              title="Please enter a valid email address" value="${contact.email_id}" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                ${isFirst
                                    ? `<button type="button" class="btn btn-primary mb-25 mt-25 btn-circle" id="addMoreButton" style="border-radius: 50% !important;"><i class="fas fa-plus"></i></button>`
                                    : `<button type="button" class="btn btn-danger removeButton mb-25 mt-25 btn-circle" style="border-radius: 50% !important;"><i class="fas fa-minus"></i></button>`
                                }
                            </div>
                        </div>
                    `;
            
                    if (isFirst) {
                        // Replace the original static block for first contact
                        $('.contact-group').first().replaceWith(html);
                    } else {
                        $('#additionalContactPersons').append(html);
                    }
                });
            }
                } else {
                    alert('Error fetching institute data.');
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', error);
                reject(error);
            }
        });
}


// Function to pre-populate the form for course
function prepopulateCourseForm(InstituteId) {
    $.ajax({
        url: `apis/get_course_single_api.php?id=${InstituteId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const institute = data.institute;
                $('#course_name').val(institute.course_name);
                $('#no_of_installments').val(institute.no_of_installments);
                $('#no_of_documents').val(institute.no_of_documents);
                $('#no_of_hours').val(institute.no_of_hours);
                $('#no_of_assesments').val(institute.no_of_assesments);
                $('#no_of_quizes').val(institute.no_of_quizes);
                $('#course_fees').val(institute.course_fees);
                $('#course_start_date').val(institute.course_start_date);
                $('#course_end_date').val(institute.course_end_date);
                $('#keywords').val(institute.keywords);
                $('#outcomes').val(institute.outcomes);
                $('#description').val(institute.description);

                // Set the block/unblock options
                if (institute.is_block == 1) {
                    $('#Option_1').prop('checked', true); 
                } else {
                    $('#Option_2').prop('checked', true);
                }
            } else {
                alert('Error fetching institute data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}

function prepopulateQuestionForm(questionId) {
    $.ajax({
        url: `apis/get_question_single_api.php?question_id=${questionId}`,  
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const question = data.question;

                // Populate dropdowns using reusable functions
                populateCategories('category', question.category_course_id);

                $('#criteria').val(question.criteria).trigger('change');
                $('#level').val(question.level).trigger('change');
                $('#media_select').val(question.media).trigger('change');
                $('#question').val(question.question);
                $('#video_title').val(question.video_title);
                $('#video_url').val(question.video_url);
                $('#video_type').val(question.video_type);

                if (question.video_type === 'vimeo') {
                    $('#video_section').hide();
                    $('#video_section_upload').show();
                    $('#video_mode').val('vimeo');
                } else {
                    $('#video_section_upload').hide();
                    //$('#video_section').show();
                    $('#video_mode').val('url');
                }
                
                $('#option_1').val(question.option_1);
                $('#option_2').val(question.option_2);
                $('#option_3').val(question.option_3);
                $('#option_4').val(question.option_4);
                $('#marks').val(question.marks);
                $('#duration').val(question.duration);
                $('#option').val(question.correct_answer).trigger('change');
                

                // Question type handling
                $('#type').val(question.type).trigger('change');

                if (question.type === "yes_no") {
                    $("input[name='yes_no']").prop("checked", false);
                    if (question.correct_answer.toLowerCase() === "yes") {
                        $("input[name='yes_no'][value='yes']").prop("checked", true);
                    } else if (question.correct_answer.toLowerCase() === "no") {
                        $("input[name='yes_no'][value='no']").prop("checked", true);
                    }
                } else if (question.type === "true_false") {
                    $("input[name='true_false']").prop("checked", false);
                    if (question.correct_answer.toLowerCase() === "true") {
                        $("input[name='true_false'][value='true']").prop("checked", true);
                    } else if (question.correct_answer.toLowerCase() === "false") {
                        $("input[name='true_false'][value='false']").prop("checked", true);
                    }
                } else if (question.type === "one_right_answer") {
                    $('#option').val(question.correct_answer).trigger('change');
                } else if (question.type === "multiple_answers") {
                    const correctAnswers = question.correct_answer.split(",");
                    $('#multiple_options').val(correctAnswers).trigger('change');
                }


                // Image preview
                if (question.image_url) {
                    const imagePath = 'institutes/' + question.folder_name + '/question_images/' + question.image_url;
                    $('#image_preview').attr('src', imagePath).show(); 
                } else {
                    $('#image_preview').hide(); 
                }

                // Video preview (optional)
                if (question.video_url && question.media === "Video") {
                    const vimeoId = question.video_url.split('/').pop(); // extract ID from full Vimeo URL
                    const embedUrl = `https://player.vimeo.com/video/${vimeoId}`;
                    $('#video_preview').attr('src', embedUrl).show();
                } else {
                    $('#video_preview').hide();
                }

            } else {
                alert('Error fetching question data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}


// Function to fetch submodules based on module ID
function fetchSubmodules(moduleId, selectedSubmoduleId = null) {
    if (!moduleId) return;

    $.ajax({
        url: 'apis/submodule_selected_api.php',
        method: 'GET',
        data: { module_id: moduleId },
        dataType: 'json',
        success: function (response) {
            let options = '<option value="">Select Sub-Module</option>';
            if (Array.isArray(response) && response.length > 0) {
                $.each(response, function (index, item) {
                    options += `<option value="${item.submodule_id}">${item.submodule_name}</option>`;
                });
            } else {
                options = '<option value="">No submodules available</option>';
            }

            $('#submodule_id').html(options).prop('disabled', response.length === 0);

            // Set selected submodule after dropdown is populated
            if (selectedSubmoduleId) {
                setTimeout(() => {
                    $('#submodule_id').val(selectedSubmoduleId).trigger('change');
                }, 300);
            }
        },
        error: function (error) {
            console.error('Error fetching submodules:', error);
        }
    });
}

function prepopulateFaqForm(faqId) {
    $.ajax({
        url: `apis/get_single_faq_api.php?id=${faqId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const faq = data.faqs[0];  // Get the first FAQ from the array

                $('#faq_question').val(faq.faq_question);
                $('#faq_answer').val(faq.faq_answer);
                
                if (faq.is_block == 1) {
                    $('#BlockFAQ').prop('checked', true);
                } else {
                    $('#UnblockFAQ').prop('checked', true);
                }
            } else {
                alert('Error fetching FAQ data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}

function prepopulateTestimonialForm(testimonialId) {
    $.ajax({
        url: `apis/get_single_testimonial_api.php?id=${testimonialId}`,
        method: 'GET',
        success: function(data) {
            if (data.status === 'success') {
                const testimonial = data.testimonials[0];  // Get the first testimonial from the array

                $('#testimonial_name').val(testimonial.testimonial_name);
                $('#learner_since').val(testimonial.learner_since);
                $('#testimonial_text').val(testimonial.testimonial_text);

                if (testimonial.testimonial_block == 1) {
                    $('#BlockTestimonial').prop('checked', true);
                } else {
                    $('#UnblockTestimonial').prop('checked', true);
                }
            } else {
                alert('Error fetching testimonial data.');
            }
        },
        error: function(error) {
            console.error('Error:', error);
        }
    });
}

function prepopulateCourseForm(courseId) {
    $.ajax({
        url: `apis/get_course_single_api.php?id=${courseId}`,
        method: 'GET',
        success: function(response) {
            if (response.status === 'success') {
                const course = response.course;

                $('#course_name').val(course.course_name);
                $('#course_category').val(course.course_category).trigger('change');
                $('#level').val(course.level).trigger('change');
                $('#description').val(course.description);

                // Set image preview if image exists
                if (course.image) {
                    $('#course_img_preview')
                        .attr('src', 'images/course_image/' + course.image)
                        .show();
                } else {
                    $('#course_img_preview').hide();
                }
            } else {
                alert('Error fetching course data.');
            }
        },
        error: function(err) {
            console.error('Error:', err);
        }
    });
}


function prepopulateQuizForm(quizId) {
    $.ajax({
      url: `apis/get_quiz_single_api.php?id=${quizId}`,
      method: 'GET',
      success: function (response) {
        if (response.status === 'success') {
          const quiz = response.quiz;

          $('#quizTitle').val(quiz.quiz_title);

          // Populate selectedQuestions from quiz.question_ids
          if (quiz.question_ids) {
            const ids = quiz.question_ids.split(',').map(id => id.trim());
            ids.forEach(id => selectedQuestions.add(id));
          }

          // Reload DataTable to reflect checked state
          dataTable.ajax.reload();
        } else {
          alert('Failed to load quiz data.');
        }
      },
      error: function (err) {
        console.error('Error fetching quiz:', err);
      }
    });
  }
  
function prepopulateAssignmentForm(quizId) {
    $.ajax({
      url: `apis/get_assignment_single_api.php?id=${quizId}`,
      method: 'GET',
      success: function (response) {
        if (response.status === 'success') {
          const assignment = response.assignment;

          $('#assignmentTitle').val(assignment.assignment_title);

          // Populate selectedQuestions from assignment.question_ids
          if (assignment.question_ids) {
            const ids = assignment.question_ids.split(',').map(id => id.trim());
            ids.forEach(id => selectedQuestions.add(id));
          }

          // Reload DataTable to reflect checked state
          dataTable.ajax.reload();
        } else {
          alert('Failed to load assignment data.');
        }
      },
      error: function (err) {
        console.error('Error fetching assignment:', err);
      }
    });
  }  




function prepopulateStudentForm(studentId) {
    $.ajax({
        url: `apis/get_student_single_api.php?id=${studentId}`, // Assumes this API returns student data
        method: 'GET',
        dataType: 'json',
        success: function (data) {
            if (data.status === 'success' && data.student) {
                const student = data.student;

                populateInstitutes('institute', student.institute_id);
                
                $('#email_address').val(student.email_id);
                $('#phone_number').val(student.phone_no);
                $('#date_of_birth').val(student.dob);
                $('#gender').val(student.gender);
                $('#studentname').val(student.student_name);
                $('#username').val(student.email_id);
                $('#gender').val(student.gender).trigger('change');


            } else {
                showAlert(data.message || 'Error fetching student data.', 'danger');
                console.error('Error fetching student data:', data.message);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error('Error:', textStatus, errorThrown, jqXHR.responseText);
            showAlert('An error occurred while fetching student data. Please try again.', 'danger');
        }
    });
}

</script>