<?php 
$page_name = 'Course List';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span style="margin-left: 10px;">
        Course Master
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li class="active">Course</li>
      </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
            <a href="add_institute_course_master.php" class="btn btn-primary">Add Course</a>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>
                <div class="box-body table-padding">
                
                  
                <div id="loader" style="display: none;">
                <p>Loading...</p>
                </div>
                    <table id="dataGrid" class="table">
                    <thead style="background: #FAF7FE;">
                        <tr>
                          <th>Sr. No.</th>
                          <th>Course Name</th>
                          <th>Category Name</th>
                          <th>Institute</th>
                          <th>Blocked</th>
                          <th>Action</th>
                        </tr>
                    </thead>
                        <tbody>
                        
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
  </div>
  
<?php require_once('includes/footer.php'); ?>
	
<script>

function encodeemployeeId(employeeId) {
    return btoa(employeeId.toString()); // btoa() encodes a string to Base64
}

// Function to fetch data from the PHP API using jQuery
function fetchData() {
    $('#loader').show(); // Show the loader

    $.ajax({
        url: 'apis/course_api.php',
        method: 'GET',
        dataType: 'json',
        success: function (data) {
            const tableBody = $('#dataGrid tbody');
            tableBody.empty(); // Clear any existing data in the table

            let tableRows = '';

            // Loop through the data and create rows as HTML strings
            data.forEach((item, index) => {
                const encryptedemployeeId = encodeemployeeId(item.course_id);

                tableRows += `
                    <tr>
                        <td>${index + 1}</td>
                        <td>${item.course_name}</td>
                        <td>${item.course_category}</td>
                        <td>${item.institute_id}</td>
                        <td>${item.is_block}</td>                        
                        <td>
                            <a href="institute_course_master.php"><i class="fa fa-info"></i></a>                        
                            <a href="edit_course.php?id=${encryptedemployeeId}">
                                <img src="images/edit.svg" style="margin-left: 10px;" />
                            </a>
                            <a href="view_course.php?id=${encryptedemployeeId}">
                                <img src="images/view.svg" style="margin-left: 10px;" />
                            </a>
                        </td>
                    </tr>
                `;
            });

            // Insert the rows into the table body
            tableBody.html(tableRows);

            $('#loader').hide(); // Hide the loader
        },
        error: function (error) {
            console.error('Error fetching data:', error);
            $('#loader').hide(); // Hide the loader on error
        }
    });
}

// Call the fetchData function on page load
$(document).ready(function() {
    fetchData(); // Fetch data when the page loads
});

// Event delegation for delete buttons using jQuery
$('#dataGrid').on('click', '.delete-button', function (event) {
    const employeeId = $(this).data('employee-id');
    
    // Confirm before deleting
    if (confirm("Are you sure you want to delete this employee?")) {
        $.ajax({
            url: 'apis/delete_course_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({
                course_id: employeeId,
            }),
            success: function (data) {
                const responseMessage = $('#responseMessage');

                if (data.status === 'success') {
                    // Remove the row from the table
                    $(event.target).closest('tr').remove();
                    
                    showAlert(data.message, 'success');
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function (error) {
                console.error('Error deleting category:', error);
                const responseMessage = $('#responseMessage');
                
                showAlert(data.message, 'danger');
            }
        });
    }
});

</script>

</body>
</html>