<?php 
$page_name = 'Masters';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span style="margin-left: 10px;">
        Masters
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php">Masters</a></li>
      </ol>
    </section>

    <section class="content">
    <div class="row">
        

        <?php if($category == 'superadmin') {  ?>       
                <div class="col-md-3 col-sm-6 col-xs-12">
                  <div class="info-box cursor-pointer" onclick="window.location.href='institute_master.php';">
                    <span class="info-box-icon bg-card" id="instituteCount"></span>
        
                    <div class="info-box-content">
                      <span class="info-box-text">Institute</span>
                    </div>
                  </div>
                </div>
        <?php } ?>   

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='category_master.php';">
            <span class="info-box-icon bg-card" id="categoryCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Category</span>
            </div>
          </div>
        </div>
        
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='employee_master.php';">
            <span class="info-box-icon bg-card" id="employeeCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Employee</span>
            </div>
          </div>
        </div>
        
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='module_master.php';">
            <span class="info-box-icon bg-card" id="moduleCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Module</span>
            </div>
          </div>
        </div>

        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='submodule_master.php';">
            <span class="info-box-icon bg-card" id="submoduleCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Submodule</span>
            </div>
          </div>
        </div>  
        
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='mentor_master.php';">
            <span class="info-box-icon bg-card" id="mentorCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Mentor</span>
            </div>
          </div>
        </div> 
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='faq_master.php';">
            <span class="info-box-icon bg-card" id="faqCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">FAQ</span>
            </div>
          </div>
        </div> 
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='testimonial_master.php';">
            <span class="info-box-icon bg-card" id="testimonialCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Testimonial</span>
            </div>
          </div>
        </div> 
        
        <div class="col-md-3 col-sm-6 col-xs-12">
          <div class="info-box cursor-pointer" onclick="window.location.href='student_master.php';">
            <span class="info-box-icon bg-card" id="studentCount"></span>

            <div class="info-box-content">
              <span class="info-box-text">Students</span>
            </div>
          </div>
        </div> 

      </div>
    </section>
  </div>
  
<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
    $.ajax({
        url: 'apis/get_master_counts.php',
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                $('#categoryCount').text(response.data.category); // Display category count
                $('#employeeCount').text(response.data.employee); // Display employee count
                $('#instituteCount').text(response.data.institute); // Display institute count
                $('#mentorCount').text(response.data.mentor); // Display mentor count
                $('#moduleCount').text(response.data.module); // Display module count
                $('#submoduleCount').text(response.data.submodule); // Display submodule count
                $('#faqCount').text(response.data.faq); // Display faq count
                
                $('#testimonialCount').text(response.data.testimonial); // Display testimonial count 
                
                $('#studentCount').text(response.data.students);
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error fetching data:', error);
            alert('An error occurred while fetching data.');
        }
    });
});
</script>

</body>
</html>