<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>EPIC LMS - Course Main Page</title>

    <link rel="icon" href="images/favicon.svg" type="image/x-icon">

    <link rel="stylesheet" href="assets/font-awesome/css/font-awesome.css">
    <link rel="stylesheet" href="assets/ionicons/css/ionicons.css">

    <link rel="stylesheet" href="assets/select2/dist/css/select2.min.css">

    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

    <link rel="stylesheet" href="css/master_style.css">
    <link rel="stylesheet" href="css/_all-skins.css">
    <link rel="stylesheet" href="css/custom.css">

    <style>
        body { color: #5C2C8B; background-color: #f7f7f7; }
        .containers { margin: 0 60px; }
        .navbar { height: 100px; background: white; box-shadow: 0 4px 6px rgba(0,0,0,0.1); display: flex; align-items: center; padding: 0 20px; }
        .navbar img { height: 100px; }
        .section { padding: 20px 0; }
        .content-card { /* Unified class for main content area */
             background-color: #fff;
             padding: 30px;
             border-radius: 10px;
             box-shadow: 0 2px 4px rgba(0,0,0,0.05);
             margin-bottom: 20px;
             min-height: 400px; /* To prevent collapse when content changes */
             position: relative; /* For absolute positioning of nav buttons */
        }
        .righ-section { border-right: 1px solid #f0f0f0; padding-right: 20px; }
        .course-sidebar { background-color: #fff; padding: 30px; border-radius: 10px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }

        .btn-container { display: flex; justify-content: flex-end; margin-top: 10px; }
        .btn-custom { border-radius: 10px; font-size: 16px; text-transform: uppercase; padding: 10px 20px; margin: 5px; }
        .btn-start { background: #5C2C8B; color: white; }
        .btn-trial { background: white; border: 2px solid #5C2C8B; color: #5C2C8B; }
        .righ-section h1 { font-size: 25px; font-weight: bold; }
        .righ-section p { font-size: 15px; color: #5C2C8B; }
        .righ-section p span { font-weight: bold; }
        .question-box { border: 1px solid #f0f0f0; border-radius: 10px; padding: 15px 20px; margin-bottom: 20px; }
        .mentor-image img { max-width: 350px; width: 34px; height: 34px; }
        .mentor-section { display: flex; align-items: center; margin-top: 10px; }
        .mentor-name { margin-left: 5px; }

        .sidebar { background-color: #fff; min-height: 100vh; border-right: 1px solid #ddd; }
        .mentor-img { width: 40px; height: 40px; border-radius: 50%; margin-right: 10px; }
        .accordion-button::after { display: none; }
        .accordion-item { border: none;}
        .accordion-button:not(.collapsed){ color: inherit; background: #fff; box-shadow: none; }
        .accordion-button:focus{ z-index: 3; outline: none; box-shadow: none; }
        .accordion-button{ background: #fff; font-size: 15px; color: inherit; border: none; font-weight: bold; display: flex; align-items: center; padding-left: 0; }
        .accordion-button .icon-wrapper { margin-right: 10px; display: flex; align-items: center; justify-content: center; width: 20px; }

        .mentor-name p{ margin: 5px; }

        .pl-50{ padding-left: 50px; }
        .sub-title{
            font-size: 13px;
            padding: 0;
            margin-left: 30px; /* Base indentation for submodules if not accordion buttons */
            margin-bottom: 10px;
            cursor: pointer;
            display: block;
            color: #5C2C8B;
            transition: color 0.2s;
            font-weight: bold; /* Make all sub-titles bold by default */
        }
        .sub-title:hover {
            color: #7d44c4; /* Slightly darker purple on hover */
        }
        .sub-title.active-submodule {
            color: #5C2C8B; /* Keep original color */
            font-weight: 900; /* Extra bold for active */
        }
        .video-title {
            display: flex;
            align-items: center;
            /* Adjusted margin-left to align properly within submodule-items-wrapper */
            margin-left: 0;
            padding: 5px 0; /* Add some vertical padding */
            font-size: 14px;
            color: #5C2C8B;
            cursor: pointer; /* Indicate clickability for individual items */
            transition: color 0.2s;
        }
        .video-title:hover {
            color: #7d44c4; /* Slightly darker purple on hover */
        }
        .video-title img{
            height: 14px;
            width: auto;
            margin-right: 8px; /* Space between icon and text */
        }

        /* NEW: Style for active content item in sidebar */
        .video-title.active-content-item {
            font-weight: bold; /* Make text bold */
            color: #5C2C8B; /* Ensure color is consistent */
        }


        .sub-accordion-body {
            padding-left: 20px !important;
            padding-right: 0 !important;
            padding-top: 5px !important; /* Add some top padding */
            padding-bottom: 5px !important; /* Add some bottom padding */
        }

        /* Course Timeline Styling */
        .course-timeline {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            margin-top: 0;
            height: fit-content;
            position: relative; /* For positioning the dotted line */
        }
        .course-timeline h5 { font-weight: bold; color: #5C2C8B; margin-bottom: 15px; }

        /* Dotted line for timeline */
        .course-timeline::before {
            content: '';
            position: absolute;
            top: 61px;
            bottom: 50px;
            left: 30px;
            width: 2px;
            border-left: 2px dotted #ccc;
            z-index: 0;
        }

        .timeline-item1 {
            display: flex;
            align-items: center; /* Vertically align icon and content */
            margin-bottom: 10px;
            font-size: 14px;
            position: relative; /* For z-index to bring content above dotted line */
            z-index: 1; /* Ensure items are above the dotted line */
        }
        
        .timeline-item {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
            font-size: 14px;
            position: relative;
            z-index: 1;
            margin-left: 35px;
        }

        .timeline-icon {
            width: 20px; 
            text-align: center;
            margin-right: 15px; 
            color: #888; 
            background-color: #fff; 
            padding: 5px 0; 
        }
        .timeline-icon i {
            font-size: 16px; /* Icon size */
        }

        .timeline-content {
            display: flex;
            flex-direction: column; /* Stack title and status vertically */
            flex-grow: 1; /* Allow content to take remaining space */
            color: #5C2C8B; /* Default text color */
        }

        .timeline-title {
            font-weight: bold;
            line-height: 1.2; /* Adjust line height for better spacing */
        }

        .timeline-status {
            font-size: 13px; /* Smaller font for status */
            color: #888; /* Lighter color for status */
            margin-top: 2px; /* Small space between title and status */
        }

        /* Specific styles for start/end dates */
        .timeline-item.bold .timeline-title {
            font-weight: bold;
        }
        .timeline-item.start-end .timeline-title,
        .timeline-item.start-end .timeline-status {
            color: #333; /* Darker color for start/end text */
        }


        /* Module Overview List Styles */
        .module-list-overview {
            list-style: none;
            padding: 0;
            margin-top: 20px;
        }
        .module-list-overview li {
            margin-bottom: 15px;
            font-size: 15px;
            display: flex;
            flex-direction: column; /* Keep column for title and status icons */
            align-items: flex-start;
            border: 1px solid #eee;
            border-radius: 8px;
            padding: 15px;
            background-color: #fcfcfc;
            cursor: pointer;
            transition: all 0.2s ease-in-out;
        }
        .module-list-overview li:hover {
            border-color: #5C2C8B;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .module-list-overview li a {
            color: #5C2C8B;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 600;
            margin-bottom: 5px;
            font-size: 1.1em;
        }
        .module-list-overview .status-icons {
            display: flex; /* Use flexbox */
            gap: 15px; /* Spacing between icon-text pairs */
            font-size: 13px;
            color: #888;
            margin-top: 5px;
            padding-left: 20px; /* Align with the text above */
            white-space: nowrap; /* Keep all items on one line */
            overflow-x: auto; /* Add horizontal scroll if content overflows */
            -webkit-overflow-scrolling: touch; /* For smoother scrolling on touch devices */
        }
        .status-icons .item {
            display: flex;
            align-items: center;
            gap: 4px;
            flex-shrink: 0; /* Prevent items from shrinking */
        }
        .status-icons span { display: flex; align-items: center; gap: 4px; }
        .status-icons i { font-size: 12px; }

        /* Styles for navigation buttons */
        .content-navigation {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        .content-navigation button {
            background-color: #5C2C8B;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.2s;
        }
        .content-navigation button:disabled {
            background-color: #cccccc;
            cursor: not-allowed;
        }
        .content-navigation button:hover:not(:disabled) {
            background-color: #7d44c4;
        }

        /* Sub-submodule accordion styling (refined) */
        .submodule-accordion-item {
            border: none;
            margin-bottom: 8px; /* Spacing between submodule items */
        }
        .submodule-accordion-header {
            margin-left: 30px; /* Indent like sub-titles */
            margin-bottom: 0; /* Remove default margin */
        }
        .submodule-accordion-button {
            font-size: 14px; /* Slightly larger for better readability */
            padding: 5px 0; /* Vertical padding for button text */
            cursor: pointer;
            display: flex;
            align-items: center;
            color: #5C2C8B;
            transition: color 0.2s;
            font-weight: bold;
            background: none; /* Remove default button background */
            border: none;
            width: 100%;
            text-align: left;
        }
        .submodule-accordion-button:hover {
            color: #7d44c4;
        }
        .submodule-accordion-button:focus {
            box-shadow: none;
            outline: none;
        }
        .submodule-icon {
            margin-right: 8px; /* More space between icon and text */
            font-size: 14px; /* Consistent size with video-title icons */
            color: #888;
            transition: transform 0.2s ease-in-out; /* Keep transition for smooth icon change */
        }
        .submodule-items-wrapper {
            padding-left: 45px; /* Indent items further than submodule title */
            padding-top: 5px;
            padding-bottom: 5px;
        }

        /* Adjustments for responsiveness */
        @media (min-width: 992px) {
            /* Fixed widths for Lg screens */
            .col-lg-3 { width: 25%; }
            .col-lg-6 { width: 50%; }
            /* No need for .main-content-area as its layout is now handled by top-level cols */
            .course-timeline { align-self: flex-start; } /* Keep this for vertical alignment */
        }
        @media (max-width: 768px) {
            .containers { margin: 0 20px; }
            .navbar { height: 80px; }
            .navbar img { height: 80px; }
            .righ-section { border-right: none; padding-right: 0; margin-bottom: 20px; }
            .course-sidebar, .content-card, .course-timeline { padding: 15px; }
            /* On medium/small screens, Bootstrap will naturally stack them. */
        }
    </style>
</head>

<body>

    <nav class="navbar">
        <img src="images/epic-logo.svg" alt="EPIC LMS">
        <div class="ms-auto" style="font-size:18px; color: #5C2C8B;">
            <i class="bi bi-bell-fill me-3"></i>
            <i class="bi bi-person-circle"></i>
        </div>
    </nav>

    <div class="containers">
        <section class="section">
            <div class="row">
                <div class="col-lg-3 col-md-4 mb-4">
                    <div class="course-sidebar">
                        <h5>Clinical Data Management Basics</h5>
                        <div class="mentor-section">
                            <div class="mentor-image">
                                <img src="https://www.iconpacks.net/icons/2/free-user-icon-3296-thumb.png" alt="Mentor Image">
                            </div>
                            <div class="mentor-name">
                                <p>Mentor: Mr. Azam Ansari</p>
                            </div>
                        </div>

                        <div class="accordion" id="sidebarAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingStudy">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseStudy" aria-expanded="true" aria-controls="collapseStudy">
                                        <span class="icon-wrapper"><i class="bi bi-chevron-right toggle-icon"></i></span>
                                        Study Material
                                    </button>
                                </h2>
                                <div id="collapseStudy" class="accordion-collapse collapse show" aria-labelledby="headingStudy">
                                    <div class="accordion-body p-2 ps-4 sub-accordion-body">
                                        <div class="accordion" id="moduleAccordion">
                                            <div class="accordion-item">
                                                <h2 class="accordion-header" id="mod1head">
                                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#mod1content" data-module="module1">
                                                        <span class="icon-wrapper"><i class="bi bi-circle module-toggle-icon"></i></span>
                                                        Module 1
                                                    </button>
                                                </h2>
                                                <div id="mod1content" class="accordion-collapse collapse show" aria-labelledby="mod1head">
                                                    <div class="accordion-body p-2 submodule-accordion-wrapper accordion" id="mod1-submodule-accordion">
                                                        <div class="submodule-accordion-item">
                                                            <h6 class="submodule-accordion-header">
                                                                <button class="submodule-accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#mod1-sub1-items" data-module="module1" data-submodule="mod1-sub1">
                                                                    <i class="bi bi-chevron-right submodule-icon"></i> Basics of Drug Discovery
                                                                </button>
                                                            </h6>
                                                            <div id="mod1-sub1-items" class="collapse submodule-items-wrapper" data-bs-parent="#mod1-submodule-accordion">
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="0"><img src="images/play.svg" class="img-icon"> Video 1</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="1"><img src="images/play.svg" class="img-icon"> Video 2</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="2"><img src="images/play.svg" class="img-icon"> Video 3</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="3"><img src="images/play.svg" class="img-icon"> Video 4</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="4"><img src="images/play.svg" class="img-icon"> Video 5</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="5"><img src="images/doc.svg" class="img-icon"> Reading</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="6"><img src="images/doc.svg" class="img-icon"> Study Start-up</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub1" data-item-index="7"><img src="images/doc.svg" class="img-icon"> Quiz</div>
                                                            </div>
                                                        </div>

                                                        <div class="submodule-accordion-item">
                                                            <h6 class="submodule-accordion-header">
                                                                <button class="submodule-accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#mod1-sub2-items" data-module="module1" data-submodule="mod1-sub2">
                                                                    <i class="bi bi-chevron-right submodule-icon"></i> Clinical Trial Phases
                                                                </button>
                                                            </h6>
                                                            <div id="mod1-sub2-items" class="collapse submodule-items-wrapper" data-bs-parent="#mod1-submodule-accordion">
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub2" data-item-index="0"><img src="images/play.svg" class="img-icon"> Phase 1 Video</div>
                                                                <div class="video-title" data-module="module1" data-submodule="mod1-sub2" data-item-index="1"><img src="images/doc.svg" class="img-icon"> Phase 2 Doc</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header" id="mod2head">
                                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#mod2content" data-module="module2">
                                                        <span class="icon-wrapper"><i class="bi bi-circle module-toggle-icon"></i></span>
                                                        Module 2
                                                    </button>
                                                </h2>
                                                <div id="mod2content" class="accordion-collapse collapse" aria-labelledby="mod2head">
                                                    <div class="accordion-body p-2 submodule-accordion-wrapper accordion" id="mod2-submodule-accordion">
                                                        <div class="submodule-accordion-item">
                                                            <h6 class="submodule-accordion-header">
                                                                <button class="submodule-accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#mod2-sub1-items" data-module="module2" data-submodule="mod2-sub1">
                                                                    <i class="bi bi-chevron-right submodule-icon"></i> Advanced Data Validation
                                                                </button>
                                                            </h6>
                                                            <div id="mod2-sub1-items" class="collapse submodule-items-wrapper" data-bs-parent="#mod2-submodule-accordion">
                                                                <div class="video-title" data-module="module2" data-submodule="mod2-sub1" data-item-index="0"><img src="images/play.svg" class="img-icon"> Video A</div>
                                                                <div class="video-title" data-module="module2" data-submodule="mod2-sub1" data-item-index="1"><img src="images/doc.svg" class="img-icon"> Article B</div>
                                                            </div>
                                                        </div>
                                                        <div class="submodule-accordion-item">
                                                            <h6 class="submodule-accordion-header">
                                                                <button class="submodule-accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#mod2-sub2-items" data-module="module2" data-submodule="mod2-sub2">
                                                                    <i class="bi bi-chevron-right submodule-icon"></i> Regulatory Affairs
                                                                </button>
                                                            </h6>
                                                            <div id="mod2-sub2-items" class="collapse submodule-items-wrapper" data-bs-parent="#mod2-submodule-accordion">
                                                                <div class="video-title" data-module="module2" data-submodule="mod2-sub2" data-item-index="0"><img src="images/doc.svg" class="img-icon"> Regulatory Guidelines</div>
                                                                <div class="video-title" data-module="module2" data-submodule="mod2-sub2" data-item-index="1"><img src="images/play.svg" class="img-icon"> Approval Process</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingGrades">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseGrades" aria-expanded="false" aria-controls="collapseGrades">
                                        <span class="icon-wrapper"><i class="bi bi-chevron-right toggle-icon"></i></span>
                                        Grades
                                    </button>
                                </h2>
                                <div id="collapseGrades" class="accordion-collapse collapse" aria-labelledby="headingGrades">
                                    <div class="accordion-body ps-4">
                                        <p>No grades available yet.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 col-md-8 mb-4">
                    <div class="content-card" id="main-content-display">
                        </div>
                </div>

                <div class="col-lg-3 col-md-12 mb-4">
                    <div class="course-timeline">
                        <h5>Course Timeline</h5>
                        <div class="timeline-item1 bold start-end">
                            <div class="timeline-icon"><i class="bi bi-geo-alt-fill"></i></div>
                            <div class="timeline-content">
                                <span class="timeline-title">Start Date</span>
                                <span class="timeline-status">29th Dec 2024</span>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-icon"><i class="bi bi-file-earmark-text-fill"></i></div>
                            <div class="timeline-content">
                                <span class="timeline-title">Assignment 1</span>
                                <span class="timeline-status">Completed</span>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-icon"><i class="bi bi-file-earmark-text-fill"></i></div>
                            <div class="timeline-content">
                                <span class="timeline-title">Assignment 2</span>
                                <span class="timeline-status">Due in 2 days</span>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-icon"><i class="bi bi-file-earmark-text-fill"></i></div>
                            <div class="timeline-content">
                                <span class="timeline-title">Assignment 3</span>
                                <span class="timeline-status">Due in 15 days</span>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-icon"><i class="bi bi-file-earmark-text-fill"></i></div>
                            <div class="timeline-content">
                                <span class="timeline-title">Assignment 4</span>
                                <span class="timeline-status">Due in 25 days</span>
                            </div>
                        </div>
                        <div class="timeline-item1 bold start-end">
                            <div class="timeline-icon"><i class="bi bi-trophy-fill"></i></div>
                            <div class="timeline-content">
                                <span class="timeline-title">End Date</span>
                                <span class="timeline-status">29th Jan 2025</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

    <script src="assets/select2/dist/js/select2.full.js"></script>
    <script src="assets/moment/min/moment.min.js"></script>
    <script src="assets/bootstrap-daterangepicker/daterangepicker.js"></script>
    <script src="assets/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="assets/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/functions.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Function to handle accordion toggle icons for main accordions (Study Material, Grades)
            // and Modules (Module 1, Module 2)
            function setupMainAccordionIcons(accordionId, collapsedIconClass, expandedIconClass, iconSelector, iconShouldChange = true) {
                document.querySelectorAll(`#${accordionId} .accordion-collapse`).forEach(function (collapseEl) {
                    const headerButton = document.querySelector(`[data-bs-target="#${collapseEl.id}"]`);
                    if (!headerButton) return;

                    const icon = headerButton.querySelector(iconSelector);
                    if (!icon) return;

                    if (iconShouldChange) {
                        // Set initial state
                        if (collapseEl.classList.contains('show')) {
                            icon.classList.remove(collapsedIconClass);
                            icon.classList.add(expandedIconClass);
                        } else {
                            icon.classList.remove(expandedIconClass);
                            icon.classList.add(collapsedIconClass);
                        }

                        // Event listeners for state changes
                        collapseEl.addEventListener('show.bs.collapse', function () {
                            icon.classList.remove(collapsedIconClass);
                            icon.classList.add(expandedIconClass);
                        });

                        collapseEl.addEventListener('hide.bs.collapse', function () {
                            icon.classList.remove(expandedIconClass);
                            icon.classList.add(collapsedIconClass);
                        });
                    } else {
                        // If icon should not change, just ensure it's the collapsed icon
                        icon.classList.remove(expandedIconClass);
                        icon.classList.add(collapsedIconClass);
                    }
                });
            }

            // Dedicated setup for submodule accordion icons
            function setupSubmoduleAccordionIcons() {
                document.querySelectorAll('.submodule-accordion-item').forEach(submoduleItem => {
                    const button = submoduleItem.querySelector('.submodule-accordion-button');
                    const collapseEl = submoduleItem.querySelector('.collapse.submodule-items-wrapper');
                    const icon = button.querySelector('.submodule-icon');

                    if (!button || !collapseEl || !icon) return;

                    // Initial state
                    if (collapseEl.classList.contains('show')) {
                        icon.classList.remove('bi-chevron-right');
                        icon.classList.add('bi-chevron-down');
                    } else {
                        icon.classList.remove('bi-chevron-down');
                        icon.classList.add('bi-chevron-right');
                    }

                    // Event listeners
                    collapseEl.addEventListener('show.bs.collapse', function() {
                        icon.classList.remove('bi-chevron-right');
                        icon.classList.add('bi-chevron-down');
                    });
                    collapseEl.addEventListener('hide.bs.collapse', function() {
                        icon.classList.remove('bi-chevron-down');
                        icon.classList.add('bi-chevron-right');
                    });
                });
            }

            // Function to open corresponding sidebar accordions and highlight submodule
            function activateSidebarItem(moduleId, submoduleId) {
                // 1. Open 'Study Material' accordion
                const studyMaterialCollapse = document.getElementById('collapseStudy');
                if (studyMaterialCollapse && !studyMaterialCollapse.classList.contains('show')) {
                    new bootstrap.Collapse(studyMaterialCollapse, { toggle: false }).show();
                }

                // 2. Open the specific Module accordion
                const moduleCollapseId = `${moduleId}content`; // e.g., mod1content
                const moduleCollapse = document.getElementById(moduleCollapseId);
                if (moduleCollapse && !moduleCollapse.classList.contains('show')) {
                    new bootstrap.Collapse(moduleCollapse, { toggle: false }).show();
                }

                // 3. Open the specific Submodule accordion
                const submoduleCollapseId = `${submoduleId}-items`; // e.g., mod1-sub1-items
                const submoduleCollapse = document.getElementById(submoduleCollapseId);
                if (submoduleCollapse && !submoduleCollapse.classList.contains('show')) {
                    new bootstrap.Collapse(submoduleCollapse, { toggle: false }).show();
                }

                // 4. Highlight the active submodule button (existing logic)
                // Remove active class from all submodule titles first
                document.querySelectorAll('.submodule-accordion-button').forEach(btn => {
                    btn.classList.remove('active-submodule');
                });
                // Add active class to the clicked submodule title
                const activeBtn = document.querySelector(`.submodule-accordion-button[data-module="${moduleId}"][data-submodule="${submoduleId}"]`);
                if (activeBtn) {
                    activeBtn.classList.add('active-submodule');
                }
            }


            // --- Apply icon setup functions ---
            setupMainAccordionIcons('sidebarAccordion', 'bi-chevron-right', 'bi-chevron-down', '.toggle-icon', true);
            setupMainAccordionIcons('moduleAccordion', 'bi-circle', 'bi-circle', '.module-toggle-icon', false);
            setupSubmoduleAccordionIcons();


            // --- Data Structure for Course Content ---
            const courseContent = {
                'module1': {
                    title: 'Module 1 - General',
                    submodules: {
                        'mod1-sub1': {
                            title: 'Basics of Drug Discovery',
                            introduction: 'Welcome to the Basics of Drug Discovery submodule! In this section, you will learn about the foundational steps involved in bringing a new drug to market, from initial research to preclinical testing. This module sets the stage for understanding the entire drug development lifecycle.',
                            items: [
                                { type: 'video', title: 'Video 1: Introduction to Drug Discovery', src: 'videos/mod1_video1.mp4', description: 'An introductory video covering the fundamental concepts of drug discovery.' },
                                { type: 'video', title: 'Video 2: Target Identification and Validation', src: 'videos/mod1_video2.mp4', description: 'Learn how to identify and validate potential drug targets.' },
                                { type: 'video', title: 'Video 3: Lead Compound Discovery', src: 'videos/mod1_video3.mp4', description: 'Explore methods for discovering lead compounds.' },
                                { type: 'video', title: 'Video 4: Preclinical Development Stages', src: 'videos/mod1_video4.mp4', description: 'Overview of the stages involved in preclinical drug development.' },
                                { type: 'video', title: 'Video 5: Regulatory Considerations', src: 'videos/mod1_video5.mp4', description: 'Key regulatory aspects in the early phases of drug development.' },
                                { type: 'document', title: 'Reading: Study Start-up Process', src: 'docs/mod1_reading1.pdf', description: 'A comprehensive guide to initiating a clinical study.' },
                                { type: 'document', title: 'Study Start-up Checklist', src: 'docs/mod1_checklist.pdf', description: 'A practical checklist for study initiation.' },
                                { type: 'quiz', title: 'Quiz: Drug Discovery Fundamentals', src: 'quizzes/mod1_quiz1.html', description: 'Test your knowledge on the basics of drug discovery.' }
                            ]
                        },
                        'mod1-sub2': {
                            title: 'Clinical Trial Phases',
                            introduction: 'This submodule delves into the various phases of clinical trials, from initial human testing to post-market surveillance. Understanding these phases is crucial for anyone involved in clinical research.',
                            items: [
                                { type: 'video', title: 'Phase 1 Video: Safety and Dosage', src: 'videos/mod1_sub2_video1.mp4', description: 'Understanding the objectives and procedures of Phase 1 clinical trials.' },
                                { type: 'document', title: 'Phase 2 Document: Efficacy and Side Effects', src: 'docs/mod1_sub2_doc1.pdf', description: 'Detailed information on Phase 2 trials, focusing on efficacy and common side effects.' }
                            ]
                        }
                    }
                },
                'module2': {
                    title: 'Module 2 - Advanced Topics',
                    submodules: {
                        'mod2-sub1': {
                            title: 'Advanced Data Validation',
                            introduction: 'Explore advanced techniques for validating clinical data, ensuring accuracy and integrity throughout the data management process.',
                            items: [
                                { type: 'video', title: 'Video A: Cross-form Validation', src: 'videos/mod2_videoA.mp4', description: 'Techniques for validating data across multiple forms.' },
                                { type: 'document', title: 'Article B: External Data Reconciliation', src: 'docs/mod2_docB.pdf', description: 'Methods for reconciling data from external sources.' }
                            ]
                        },
                        'mod2-sub2': {
                            title: 'Regulatory Affairs',
                            introduction: 'Understand the complex landscape of regulatory affairs in clinical data management, including key guidelines and approval processes.',
                            items: [
                                { type: 'document', title: 'Regulatory Guidelines Document', src: 'docs/mod2_sub2_doc1.pdf', description: 'Key regulatory guidelines for clinical data management (e.g., FDA, ICH).' },
                                { type: 'video', title: 'Approval Process Overview', src: 'videos/mod2_sub2_video1.mp4', description: 'A walkthrough of the regulatory approval process for new drugs.' }
                            ]
                        }
                    }
                }
            };

            const mainContentDisplay = document.getElementById('main-content-display');
            let currentModuleId = null;
            let currentSubmoduleId = null;
            let currentItemIndex = -1; // -1 for introduction page, 0 for first actual item

            function updateNavigationButtons() {
                const prevBtn = document.getElementById('prevItemBtn');
                const nextBtn = document.getElementById('nextItemBtn');

                if (!prevBtn || !nextBtn || !currentSubmoduleId) { // Hide if not in a submodule or buttons don't exist
                    if (prevBtn) prevBtn.style.display = 'none';
                    if (nextBtn) nextBtn.style.display = 'none';
                    return;
                }

                prevBtn.style.display = 'inline-block';
                nextBtn.style.display = 'inline-block';

                const submodule = courseContent[currentModuleId]?.submodules[currentSubmoduleId];
                if (!submodule) {
                    prevBtn.disabled = true;
                    nextBtn.disabled = true;
                    return;
                }

                prevBtn.disabled = currentItemIndex <= -1; // Disabled if on intro or before intro
                nextBtn.disabled = currentItemIndex >= submodule.items.length - 1;
            }

            function displayModuleOverview(moduleId) {
                currentModuleId = moduleId;
                currentSubmoduleId = null; // Reset submodule when viewing module overview
                currentItemIndex = -1; // Reset item index to ensure intro logic on next submodule click

                // Ensure any open submodules in sidebar are closed when viewing a module overview
                document.querySelectorAll('.submodule-items-wrapper.show').forEach(collapseEl => {
                    const bsCollapse = new bootstrap.Collapse(collapseEl, { toggle: false });
                    bsCollapse.hide();
                });
                // Clear any active submodule highlighting
                document.querySelectorAll('.submodule-accordion-button').forEach(btn => {
                    btn.classList.remove('active-submodule');
                });
                // Clear any active content item highlighting
                document.querySelectorAll('.video-title').forEach(item => {
                    item.classList.remove('active-content-item');
                });


                const module = courseContent[moduleId];
                if (!module) {
                    mainContentDisplay.innerHTML = `<h5>Module Not Found</h5><p>The selected module could not be loaded.</p>`;
                    updateNavigationButtons();
                    return;
                }

                let html = `
                    <h5>${module.title} Overview</h5>
                    <p>Select a submodule below to view its contents:</p>
                    <ul class="module-list-overview">
                `;

                for (const subId in module.submodules) {
                    const submodule = module.submodules[subId];
                    const videoCount = submodule.items.filter(item => item.type === 'video').length;
                    const docCount = submodule.items.filter(item => item.type === 'document').length;
                    const quizCount = submodule.items.filter(item => item.type === 'quiz').length;

                    html += `
                        <li data-module="${moduleId}" data-submodule="${subId}">
                            <a href="#">
                                <i class="bi bi-book-fill"></i> ${submodule.title}
                            </a>
                            <div class="status-icons">
                                ${videoCount > 0 ? `<div class="item"><img src="images/play.svg" class="img-icon"><span>${videoCount} Videos</span></div>` : ''}
                                ${docCount > 0 ? `<div class="item"><img src="images/doc.svg" class="img-icon"><span>${docCount} Docs</span></div>` : ''}
                                ${quizCount > 0 ? `<div class="item"><img src="images/doc.svg" class="img-icon"><span>${quizCount} Quiz</span></div>` : ''}
                            </div>
                        </li>
                    `;
                }
                html += `</ul>`;
                mainContentDisplay.innerHTML = html;

                // Add event listeners to the newly created submodule list items in the overview
                mainContentDisplay.querySelectorAll('.module-list-overview li').forEach(li => {
                    li.addEventListener('click', function() {
                        const module = this.getAttribute('data-module');
                        const submodule = this.getAttribute('data-submodule');
                        displaySubmoduleOverview(module, submodule);
                    });
                });
                updateNavigationButtons();
            }

            function displaySubmoduleOverview(moduleId, submoduleId) {
                currentModuleId = moduleId;
                currentSubmoduleId = submoduleId;
                currentItemIndex = -1; // Indicates we are on the introduction page

                // Clear any active content item highlighting
                document.querySelectorAll('.video-title').forEach(item => {
                    item.classList.remove('active-content-item');
                });

                if (!submoduleId || !courseContent[moduleId] || !courseContent[moduleId].submodules[submoduleId]) {
                    mainContentDisplay.innerHTML = `<h5>Submodule Not Found</h5><p>The selected submodule could not be loaded.</p>`;
                    updateNavigationButtons();
                    return;
                }

                const module = courseContent[moduleId];
                const submodule = module.submodules[submoduleId];

                let contentHtml = `
                    <h5>${submodule.title} - Introduction</h5>
                    <p>${submodule.introduction || 'Welcome to this submodule! Click "Next" to begin with the first content item.'}</p>
                    <div class="content-navigation">
                        <button id="prevItemBtn">Previous</button>
                        <button id="nextItemBtn">Next</button>
                    </div>
                `;
                mainContentDisplay.innerHTML = contentHtml;

                attachNavigationButtonListeners();
                updateNavigationButtons();
                activateSidebarItem(moduleId, submoduleId); // Activate sidebar when submodule overview is displayed
            }

            function displaySubmoduleItem(moduleId, submoduleId, itemIndex) {
                currentModuleId = moduleId;
                currentSubmoduleId = submoduleId;
                currentItemIndex = itemIndex;

                const module = courseContent[moduleId];
                const submodule = module?.submodules[submoduleId];
                const item = submodule?.items[itemIndex];

                // Clear any active content item highlighting
                document.querySelectorAll('.video-title').forEach(el => {
                    el.classList.remove('active-content-item');
                });
                // Add active class to the current item
                const activeItem = document.querySelector(`.video-title[data-module="${moduleId}"][data-submodule="${submoduleId}"][data-item-index="${itemIndex}"]`);
                if (activeItem) {
                    activeItem.classList.add('active-content-item');
                }


                if (!item) {
                    mainContentDisplay.innerHTML = `<h5>Content Not Found</h5><p>The selected content item could not be loaded.</p>`;
                    updateNavigationButtons();
                    return;
                }

                let contentHtml = `
                    <h5>${submodule.title} - ${item.title}</h5>
                    <p>${item.description}</p>
                `;

                if (item.type === 'video') {
                    contentHtml += `<div class="video-player mt-4">
                                        <video width="100%" controls>
                                            <source src="${item.src}" type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>
                                    </div>`;
                } else if (item.type === 'document') {
                    contentHtml += `<div class="document-viewer mt-4">
                                        <iframe src="${item.src}" width="100%" height="400px" style="border:none;"></iframe>
                                        <p class="mt-2"><a href="${item.src}" target="_blank" download>Download Document</a></p>
                                    </div>`;
                } else if (item.type === 'quiz') {
                    contentHtml += `<div class="quiz-content mt-4">
                                        <p>Quiz content for: ${item.title}</p>
                                        <p>You can embed an iframe or load quiz content here dynamically.</p>
                                        </div>`;
                }

                // Add navigation buttons
                contentHtml += `
                    <div class="content-navigation">
                        <button id="prevItemBtn">Previous</button>
                        <button id="nextItemBtn">Next</button>
                    </div>
                `;

                mainContentDisplay.innerHTML = contentHtml;

                attachNavigationButtonListeners();
                updateNavigationButtons();
                activateSidebarItem(moduleId, submoduleId); // Activate sidebar when an item is displayed
            }

            function attachNavigationButtonListeners() {
                const prevBtn = document.getElementById('prevItemBtn');
                const nextBtn = document.getElementById('nextItemBtn');

                if (prevBtn) {
                    prevBtn.onclick = () => {
                        if (currentItemIndex === 0) { // If currently on first actual item, go to introduction
                            displaySubmoduleOverview(currentModuleId, currentSubmoduleId);
                        } else if (currentItemIndex > 0) {
                            displaySubmoduleItem(currentModuleId, currentSubmoduleId, currentItemIndex - 1);
                        }
                    };
                }
                if (nextBtn) {
                    nextBtn.onclick = () => {
                        const submodule = courseContent[currentModuleId]?.submodules[currentSubmoduleId];
                        if (submodule) {
                            if (currentItemIndex === -1) { // If on introduction, go to first actual item
                                displaySubmoduleItem(currentModuleId, currentSubmoduleId, 0);
                            } else if (currentItemIndex < submodule.items.length - 1) {
                                displaySubmoduleItem(currentModuleId, currentSubmoduleId, currentItemIndex + 1);
                            }
                        }
                    };
                }
            }


            // Event Listeners for Module Accordion Buttons
            document.querySelectorAll('#moduleAccordion .accordion-button').forEach(button => {
                button.addEventListener('click', function() {
                    const moduleId = this.getAttribute('data-module');
                    const targetCollapseId = this.getAttribute('data-bs-target'); // e.g., #mod1content
                    const targetCollapseEl = document.querySelector(targetCollapseId);

                    // If the module content is currently shown (i.e., this click will close it)
                    if (targetCollapseEl && targetCollapseEl.classList.contains('show')) {
                        // Do nothing, let Bootstrap handle the collapse.
                    } else {
                        // If the module content is not shown (i.e., this click will open it)
                        displayModuleOverview(moduleId);
                    }

                    // Manually close other open modules within the same accordion
                    document.querySelectorAll('#moduleAccordion .accordion-collapse.show').forEach(otherCollapseEl => {
                        if (otherCollapseEl.id !== targetCollapseEl.id) {
                            new bootstrap.Collapse(otherCollapseEl, { toggle: false }).hide();
                        }
                    });

                    // Also close any open submodules across all modules when a new module is opened
                    document.querySelectorAll('.submodule-items-wrapper.show').forEach(subCollapseEl => {
                        new bootstrap.Collapse(subCollapseEl, { toggle: false }).hide();
                    });
                });
            });


            // MODIFIED: Event Listener for Submodule Accordion Buttons
            document.querySelectorAll('.submodule-accordion-button').forEach(button => {
                button.addEventListener('click', function() {
                    const moduleId = this.getAttribute('data-module');
                    const submoduleId = this.getAttribute('data-submodule');
                    const targetCollapseId = this.getAttribute('data-bs-target'); // e.g., #mod1-sub1-items
                    const targetCollapseEl = document.querySelector(targetCollapseId);

                    // Use Bootstrap's collapse instance to toggle
                    const bsCollapse = new bootstrap.Collapse(targetCollapseEl, { toggle: false });

                    if (targetCollapseEl.classList.contains('show')) {
                        // If it's currently open, this click will close it.
                        // Hide the content display by going back to the module overview.
                        displayModuleOverview(moduleId);
                        // Explicitly hide the sidebar collapse element
                        bsCollapse.hide();
                    } else {
                        // If it's currently closed, this click will open it.
                        // Show the submodule overview.
                        displaySubmoduleOverview(moduleId, submoduleId);
                        // Explicitly show the sidebar collapse element (though data-bs-toggle handles this)
                        bsCollapse.show();
                    }
                });
            });


            // Event Listeners for Individual Content Items (Video 1, Reading, etc.) in sidebar
            const videoTitles = document.querySelectorAll('.video-title');
            videoTitles.forEach(item => {
                item.addEventListener('click', function() {
                    const module = this.getAttribute('data-module');
                    const submodule = this.getAttribute('data-submodule');
                    const itemIndex = parseInt(this.getAttribute('data-item-index'));

                    // Ensure the parent submodule accordion is open when an item is clicked directly
                    const parentCollapseId = this.closest('.submodule-items-wrapper').id;
                    const parentCollapseEl = document.getElementById(parentCollapseId);
                    if (parentCollapseEl && !parentCollapseEl.classList.contains('show')) {
                        const bsCollapse = new bootstrap.Collapse(parentCollapseEl, { toggle: false });
                        bsCollapse.show();
                    }

                    displaySubmoduleItem(module, submodule, itemIndex);
                });
            });


            // Initial Load Logic
            const initialModuleId = 'module1';

            // Ensure Module 1 is displayed and its accordion is open on initial load
            const module1CollapseElement = document.getElementById('mod1content');
            if (module1CollapseElement) {
                // If it's already open by default in HTML, just trigger its show event logic
                if (module1CollapseElement.classList.contains('show')) {
                    displayModuleOverview(initialModuleId);
                } else {
                    // Otherwise, programmatically show it
                    new bootstrap.Collapse(module1CollapseElement, { toggle: false }).show();
                }
            }
        });
    </script>

</body>
</html>