<?php 
$page_name = 'Add Employee';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        VIEW EMPLOYEE DATA
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="employee_master.php">Category</a></li>
        <li class="active">View Employee</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <!--<p class="box-title">* All fields marked with an asterisk are readonly</p>-->
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="employeeForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Name</label>
                                <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" readonly>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Category</label>
                                <select class="form-control select21" id="course_category" name="course_category" data-placeholder="Select Category"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Level</label>
                                <select class="form-control select21" id="level" name="level" data-placeholder="Select Level"
                                        style="width: 100%;">
                                    <option value="1">Level 1</option>
                                    <option value="2">Level 2</option>
                                    <option value="3">Level 3</option>
                                </select>
                            </div>
                        </div>                         
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Installments</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_installments" name="no_of_installments" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Documents</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_documents" name="no_of_documents" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Hours (In Mins)</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_hours" name="no_of_hours" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Assesments</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_assesments" name="no_of_assesments" readonly>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No Of Quizes</label>
                                <input class="form-control" type="text" autocomplete="off" id="no_of_quizes" name="no_of_quizes" readonly>
                            </div>
                        </div>   

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Fees</label>
                                <input class="form-control" type="text" autocomplete="off" id="course_fees" name="course_fees" readonly>
                            </div>
                        </div>      
                                                
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Start Date</label>
                                <input class="form-control" type="date" autocomplete="off" id="course_start_date" name="course_start_date" readonly>
                            </div>
                        </div>
                        

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course End Date</label>
                                <input class="form-control" type="date" autocomplete="off" id="course_end_date" name="course_end_date" readonly>
                            </div>
                        </div>
 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Mentrors</label>
                                <select class="form-control select2" multiple="multiple" id="course_mentors" name="course_mentors" data-placeholder="Select Mentors"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Language</label>
                                <select class="form-control select21" id="language" name="language" data-placeholder="Select Language"
                                        style="width: 100%;">
                                    <option value="english">English</option>
                                    <option value="marathi">Marathi</option>
                                    <option value="hindi">Hindi</option>
                                </select>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Keywords</label>
                                <input class="form-control" type="text" autocomplete="off" id="keywords" name="keywords" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Outcomes</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="outcomes" name="outcomes"></textarea>
                            </div>
                        </div>                          
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                            </div>
                        </div>
                        
                    </div>
                
                
                    <div class="box-footer">
                        <a href="course_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>

const urlParams = new URLSearchParams(window.location.search);
const employeeId = urlParams.get('id'); // Extract employee_id from URL

if (employeeId) {
    prepopulateCourseForm(employeeId);  
}

</script>


</body>
</html>