<?php 
$page_name = 'View Employee';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        VIEW EMPLOYEE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="employee_master.php">Employee</a></li>
        <li class="active">View Employee</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <!--<p class="box-title">* All fields marked with an asterisk are required</p>-->
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="employeeForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>First Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="first_name" name="first_name" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Last Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="last_name" name="last_name" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Mobile No. <span class="text-danger">*</span></label>
                                <input class="form-control" type="number" autocomplete="off" id="mobile_no" name="mobile_no" readonly>
                            </div>
                        </div> 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email ID <span class="text-danger">*</span></label>
                                <input class="form-control" type="email" autocomplete="off" id="email_id" name="email_id" readonly>
                            </div>
                        </div> 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Password <span class="text-danger">*</span></label>
                                    <input class="form-control" type="password" autocomplete="off" id="password" name="password" readonly>
                                        <span class="input-group-text password-eye" id="togglePassword">
                                            <i class="fa fa-eye" id="eyeIcon"></i> <!-- Eye Icon -->
                                        </span>                                        
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Roles</label>
                                <select class="form-control select2" multiple="multiple" id="role_name" name="role_name" data-placeholder="Select roles"
                                        style="width: 100%;" readonly>
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>  
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Address</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="address" name="address" readonly></textarea>
                            </div>
                        </div> 
                        <div class="col-md-4">
                <div class="form-group">
                  <div class="radio">
                  	  <input name="block_employee" value="0" type="radio" id="Option_2" class="with-gap radio-col-red" disabled>
					  <label for="Option_2">Active</label>                    
                  </div>
                  <div class="radio">
                  	  <input name="block_employee" value="1" type="radio" id="Option_1" class="with-gap radio-col-red" disabled>
					  <label for="Option_1">Inactive</label>   
                  </div>
                </div>
                        </div>                         
                    </div>
                
                
                    <div class="box-footer">
                        <a href="employee_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
    $.ajax({
        url: 'apis/role_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (Array.isArray(data)) {

                let options = '';
                $.each(data, function(index, role) {
                    options += `<option value="${role.role_id}">${role.role_name}</option>`;
                });

                $('#role_name').html(options);

                $('#role_name').select2();
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function(error) {
            console.error('Error occurred while fetching data:', error);
        }
    });

    $('#role_name').select2({
    disabled: true // disables selection but value remains submit-able
});



    const urlParams = new URLSearchParams(window.location.search);
    const employeeId = urlParams.get('id');

    if (employeeId) {
        prepopulateEmployeeForm(employeeId);
    }

});
</script>


</body>
</html>