<?php 
$page_name = 'View Course';
require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">ADD COURSE</span>
    <ol class="breadcrumb">
      <button type="button" class="btn btn-block btn-success btn-flat">
        Draft No : <?php echo isset($_GET['draft']) ? intval($_GET['draft']) : 0 ?>
      </button>
    </ol>
  </section>

  <section class="content">
    <div class="box box-default">
      <div class="row">
        <div class="col-md-12">
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                  <li class="active"><a href="#tab_1" class="tab-link" data-toggle="tab">Course Details</a></li>
                  <li><a href="#tab_2" class="tab-link" data-toggle="tab">Modules And Course materials</a></li>
                  <li><a href="#tab_3" class="tab-link" data-toggle="tab">Submodules And Course materials</a></li>
                  <li><a href="#tab_4" class="tab-link" data-toggle="tab">Quiz</a></li>
                </ul>


            <div class="tab-content">
              <!-- TAB 1 -->
              <div class="tab-pane active" id="tab_1">
                <form id="courseForm" enctype="multipart/form-data">
                  <div class="box-body">
                    <div class="container-fluid">
                      <input type="hidden" name="draft_id" value="<?php echo $_GET['draft']; ?>">

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Title <span class="text-danger">*</span></label>
                        <div class="col-md-9">
                          <input class="form-control" type="text" id="course_title" name="course_title">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Description</label>
                        <div class="col-md-9">
                          <textarea class="form-control" id="course_description" name="course_description" rows="4"></textarea>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Category</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="category" name="category" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Mentor Name</label>
                        <div class="col-md-9">
                          <select class="form-control select2" id="mentor" multiple name="mentor[]" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Level</label>
                        <div class="col-md-6">
                          <select class="form-control select2" id="level" name="level" style="width: 100%;">
                            <option value="1">Level 1</option>
                            <option value="2">Level 2</option>
                            <option value="3">Level 3</option>
                          </select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">No Of Licenses</label>
                        <div class="col-md-9">
                          <input class="form-control" type="text" id="no_of_license" name="no_of_license">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Fees</label>
                        <div class="col-md-9">
                          <input class="form-control" type="text" id="course_fees" name="course_fees">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Language</label>
                        <div class="col-md-6">
                          <select class="form-control select2" id="language" name="language" style="width: 100%;">
                            <option value="english">English</option>
                            <option value="marathi">Marathi</option>
                            <option value="hindi">Hindi</option>
                          </select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Schedules</label>
                        <div class="col-md-2 text-center">From:</div>
                        <div class="col-md-3">
                          <input class="form-control" type="date" id="schedule_from" name="schedule_from">
                        </div>
                        <div class="col-md-1 text-center">To:</div>
                        <div class="col-md-3">
                          <input class="form-control" type="date" id="schedule_to" name="schedule_to">
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Testimonials</label>
                        <div class="col-md-9">
                          <select class="form-control select2" multiple id="testimonial" name="testimonial[]" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Proposed Courses</label>
                        <div class="col-md-6">
                          <select class="form-control select2" multiple id="proposed_course" name="proposed_course[]" style="width: 100%;"></select>
                        </div>
                      </div>

                      <div class="form-group row">
                        <label class="col-md-3 col-form-label">Course Image</label>
                        <div class="col-md-9">
                          <input class="form-control" type="file" id="course_img" name="course_img" accept="image/*">
                        </div>
                      </div>
                    </div>

                    <div class="box-footer text-center mt-4">
                      <button type="button" id="goToTab2" class="btn btn-primary">Next >></button>
                      <button type="button" class="btn btn-secondary" onclick="window.location.href='course_master.php'">Cancel</button>
                    </div>
                  </div>
                </form>
              </div>

              <!-- TAB 2: MODULES -->
              <div class="tab-pane" id="tab_2">
                  
                    <table id="dataGrid" class="table">
                    <thead style="background: #FAF7FE;">
                        <tr>
                          <th class="wd-20">Drag</th>
                          <th class="wd-20">Sr. No.</th>
                          <th class="wd-20">Module</th>
                          <th class="wd-20"><input type="checkbox" disabled style="margin-top: -15px;"></th>                          
                        </tr>
                    </thead>
                        <tbody>
                        
                        </tbody>
                    </table>
                    
                <form id="moduleForm">
                  <div class="box-body">
  <div class="row" id="contentWrapper">
    <div class="content-block row">
      <div class="col-md-1">
        <button type="button" class="btn btn-primary mb-25 mt-25" id="addMoreModule"><i class="fas fa-plus"></i></button>
      </div>
      <div class="col-md-3">
        <div class="form-group">
          <label>Module Name <span class="text-danger">*</span></label>
          <input class="form-control module-name" type="text" name="module_name[]" required>
        </div>
      </div>
      <div class="col-md-3">
        <div class="form-group">
          <label>Study Material Title <span class="text-danger">*</span></label>
          <input class="form-control" type="text" name="vidtitle[]" required>
        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
          <label>Upload File <span class="text-danger">*</span></label>
          <input class="form-control" type="file" name="study_files[]" accept="video/*,application/pdf,image/*" required>
        </div>
      </div>
      <div class="col-md-1">
        <!-- For the initial row no remove button -->
        <button type="button" class="btn btn-primary mb-25 mt-25 btn-circle addMorecontent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
      </div>
    </div>
  </div>

  <div class="box-footer">
    <button type="button" id="goToTab3" class="btn btn-primary">Next >></button>
    <button type="button" id="goToTab1" class="btn btn-secondary"><< Back</button>
  </div>
</div>

                </form>
              </div>

              <!-- TAB 3 -->
              <div class="tab-pane" id="tab_3">
                <form id="submoduleForm">
                  <div class="box-body">
                    <div class="row" id="contentWrapperSubModule">
                      <div class="content-block row">
                        <div class="col-md-1">
                          <button type="button" class="btn btn-primary mb-25 mt-25" id="addMoreSubModule"><i class="fas fa-plus"></i></button>
                        </div>
                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Modules</label>
                                <select class="form-control select2" id="module_name_id" name="module_name_id" data-placeholder="Select submodules"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>                        
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Submodule Name <span class="text-danger">*</span></label>
                            <input class="form-control module-name" type="text" name="submodule_name[]" required>
                          </div>
                        </div>
                        <div class="col-md-3">
                          <div class="form-group">
                            <label>Study Material Title <span class="text-danger">*</span></label>
                            <input class="form-control" type="text" name="vidtitlesub[]" required>
                          </div>
                        </div>
                        <div class="col-md-4">
                          <div class="form-group">
                            <label>Upload File <span class="text-danger">*</span></label>
                            <input class="form-control" type="file" name="study_files_sub[]" accept="video/*,application/pdf,image/*" required>
                          </div>
                        </div>
                        <div class="col-md-1">
                          <button type="button" class="btn btn-primary mb-25 mt-25 btn-circle addMoreSubContent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                        </div>
                      </div>
                    </div>

                    <div class="box-footer">
                      <button type="button" id="goToTab4" class="btn btn-primary">Next >></button>
                      <button type="button" id="goToTab02" class="btn btn-secondary"><< Back</button>
                    </div>
                  </div>
                </form>
              </div>

              <!-- TAB 4 -->
              <div class="tab-pane" id="tab_4">
                <table id="quizDataGrid" class="display table table-bordered table-striped">
                  <thead>
                    <tr>
                      <th>Sr. No.</th>
                      <th>Quiz Title</th>
                      <th>Module</th>
                      <th>Submodule</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
                <div id="loader" style="display:none;">Loading...</div>


              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<!-- jQuery UI -->
<script src="https://code.jquery.com/ui/1.13.0/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.0/themes/base/jquery-ui.css">


<!-- Bootstrap JS (v3 or v4 depending on your CSS) -->
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<!-- OR for Bootstrap 4 -->
<!-- <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script> -->

<script>
function makeCourseFormReadOnly() {
    $('#courseForm input, #courseForm textarea, #courseForm select').prop('readonly', true).prop('disabled', true);
    // Specifically handle file input to just display current image or hide it
    $('#course_img').hide(); // or replace with a div showing the image if it exists
    $('#courseForm button').hide(); // Hide buttons like "Next" and "Cancel"
}

$(document).ready(function () {
    makeCourseFormReadOnly();
});
</script>

<!--for course-->
<script>

$(document).ready(function () {
    
//     $('.tab-link').on('click', function (e) {
//     e.preventDefault();
//     e.stopImmediatePropagation(); 
//     return false; 
//   });
  
  // Tab navigation
  $('#goToTab1').on('click', function () {
    $('a[href="#tab_1"]').tab('show');
  });
  $(document).ready(function () {
  $('#goToTab2').on('click', function () {
    const courseTitle = $('#course_title').val().trim();
    const category = $('#category').val();

    if (courseTitle === '' || category === '') {
      alert('Please fill out both Course Title and Category before proceeding.');
      return;
    }

    const formData = new FormData($('#courseForm')[0]);

    $.ajax({
  url: 'apis/save_course_draft.php',
  type: 'POST',
  data: formData,
  contentType: false,
  processData: false,
  dataType: 'json', // 👈 Important
  success: function (res) {
    if (res.success) {
      $('a[href="#tab_2"]').tab('show');
    } else {
      alert('Error saving data: ' + res.message);
    }
  },
  error: function () {
    alert('AJAX error while saving data.');
  }
});

  });
});



 
  $('#goToTab02').on('click', function () {
    $('a[href="#tab_2"]').tab('show');
  });
  
  
  $('#goToTab3').on('click', function () {
    $('a[href="#tab_3"]').tab('show');
  });
  
  $('#goToTab4').on('click', function () {
    $('a[href="#tab_4"]').tab('show');
  });
 

  

  
    $.ajax({
        url: 'apis/module_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (Array.isArray(data)) {
                let options = '';
                $.each(data, function(index, submodule) {
                    options += `<option value="${submodule.module_id}">${submodule.module_name}</option>`;
                });
                $('#module_name_id').html(options);

                // Initialize Select2 after adding the options
                $('#module_name_id').select2();
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function(error) {
            console.error('Error occurred while fetching data:', error);
        }
    });
    
    
    
    
    
    
    
    
    
    
    

 

    
   
   
   
  const draftId = "<?php echo $_GET['draft']; ?>";

  if (draftId) {
    $.ajax({
      url: 'apis/get_course_single_api.php',
      method: 'GET',
      data: { draft: draftId },
      dataType: 'json',
      success: function (response) {
        if (response.status === 'success') {
          const course = response.course;

          $('#course_title').val(course.course_title);
          $('#course_description').val(course.course_description);
          $('#category').val(course.course_category).trigger('change');
          $('#mentor').val(course.mentor_ids ? course.mentor_ids.split(',') : []).trigger('change');
          $('#level').val(course.level).trigger('change');
          $('#no_of_license').val(course.no_of_licenses);
          $('#course_fees').val(course.course_fees);
          $('#language').val(course.language).trigger('change');
          $('#schedule_from').val(course.start_date);
          $('#schedule_to').val(course.end_date);
          $('#testimonial').val(course.testimonials ? course.testimonials.split(',') : []).trigger('change');
          $('#proposed_course').val(course.proposed_courses).trigger('change');

          // Optional: display current image name or thumbnail if needed
          if (course.course_img) {
              const imagePath = `images/course_image/${course.course_img}`;
              $('#course_img').after(`
                <div class="mt-2">
                  <p>Current Image:</p>
                  <img src="${imagePath}" alt="Course Image" style="max-width: 200px; border: 1px solid #ccc; padding: 5px;" />
                </div>
              `);
            }

        } else {
          alert(response.message || 'Failed to load course details');
        }
      },
      error: function () {
        alert('Error fetching course details');
      }
    });
  }    
  
  
  
async function fetchData(draftId) {
    try {
        $('#loader').show();

        const response = await $.ajax({
            url: 'apis/draft_module_api.php',
            method: 'GET',
            data: { draft_id: draftId }, // Pass draft_id here
            dataType: 'json'
        });

        const tableBody = $('#dataGrid tbody');
        tableBody.empty();

        let tableRows = '';

        $.each(response, function(index, item) {
            tableRows += `
                <tr data-module-id="${item.module_id}">
                    <td class="drag-handle" style="cursor: move;"><i class="fa fa-bars"></i></td>
                    <td class="drag-handle">${index + 1}</td>
                    <td>${item.module_name}</td>
                    <td><input type="checkbox"></td>
                </tr>
            `;
        });

        tableBody.html(tableRows);

        tableBody.sortable({
            handle: '.drag-handle',
            placeholder: 'ui-state-highlight',
            update: function (event, ui) {
                const newOrder = tableBody.children().map(function () {
                    return $(this).data('module-id');
                }).get();
                console.log("New Order:", newOrder);
            }
        }).disableSelection();

        $('#loader').hide();

    } catch (error) {
        console.error('Error fetching data:', error);
        $('#loader').hide();
    }
}


    
    fetchData(draftId);
    
});
</script>

 <!--for module-->
<script>
$(document).ready(function () {
  const draftId = $('input[name="draft_id"]').val();

  // Determine if it's a view-only mode.
  // We'll assume if draftId exists, it's view mode for this section.
  const isViewMode = !!draftId;

  // Function to generate HTML for a module row
  // This function is now smarter and can generate rows suitable for view or edit mode.
  function getModuleRowHTML(module, isExisting = false, isView = false) {
    const moduleId = module.module_id || (isExisting ? module.module_name : 'new'); // Use module_id for existing, 'new' for blank
    const moduleName = module.module_name || '';
    const vidTitle = module.vidtitle || ''; // Assuming 'vidtitle' is the property name for study material title
    const fileName = module.actual_file_name || ''; // Assuming 'actual_file_name' is the property name for the file

    // Conditional attributes and styles for view mode
    const inputReadonly = isView ? 'readonly' : '';
    const inputDisabled = isView ? 'disabled' : '';
    const fileInputType = isView ? 'text' : 'file'; // Change file input to text in view mode
    const fileLabelText = isView ? 'File Name' : 'Upload File';
    const fileAccept = isView ? '' : 'accept="video/*,application/pdf,image/*"';
    const fileRequired = isView && !isExisting ? '' : 'required'; // Required only for new editable fields

    // Buttons visibility
    const leftBtnDisplay = isView ? 'display: none;' : '';
    const addContentBtnDisplay = isView ? 'display: none;' : '';

    let html = `
      <div class="content-block row border p-3 mb-3" data-module-id="${moduleId}">
        <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4" style="${leftBtnDisplay}">
          <button type="button" class="btn btn-${isExisting ? 'danger removeModuleBtn' : 'primary leftToggleBtn'} mb-25 mt-25">
            <i class="fas fa-${isExisting ? 'minus' : 'plus'}"></i>
          </button>
        </div>
        <div class="col-md-3">
          <div class="form-group">
            <label>Module Name ${isView ? '' : '<span class="text-danger">*</span>'}</label>
            <input class="form-control module-name" type="text" name="module_name[]" value="${moduleName}" ${inputReadonly} ${inputDisabled} ${fileRequired}>
          </div>
        </div>
        <div class="col-md-3">
          <div class="form-group">
            <label>Study Material Title ${isView ? '' : '<span class="text-danger">*</span>'}</label>
            <input class="form-control vid-title-input" type="text" name="vidtitle[]" placeholder="Study Material Title" value="${vidTitle}" ${inputReadonly} ${inputDisabled} ${fileRequired}>
          </div>
        </div>
        <div class="col-md-4">
          <div class="form-group">
            <label>${fileLabelText} ${isView ? '' : '<span class="text-danger">*</span>'}</label>
            <input class="form-control file-input" type="${fileInputType}" name="study_files[]" value="${fileName}" ${fileAccept} ${inputDisabled} ${fileRequired}>
          </div>
        </div>
        <div class="col-md-1" style="${addContentBtnDisplay}">
          <button type="button" class="btn btn-primary mt-25 btn-circle addMorecontent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
        </div>
      </div>`;
    return html;
  }

  // Function to generate HTML for an extra content row (read-only display)
  function getExtraContentRowHTML(content, module, isView = false) {
    const contentId = content.study_material_id;
    const moduleId = module.module_id || module.module_name; // Ensure module ID is passed
    const removeContentBtnDisplay = isView ? 'display: none;' : '';

    return `
      <div class="row extra-content-row mt-2" data-content-id="${contentId}" data-module-id="${moduleId}">
        <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4" style="${removeContentBtnDisplay}"></div>
        <div class="col-md-3">
          <div class="form-group">
            <input class="form-control" type="text" value="${module.module_name}" readonly disabled>
          </div>
        </div>
        <div class="col-md-3">
          <div class="form-group">
            <input class="form-control" type="text" value="${content.title}" readonly disabled>
          </div>
        </div>
        <div class="col-md-4">
          <div class="form-group">
            <a href="study/${content.actual_file_name}" target="_blank" class="form-control file-link" style="display: block; padding: .375rem .75rem; border: 1px solid #ced4da; border-radius: .25rem; text-decoration: none; color: #495057; background-color: #e9ecef; cursor: pointer;">
                ${content.actual_file_name}
            </a>
          </div>
        </div>
        <div class="col-md-1" style="${removeContentBtnDisplay}">
          <button type="button" class="btn btn-danger mt-25 btn-circle removeContent" style="border-radius: 50%"><i class="fas fa-minus"></i></button>
        </div>
      </div>`;
  }

  // Initial loading logic based on view mode
  if (isViewMode) {
    $.ajax({
      url: 'apis/get_modules_by_draft.php',
      type: 'GET',
      data: { draft_id: draftId },
      dataType: 'json',
      success: function (res) {
        $('#contentWrapper').empty(); // Clear any initial blank rows

        if (res.success && res.modules.length > 0) {
          res.modules.forEach(module => {
            // Append the main module row as read-only
            // $('#contentWrapper').append(getModuleRowHTML(module, true, true)); 
            // isExisting=true, isView=true

            // Append existing study materials as read-only rows
            if (module.contents && module.contents.length > 0) {
              module.contents.forEach(content => {
                $('#contentWrapper').append(getExtraContentRowHTML(content, module, true)); // isView=true
              });
            }
          });
        }
        // In view mode, do NOT add a blank editable row at the end
      },
      error: function () {
        alert('Failed to fetch existing modules.');
        // If fetch fails in view mode, no editable rows are added
      }
    });

    // Hide navigation buttons for this tab in view mode
    $('#goToTab3').hide();
    $('#goToTab1').hide();

  } else { // Not in view mode (i.e., draftId is not present or it's an edit/add mode)
    // Append initial blank module on page load
    $('#contentWrapper').append(getModuleRowHTML({})); // Empty object for a blank row

    // Event handler for left button plus/minus toggle (only in edit mode)
    $(document).on('click', '.leftToggleBtn', function () {
      const $btn = $(this);
      const $moduleBlock = $btn.closest('.content-block');
      const icon = $btn.find('i');

      if (icon.hasClass('fa-plus')) {
        // Add new blank module below
        $('#contentWrapper').append(getModuleRowHTML({}));

        // Change current button to minus
        icon.removeClass('fa-plus').addClass('fa-minus');
        $btn.removeClass('btn-primary').addClass('btn-danger'); // Corrected from btn-success
      } else {
        // Minus clicked, remove this module
        if (confirm('Are you sure you want to delete this blank module?')) {
          $moduleBlock.remove();
        }
      }
    });

    // Remove module row (left side - button) - only in edit mode
    $(document).on('click', '.removeModuleBtn', function () {
      if (!confirm("Are you sure you want to delete this entire module and all its contents?")) return;

      const $moduleBlock = $(this).closest('.content-block');
      const moduleId = $moduleBlock.data('module-id');
      const moduleName = $moduleBlock.find('input.module-name').val();

      // Ajax call to delete module from DB
      $.ajax({
        url: 'apis/delete_draft_module_api.php',
        type: 'POST',
        data: { module_id: moduleId, module_name: moduleName },
        success: function (res) {
          if (res.success) {
            $moduleBlock.remove();
            alert('Module deleted successfully.');
          } else {
            alert('Failed to delete module: ' + (res.message || 'Unknown error'));
          }
        },
        error: function () {
          alert('Error deleting module.');
        }
      });
    });

    // Remove content row (right side - button) - only in edit mode
    $(document).on('click', '.removeContent', function () {
      if (!confirm("Are you sure you want to delete this study material?")) return;

      const $contentRow = $(this).closest('.extra-content-row');
      const contentId = $contentRow.data('content-id');
      const moduleId = $contentRow.data('module-id');

      // Ajax call to delete content from DB
      $.ajax({
        url: 'apis/delete_draft_content_api.php',
        type: 'POST',
        data: { content_id: contentId, module_id: moduleId },
        success: function (res) {
          if (res.success) {
            $contentRow.remove();
            alert('Study material deleted successfully.');
          } else {
            alert('Failed to delete study material: ' + (res.message || 'Unknown error'));
          }
        },
        error: function () {
          alert('Error deleting study material.');
        }
      });
    });

    // Add more content (right side + button for modules) - only in edit mode
    $(document).on('click', '.addMorecontent', function () {
      const $btn = $(this);
      const $block = $btn.closest('.content-block');
      const moduleName = $block.find('input[name="module_name[]"]').val();
      const vidTitle = $block.find('input[name="vidtitle[]"]').val();
      const fileInput = $block.find('input[type="file"]')[0];
      const file = fileInput.files[0];
      const draftId = $('input[name="draft_id"]').val();

      if (!moduleName || !vidTitle || !file) {
        alert("Please fill all required fields.");
        return;
      }

      const formData = new FormData();
      formData.append('module_name', moduleName);
      formData.append('vidtitle', vidTitle);
      formData.append('study_file', file);
      formData.append('draft_id', draftId);

      // Disable inputs during AJAX call
      $block.find('input, select, button').prop('disabled', true);

      $.ajax({
        url: 'apis/add_module_content_api.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (res) {
          // Re-enable inputs
          $block.find('input, select, button').prop('disabled', false);

          if (res.success) {
            alert('Content uploaded successfully.');
            // Replace the current editable row with a read-only display
            const moduleData = {
                module_id: res.module_id, // Assuming API returns module_id
                module_name: moduleName,
            };
            const contentData = {
                study_material_id: res.content_id, // Assuming API returns content_id
                title: vidTitle,
                actual_file_name: file.name
            };
            const readonlyRow = getExtraContentRowHTML(contentData, moduleData, false); // Not in global view mode, but this specific row is now read-only

            // Create a new blank editable content block for the same module
            const newBlankContentRow = $(getModuleRowHTML({ module_name: moduleName }, true, false)); // Module name readonly, not in global view mode
            newBlankContentRow.find('.module-name').prop('readonly', true); // Ensure module name is readonly

            $block.after(readonlyRow);
            $block.replaceWith(newBlankContentRow);
          } else {
            alert('Content upload failed: ' + (res.message || 'Unknown error'));
          }
        },
        error: function (err) {
          // Re-enable inputs
          $block.find('input, select, button').prop('disabled', false);
          console.error("Module content upload failed", err);
          alert("Failed to upload module content. Please try again.");
        }
      });
    });
  } // End of else (not in view mode) block
});
</script>

 <!--for quiz-->
<script>
// --- Utility Functions ---

// Utility function to get query parameters from the URL
function getQueryParam(param) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}

// Function to fetch submodules for a given module ID
// This function still fetches from 'apis/fetch_submodules.php' because you need ALL submodules for a selected module,
// not just those already associated with the draft (unless you specifically want to limit them too).
// Function to fetch submodules for a given module ID and draft ID
function fetchSubmodules(moduleId, submoduleDropdown, selectedSubId = '') {
    // --- THIS IS THE KEY CHANGE ---
    // Get the current draft ID from the URL using your utility function
    const draftId = getQueryParam('draft');

    // Clear and disable dropdown if module or draft ID is missing
    if (!moduleId || !draftId) { // Now correctly checks for draftId too
        submoduleDropdown.empty().append(`<option value="">Select Submodule</option>`);
        submoduleDropdown.prop('disabled', true); // Disable if no module or draft selected/found
        return;
    }
    submoduleDropdown.prop('disabled', false); // Enable if valid IDs are present

    // AJAX call to the new API that fetches draft-specific submodules
    $.ajax({
        // --- THIS IS THE UPDATED URL ---
        url: `apis/fetch_draft_submodules.php?module_id=${moduleId}&draft_id=${draftId}`,
        method: 'GET',
        dataType: 'json',
        success: function (response) {
            submoduleDropdown.empty().append(`<option value="">Select Submodule</option>`);
            let submodules = [];

            // Check API response structure
            if (response && response.success && Array.isArray(response.submodules)) {
                submodules = response.submodules;
            } else {
                console.warn("API returned an unexpected structure or no submodules:", response);
            }

            // Populate the dropdown with fetched submodules
            submodules.forEach(sub => {
                const id = sub.id;   // Using 'id' as aliased in fetch_draft_submodules.php
                const name = sub.name; // Using 'name' as aliased in fetch_draft_submodules.php
                const selected = (id == selectedSubId) ? 'selected' : ''; // Use == for loose comparison
                submoduleDropdown.append(`<option value="${id}" ${selected}>${name}</option>`);
            });
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error("Error fetching draft submodules:", textStatus, errorThrown, jqXHR.responseText);
            submoduleDropdown.empty().append(`<option value="">Error fetching submodules</option>`);
            submoduleDropdown.prop('disabled', true); // Disable on error
        }
    });
}

// --- Main Data Fetching and Rendering ---

async function fetchQuizData() {
    try {
        $('#loader').show(); // Show loader/spinner

        const draftId = getQueryParam('draft');
        if (!draftId) {
            console.error("Error: No 'draft' ID found in the URL. Cannot fetch quiz data or modules.");
            alert("Cannot load quizzes: Draft ID is missing from the URL.");
            $('#loader').hide();
            return;
        }

        // Fetch all quizzes available
        const quizResponse = await fetch('apis/quiz_api.php');
        const quizzes = await quizResponse.json();

        // **CRITICAL CHANGE:** Fetch modules and their linked submodules specific to this draft
        const modulesForDraftResponse = await fetch(`apis/get_modules_and_submodules_by_draft.php?draft_id=${draftId}`);
        if (!modulesForDraftResponse.ok) {
            const errorText = await modulesForDraftResponse.text();
            throw new Error(`HTTP error fetching draft modules! status: ${modulesForDraftResponse.status}, response: ${errorText}`);
        }
        const modulesForDraftData = await modulesForDraftResponse.json();

        let draftModules = [];
        if (modulesForDraftData.success && Array.isArray(modulesForDraftData.modules)) {
            draftModules = modulesForDraftData.modules;
        } else {
            console.warn("No modules found for this draft or API returned an error:", modulesForDraftData.message);
            // Even if no modules are found, we can proceed to show quizzes, but module dropdowns will be empty.
        }

        // Create HTML options string for modules linked to the current draft
        // This array will contain modules that are part of the current draft's structure.
        const moduleOptionsHtml = draftModules.map(mod =>
            `<option value="${mod.module_id}">${mod.module_name}</option>`
        ).join('');

        const tableBody = $('#quizDataGrid tbody');
        tableBody.empty(); // Clear any existing table rows

        // Iterate through each quiz to build and append its row
        quizzes.forEach((quiz, index) => {
            // Determine if the quiz is already assigned to this course draft
            const assignedId = quiz.course_draft_quiz_id || null;
            const btnClass = assignedId ? 'delete-btn btn-danger' : 'assign-btn btn-success';
            const btnText = assignedId ? 'Delete' : 'Assign';

            const row = $(`
                <tr data-quiz-id="${quiz.quiz_id}" ${assignedId ? `data-course-draft-quiz-id="${assignedId}"` : ''}>
                    <td>${index + 1}</td>
                    <td>${quiz.quiz_title}</td>
                    <td>
                        <select class="form-control form-select-sm module-dropdown">
                            <option value="">Select Module</option>
                            ${moduleOptionsHtml} // Use only modules linked to the draft
                        </select>
                    </td>
                    <td>
                        <select class="form-control form-select-sm submodule-dropdown">
                            <option value="">Select Submodule</option>
                        </select>
                    </td>
                    <td>
                        <button class="btn btn-sm ${btnClass}">${btnText}</button>
                    </td>
                </tr>
            `);

            tableBody.append(row);

            // If a module and submodule are already assigned to this quiz entry
            // in the current course draft, pre-select them in the dropdowns.
            const moduleDropdown = row.find('.module-dropdown');
            const submoduleDropdown = row.find('.submodule-dropdown');

            if (quiz.module_id) {
                moduleDropdown.val(quiz.module_id); // Set the selected module
                // Load and pre-select the submodules for the assigned module
                fetchSubmodules(quiz.module_id, submoduleDropdown, quiz.sub_module_id);
            }
        });

    } catch (err) {
        console.error("Error fetching quiz data:", err);
        alert('Failed to load quiz data. Please try again: ' + err.message);
    } finally {
        $('#loader').hide(); // Always hide loader
    }
}

// --- Quiz Assignment/Deletion Logic (No changes needed here) ---

function assignQuiz(row, quizId) {
    const btn = row.find('button.assign-btn');
    btn.prop('disabled', true);

    const courseDraftId = getQueryParam('draft');
    const moduleId = row.find('.module-dropdown').val();
    const submoduleId = row.find('.submodule-dropdown').val();

    if (!moduleId || !submoduleId || !courseDraftId) {
        alert('Please select both a Module and a Submodule to assign the quiz.');
        btn.prop('disabled', false);
        return;
    }

    $.post('apis/add_course_draft_quiz.php', {
        course_draft_id: courseDraftId,
        module_id: moduleId,
        submodule_id: submoduleId,
        quiz_id: quizId
    }, function (response) {
        if (response.success && response.id) {
            row.attr('data-course-draft-quiz-id', response.id);
            row.data('course-draft-quiz-id', response.id);

            btn.text('Delete')
                .removeClass('assign-btn btn-success')
                .addClass('delete-btn btn-danger')
                .prop('disabled', false);

            alert('Quiz assigned successfully!');
        } else {
            alert('Failed to assign quiz: ' + (response.message || 'Unknown error'));
            btn.prop('disabled', false);
        }
    }, 'json').fail(() => {
        alert('Error occurred while assigning quiz.');
        btn.prop('disabled', false);
    });
}

function deleteQuizAssignment(courseDraftQuizId, row) {
    const btn = row.find('button.delete-btn');
    btn.prop('disabled', true);

    if (!confirm('Are you sure you want to remove this quiz assignment from the draft?')) {
        btn.prop('disabled', false);
        return;
    }

    $.post('apis/delete_course_draft_quiz.php', {
        course_draft_quiz_id: courseDraftQuizId
    }, function (response) {
        if (response.success) {
            row.removeAttr('data-course-draft-quiz-id');
            row.removeData('course-draft-quiz-id');

            btn.text('Assign')
                .removeClass('delete-btn btn-danger')
                .addClass('assign-btn btn-success')
                .prop('disabled', false);

            row.find('.module-dropdown').val('');
            row.find('.submodule-dropdown').empty().append(`<option value="">Select Submodule</option>`);

            alert('Quiz assignment deleted!');
        } else {
            alert('Failed to delete quiz assignment: ' + (response.message || 'Unknown error'));
            btn.prop('disabled', false);
        }
    }, 'json').fail(() => {
        alert('Error occurred while deleting quiz assignment.');
        btn.prop('disabled', false);
    });
}

// --- Document Ready / Initialization ---

$(document).ready(function () {
    fetchQuizData(); // Initial load of quiz data and dropdowns

    // Event delegation for assign/delete buttons
    $('#quizDataGrid').on('click', 'button.assign-btn, button.delete-btn', function () {
        const btn = $(this);
        const row = btn.closest('tr');
        const quizId = row.data('quiz-id');

        if (btn.hasClass('assign-btn')) {
            assignQuiz(row, quizId);
        } else if (btn.hasClass('delete-btn')) {
            const courseDraftQuizId = row.data('course-draft-quiz-id');
            if (!courseDraftQuizId) {
                alert('No assignment found to delete.');
                return;
            }
            deleteQuizAssignment(courseDraftQuizId, row);
        }
    });

    // Event delegation for module dropdown change to load submodules
    $('#quizDataGrid').on('change', '.module-dropdown', function () {
        const row = $(this).closest('tr');
        const moduleId = $(this).val();
        const submoduleDropdown = row.find('.submodule-dropdown');
        fetchSubmodules(moduleId, submoduleDropdown);
    });
});
</script>

<!--for submodule-->
<script>
$(document).ready(function () {
    const draftId = $('input[name="draft_id"]').val();
    // Determine if it's a view-only mode.
    const isViewMode = !!draftId;

    // Function to generate a blank submodule row
    function getBlankSubmoduleHTML(module = {}, submodule = {}, isExisting = false, isView = false) {
        const moduleId = module.module_id || '';
        const moduleName = module.module_name || '';
        const submoduleId = submodule.submodule_id || (isExisting ? submodule.submodule_name : 'new');
        const submoduleName = submodule.submodule_name || '';
        const vidTitle = submodule.vidtitle || ''; // For existing content within a submodule
        const fileName = submodule.actual_file_name || ''; // For existing content within a submodule

        // Conditional attributes and styles for view mode
        const inputReadonly = isView ? 'readonly' : '';
        const inputDisabled = isView ? 'disabled' : '';
        const fileInputType = isView ? 'text' : 'file'; // Change file input to text in view mode
        const fileLabelText = isView ? 'File Name' : 'Upload File';
        const fileAccept = isView ? '' : 'accept="video/*,application/pdf,image/*"';
        const fileRequired = isView && !isExisting ? '' : 'required'; // Required only for new editable fields

        // Buttons visibility
        const leftBtnDisplay = isView ? 'display: none;' : '';
        const addContentBtnDisplay = isView ? 'display: none;' : '';

        // Determine if this is a truly new row (not pre-filled from existing data)
        const isTrulyNewRow = !isExisting;
        const leftToggleBtnClass = isTrulyNewRow ? 'primary' : 'danger';
        const leftToggleBtnIcon = isTrulyNewRow ? 'plus' : 'minus';
        const leftToggleBtnHandlerClass = isTrulyNewRow ? 'leftToggleSubmoduleBtn' : 'removeSubmoduleBtn';

        let html = `
            <div class="content-block row border p-3 mb-3" data-submodule-id="${submoduleId}">
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4" style="${leftBtnDisplay}">
                    <button type="button" class="btn btn-${leftToggleBtnClass} mb-25 mt-25 ${leftToggleBtnHandlerClass}">
                        <i class="fas fa-${leftToggleBtnIcon}"></i>
                    </button>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Modules ${isView ? '' : '<span class="text-danger">*</span>'}</label>
                        <select class="form-control select2 module-name-dropdown" name="module_name_id[]" style="width: 100%;" ${inputDisabled} ${fileRequired}>
                            <option value="${moduleId}" ${moduleId ? 'selected' : ''}>${moduleName}</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Submodule Name ${isView ? '' : '<span class="text-danger">*</span>'}</label>
                        <input class="form-control submodule-name-input" type="text" name="submodule_name[]" value="${submoduleName}" ${inputReadonly} ${inputDisabled} ${fileRequired}>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Study Material Title ${isView ? '' : '<span class="text-danger">*</span>'}</label>
                        <input class="form-control" type="text" name="vidtitlesub[]" placeholder="Study Material Title" value="${vidTitle}" ${inputReadonly} ${inputDisabled} ${fileRequired}>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>${fileLabelText} ${isView ? '' : '<span class="text-danger">*</span>'}</label>
                        <input class="form-control" type="${fileInputType}" name="study_files_sub[]" value="${fileName}" ${fileAccept} ${inputDisabled} ${fileRequired}>
                    </div>
                </div>
                <div class="col-md-1" style="${addContentBtnDisplay}">
                    <button type="button" class="btn btn-primary mt-25 btn-circle addMoreSubContent" style="border-radius: 50%"><i class="fas fa-plus"></i></button>
                </div>
            </div>`;
        return html;
    }

    // Function to generate HTML for an extra content row (read-only display)
    function getExtraSubContentRowHTML(content, submodule, module, isView = false) {
        const contentId = content.study_material_id;
        const submoduleId = submodule.submodule_id || submodule.submodule_name;
        const moduleId = module.module_id || module.module_name;
        const removeContentBtnDisplay = isView ? 'display: none;' : '';

        return `
            <div class="row extra-content-row mt-2" data-content-id="${contentId}" data-submodule-id="${submoduleId}">
                <div class="col-md-1 d-flex flex-column align-items-center justify-content-start mt-4" style="${removeContentBtnDisplay}"></div>
                <div class="col-md-2">
                    <div class="form-group">
                        <input class="form-control" type="text" value="${module.module_name}" readonly disabled>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <input class="form-control" type="text" value="${submodule.submodule_name}" readonly disabled>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <input class="form-control" type="text" value="${content.title}" readonly disabled>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <a href="study/${content.actual_file_name}" target="_blank" class="form-control file-link" style="display: block; padding: .375rem .75rem; border: 1px solid #ced4da; border-radius: .25rem; text-decoration: none; color: #495057; background-color: #e9ecef; cursor: pointer;">
                ${content.actual_file_name}
            </a>
                    </div>
                </div>
                <div class="col-md-1" style="${removeContentBtnDisplay}">
                    <button type="button" class="btn btn-danger mt-25 btn-circle removeSubContent" style="border-radius: 50%"><i class="fas fa-minus"></i></button>
                </div>
            </div>`;
    }

    // Load dynamic module options (populate module dropdowns)
    function loadModulesForDropdown($selectElement, selectedId = null) {
        $.ajax({
            url: 'apis/get_modules_by_draft.php',
            type: 'GET',
            data: { draft_id: draftId },
            dataType: 'json',
            success: function (res) {
                if (res.success && Array.isArray(res.modules)) {
                    $selectElement.empty().append(`<option value="">Select Module</option>`);
                    res.modules.forEach(mod => {
                        const isSelected = selectedId == mod.module_id ? 'selected' : '';
                        $selectElement.append(`<option value="${mod.module_id}" ${isSelected}>${mod.module_name}</option>`);
                    });
                }
                // Re-initialize Select2 if it's already bound
                if ($selectElement.data('select2')) {
                    $selectElement.select2();
                } else {
                    $selectElement.select2(); // Initialize Select2 if not already
                }
            },
            error: function () {
                console.warn("Failed to load modules for dropdown.");
            }
        });
    }

    // Initial loading logic for existing submodules or adding a blank row
    if (isViewMode) {
        $.ajax({
            url: 'apis/get_submodules_by_draft.php',
            type: 'GET',
            data: { draft_id: draftId },
            dataType: 'json',
            success: function (res) {
                $('#contentWrapperSubModule').empty(); // Clear any initial blank rows

                if (res.success && Array.isArray(res.submodules)) {
                    res.submodules.forEach(submodule => {
                        const submoduleId = submodule.submodule_id;
                        const moduleId = submodule.module_id; // Assuming module_id is returned with submodule

                        // Append the main submodule row as read-only
                        // $('#contentWrapperSubModule').append(getBlankSubmoduleHTML({module_id: moduleId, module_name: submodule.module_name}, submodule, true, true));

                        // Populate the module dropdown for this row and set its value
                        loadModulesForDropdown($('#contentWrapperSubModule .content-block[data-submodule-id="' + submoduleId + '"] .module-name-dropdown'), moduleId);

                        // Append existing study materials as read-only rows below the main submodule block
                        if (submodule.contents && submodule.contents.length > 0) {
                            submodule.contents.forEach(content => {
                                $('#contentWrapperSubModule').append(getExtraSubContentRowHTML(content, submodule, {module_id: moduleId, module_name: submodule.module_name}, true)); // isView=true
                            });
                        }
                    });
                }
                // In view mode, do NOT add a blank editable row at the end
            },
            error: function () {
                alert('Failed to fetch existing submodules.');
                // If fetch fails in view mode, no editable rows are added
            }
        });

        // Hide navigation buttons for this tab in view mode
        // Assuming there are navigation buttons specific to this tab
        // For example, if there were #goToTab4 and #goToTab2 in submodule section
        // $('#goToTab4').hide();
        // $('#goToTab2').hide();

    } else { // Not in view mode (i.e., draftId is not present or it's an edit/add mode)
        // Append initial blank submodule on page load
        $('#contentWrapperSubModule').append(getBlankSubmoduleHTML());
        loadModulesForDropdown($('#contentWrapperSubModule .module-name-dropdown').last());

        // Event handler for left button plus/minus toggle (for submodules)
        $(document).on('click', '.leftToggleSubmoduleBtn', function () {
            const $btn = $(this);
            const $submoduleBlock = $btn.closest('.content-block');
            const icon = $btn.find('i');

            if (icon.hasClass('fa-plus')) {
                // Add new blank submodule below
                const $newRow = $(getBlankSubmoduleHTML());
                $('#contentWrapperSubModule').append($newRow);
                loadModulesForDropdown($newRow.find('.module-name-dropdown'));

                // Change current button to minus
                icon.removeClass('fa-plus').addClass('fa-minus');
                $btn.removeClass('btn-primary').addClass('btn-danger');
            } else {
                // Minus clicked, remove this submodule block
                if (confirm('Are you sure you want to delete this blank submodule row?')) {
                    $submoduleBlock.remove();
                }
            }
        });

        // Remove submodule row (left side - button) - only in edit mode
        $(document).on('click', '.removeSubmoduleBtn', function () {
            if (!confirm("Are you sure you want to delete this entire submodule and all its contents?")) return;

            const $submoduleBlock = $(this).closest('.content-block');
            const submoduleId = $submoduleBlock.data('submodule-id');
            const submoduleName = $submoduleBlock.find('input.submodule-name-input').val(); // Get submodule name

            // AJAX call to delete submodule from DB
            $.ajax({
                url: 'apis/delete_draft_submodule_api.php', // Create this API endpoint
                type: 'POST',
                data: { submodule_id: submoduleId, submodule_name: submoduleName, draft_id: draftId },
                success: function (res) {
                    if (res.success) {
                        // Remove all content rows related to this submodule as well
                        $(`div.extra-content-row[data-submodule-id="${submoduleId}"]`).remove();
                        $submoduleBlock.remove();
                        alert('Submodule deleted successfully.');
                    } else {
                        alert('Failed to delete submodule: ' + (res.message || 'Unknown error'));
                    }
                },
                error: function () {
                    alert('Error deleting submodule.');
                }
            });
        });

        // Remove content row (right side - button for submodules) - only in edit mode
        $(document).on('click', '.removeSubContent', function () {
            if (!confirm("Are you sure you want to delete this study material from the submodule?")) return;

            const $contentRow = $(this).closest('.extra-content-row');
            const contentId = $contentRow.data('content-id');
            const submoduleId = $contentRow.data('submodule-id');

            // AJAX call to delete submodule content from DB
            $.ajax({
                url: 'apis/delete_draft_submodule_content_api.php', // Create this API endpoint
                type: 'POST',
                data: { content_id: contentId, submodule_id: submoduleId },
                success: function (res) {
                    if (res.success) {
                        $contentRow.remove();
                        alert('Submodule study material deleted successfully.');
                    } else {
                        alert('Failed to delete study material: ' + (res.message || 'Unknown error'));
                    }
                },
                error: function () {
                    alert('Error deleting study material.');
                }
            });
        });


        // Add more study material (right side + button for submodules) - only in edit mode
        $(document).on('click', '.addMoreSubContent', function () {
            const $btn = $(this);
            const $contentBlock = $btn.closest('.content-block');
            const moduleId = $contentBlock.find('select[name="module_name_id[]"]').val();
            const moduleNameText = $contentBlock.find('select[name="module_name_id[]"] option:selected').text();
            const submoduleName = $contentBlock.find('input[name="submodule_name[]"]').val();
            const vidTitle = $contentBlock.find('input[name="vidtitlesub[]"]').val();
            const fileInput = $contentBlock.find('input[name="study_files_sub[]"]')[0];
            const file = fileInput?.files[0];
            const draftId = $('input[name="draft_id"]').val();

            if (!moduleId || !submoduleName || !vidTitle || !file) {
                alert("Please select a module, fill in submodule name, title, and select a file before adding.");
                return;
            }

            const formData = new FormData();
            formData.append('module_id', moduleId); // Use module_id for backend
            formData.append('submodule_name', submoduleName);
            formData.append('vidtitlesub', vidTitle);
            formData.append('study_files_sub', file);
            formData.append('draft_id', draftId);

            // Disable inputs during AJAX call
            $contentBlock.find('input, select, button').prop('disabled', true);

            $.ajax({
                url: 'apis/add_submodule_content_api.php', // API to save submodule content
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (res) {
                    // Re-enable inputs
                    $contentBlock.find('input, select, button').prop('disabled', false);

                    if (res.success) {
                        alert('Submodule content uploaded successfully.');

                        // Replace the current editable row with a read-only display
                        const contentId = res.content_id; // Assuming API returns the ID of the new content
                        const submoduleId = res.submodule_id; // Assuming API returns the ID of the submodule

                        const readonlyRow = getExtraSubContentRowHTML({study_material_id: contentId, title: vidTitle, actual_file_name: file.name}, {submodule_id: submoduleId, submodule_name: submoduleName}, {module_id: moduleId, module_name: moduleNameText}, false); // Not in global view mode, but this specific row is now read-only

                        // Append the read-only row
                        $contentBlock.after(readonlyRow);

                        // Create a new blank editable content block for the same submodule
                        const newBlankContentRow = $(getBlankSubmoduleHTML({module_id: moduleId, module_name: moduleNameText}, {submodule_name: submoduleName}, true, false)); // Module and Submodule name readonly, not in global view mode
                        newBlankContentRow.find('.module-name-dropdown').prop('disabled', true); // Ensure module dropdown is disabled
                        newBlankContentRow.find('.submodule-name-input').prop('readonly', true); // Ensure submodule name is readonly

                        $contentBlock.replaceWith(newBlankContentRow); // Replace the old block with the new blank one
                        loadModulesForDropdown(newBlankContentRow.find('.module-name-dropdown'), moduleId); // Load options for the new dropdown and pre-select

                    } else {
                        alert('Submodule content upload failed: ' + (res.message || 'Unknown error'));
                    }
                },
                error: function (err) {
                    // Re-enable inputs
                    $contentBlock.find('input, select, button').prop('disabled', false);
                    console.error("Submodule content upload failed", err);
                    alert("Failed to upload submodule content. Please try again.");
                }
            });
        });
    } // End of else (not in view mode) block
});
</script>













</body>
</html>
