
<?php 
$page_name = 'View Mentor';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        VIEW MENTOR
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="mentor_master.php">Mentor</a></li>
        <li class="active">View Mentor</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="mentorForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Mentor Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="mentor_name" name="mentor_name" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Phone No.<span class="text-danger">*</span></label>
                                <input class="form-control" type="tel" pattern="\d{10}" maxlength="10" minlength="10" autocomplete="off"  id="phone_no" name="phone_no" title="Please enter exactly 10 digits (numbers only)" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email ID<span class="text-danger">*</span></label>
                                <input class="form-control" type="email" autocomplete="off" id="email_id" name="email_id" pattern=".+\..{2,4}$" 
                              title="Please enter a valid email address" readonly>
                            </div>
                        </div>  
                        

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Password<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="password" name="password" readonly>
                            </div>
                        </div>  
                        
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Specialization<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="specialization" name="specialization" readonly>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>LinkedIn Profile</label>
                                <input class="form-control" type="url" autocomplete="off" id="linkedin_profile" name="linkedin_profile" readonly>
                            </div>
                        </div>                         
                        
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Mentor Image (Optional)</label>
                                <input class="form-control" type="file" autocomplete="off" id="mentor_img" name="mentor_img" accept="image/png, image/gif, image/jpeg" disabled>
                            <div id="currentMentorImage" style="margin-top:10px;">
                            <img id="mentorImagePreview" src="" alt="Mentor Image" style="max-height: 100px; border: 1px solid rgb(221, 221, 221); padding: 5px;">
                            </div>                            
                            </div>
                        </div>
                        

                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>CV (Optional)</label>
                                <input class="form-control" type="file" autocomplete="off" id="mentor_cv" name="mentor_cv" accept=".pdf" disabled>
                                
                                <!-- Show CV link if already uploaded -->
                                <a id="mentorCVLink" href="#" target="_blank" style="display: none;">View Uploaded CV</a>
                            </div>
                        </div>

                       
                        
                        <div class="col-md-4">
                <div class="form-group">
                  <div class="radio">
                  	  <input name="block_mentor" value="0" type="radio" id="Option_2" class="with-gap radio-col-red" disabled>
					  <label for="Option_2">Active</label>                    
                  </div>
                  <div class="radio">
                  	  <input name="block_mentor" value="1" type="radio" id="Option_1" class="with-gap radio-col-red" disabled>
					  <label for="Option_1">Inactive</label>   
                  </div>
                </div>
                        </div>    
                        

                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                  	  <input type="checkbox" id="industry_expert" value="1" disabled>
					  <label for="industry_expert">Industry Expert</label>
					  </div>
                            </div>
                        </div> 
                        

                    </div>
                    
                
                    <div class="box-footer">
                        <a href="mentor_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>

const urlParams = new URLSearchParams(window.location.search);
const mentorId = urlParams.get('id');

if (mentorId) {
    prepopulateMentorForm(mentorId);  
}

</script>

</body>
</html>