<?php 
$page_name = 'Edit Testimonial';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">
            EDIT TESTIMONIAL
        </span>
        <ol class="breadcrumb">
            <li><a href="masters.php">Masters</a></li>
            <li><a href="testimonial_master.php">Testimonials</a></li>
            <li class="active">Edit Testimonial</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <p class="box-title">* All fields marked with an asterisk are required</p>
                <div class="col-md-4 response-msg" id="responseMessage"></div>  
            </div>

            <form id="testimonialForm">
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Testimonial Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="testimonial_name" name="testimonial_name" readonly>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Learner Since <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="learner_since" name="learner_since" min="1900" max="2099" step="1" readonly placeholder="Enter Year (e.g. 2020)">
                        </div>

                    </div>
                </div>

                <div class="row">  
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Testimonial Text <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="testimonial_text" name="testimonial_text" rows="3" readonly></textarea>
                        </div>
                    </div>
                </div>

                <div class="row">  
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Is Block <span class="text-danger">*</span></label>
                            <div class="radio">
                                <input name="is_block" value="1" type="radio" id="block_yes" class="with-gap radio-col-red" disabled>
                                <label for="block_yes">Yes (Block)</label>                    
                            </div>
                            <div class="radio">
                                <input name="is_block" value="0" type="radio" id="block_no" class="with-gap radio-col-red" checked disabled>
                                <label for="block_no">No (Unblock)</label>   
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box-footer">
                    <a href="testimonial_master.php" class="btn btn-secondary">Back</a>
                </div>
            </div>
        </form>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>

const urlParams = new URLSearchParams(window.location.search);
const testimonialId = urlParams.get('id');

if (testimonialId) {
    prepopulateTestimonialForm(testimonialId);  
}
</script>

</body>
</html>
