<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['assignment_id'])) {
    echo json_encode(["status" => "error", "message" => "Assignment ID is required"]);
    exit();
}

$assignmentId = intval($_GET['assignment_id']);
$institute_id = $_SESSION['institute_id'] ?? null;

try {
    // Get folder name for current institute
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }

    // Get folder name for superadmin (institute_id = 1)
    $stmtSuperFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = 1");
    $stmtSuperFolder->execute();
    $superadminFolder = $stmtSuperFolder->fetchColumn();    
    
    $superadminCheckSql = "
        SELECT cm.is_superadmin_course 
        FROM course_assignment ca
        JOIN course_master cm ON ca.course_id = cm.course_id
        WHERE ca.assignment_id = :assignment_id
        LIMIT 1
    ";
    $stmtCheck = $pdo->prepare($superadminCheckSql);
    $stmtCheck->execute([':assignment_id' => $assignmentId]);
    $isSuperadminCourse = $stmtCheck->fetchColumn() ?: 0;    
    
    // Decide folder
    $folderToUse = ($isSuperadminCourse == 1) ? $superadminFolder : $currentFolder;

    // Fetch assignment details
    $sql = "SELECT * FROM assignment_master WHERE assignment_id = :assignment_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':assignment_id', $assignmentId, PDO::PARAM_INT);
    $stmt->execute();
    $assignment = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($assignment) {
        $questionIds = array_filter(array_map('trim', explode(',', $assignment['question_ids'])));

        if (!empty($questionIds)) {
            $placeholders = rtrim(str_repeat('?,', count($questionIds)), ',');
            $qSql = "SELECT * FROM question_master WHERE question_master_id IN ($placeholders)";
            $qStmt = $pdo->prepare($qSql);
            $qStmt->execute($questionIds);
            $questions = $qStmt->fetchAll(PDO::FETCH_ASSOC);

            $formattedQuestions = array_map(function ($q) use ($folderToUse) {
                $options = [
                    'option_1' => $q['option_1'],
                    'option_2' => $q['option_2'],
                    'option_3' => $q['option_3'],
                    'option_4' => $q['option_4'],
                ];

                $type = strtolower(trim($q['type']));
                $correctAnswerValues = [];

                if ($type === 'yes_no' || $type === 'true_false') {
                    $val = strtolower(trim($q['correct_answer']));
                    if (!empty($val)) {
                        $correctAnswerValues[] = ucfirst($val);
                    }
                } else {
                    $correctAnswerKeys = array_map('trim', explode(',', $q['correct_answer']));
                    foreach ($correctAnswerKeys as $key) {
                        $keyFormatted = strtolower(str_replace(' ', '_', $key));
                        if (isset($options[$keyFormatted])) {
                            $correctAnswerValues[] = $options[$keyFormatted];
                        }
                    }
                    if ($type === 'one right answer' && count($correctAnswerValues) === 1) {
                        $correctAnswerValues = $correctAnswerValues[0];
                    }
                }

                $imageUrl = !empty($q["image_url"]) 
                    ? "./Z1mn7_adm/institutes/{$folderToUse}/question_images/" . $q["image_url"]
                    : null;

                return [
                    "question_id"     => $q["question_master_id"],
                    "type"            => $q["type"],
                    "question"        => $q["question"],
                    "media"           => [
                        "image"      => $imageUrl,
                        "video"      => $q["video_url"],
                        "video_type" => $q["video_type"]
                    ],
                    "options"         => array_values(array_filter($options)),
                    "correct_answer"  => $correctAnswerValues,
                    "hint"            => $q["hint"],
                    "marks"           => $q["marks"],
                    "duration"        => $q["duration"]
                ];
            }, $questions);

            echo json_encode([
                "status"           => "success",
                "assignment_title" => $assignment['assignment_title'],
                "total_marks"      => $assignment['total_marks'],
                "questions"        => $formattedQuestions
            ]);
        } else {
            echo json_encode(["status" => "error", "message" => "No questions linked to this assignment."]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "assignment not found."]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>
