<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

if (!isset($_GET['quiz_id'])) {
    echo json_encode(["status" => "error", "message" => "Quiz ID is required"]);
    exit();
}

$quizId = intval($_GET['quiz_id']);
$institute_id = $_SESSION['institute_id'] ?? null;

try {
    // Get folder name for current institute
    $stmtFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = :institute_id");
    $stmtFolder->execute([':institute_id' => $institute_id]);
    $currentFolder = $stmtFolder->fetchColumn();

    if (!$currentFolder) {
        echo json_encode(["status" => "error", "message" => "Institute folder not found."]);
        exit;
    }

    // Get folder name for superadmin (institute_id = 1)
    $stmtSuperFolder = $pdo->prepare("SELECT folder_name FROM institute_master WHERE institute_id = 1");
    $stmtSuperFolder->execute();
    $superadminFolder = $stmtSuperFolder->fetchColumn();    

    // Check if quiz belongs to a superadmin course
    $superadminCheckSql = "
        SELECT cm.is_superadmin_course 
        FROM course_quiz cq
        JOIN course_master cm ON cq.course_id = cm.course_id
        WHERE cq.quiz_id = :quiz_id
        LIMIT 1
    ";
    $stmtCheck = $pdo->prepare($superadminCheckSql);
    $stmtCheck->execute([':quiz_id' => $quizId]);
    $isSuperadminCourse = $stmtCheck->fetchColumn() ?: 0;    

    // Decide folder
    $folderToUse = ($isSuperadminCourse == 1) ? $superadminFolder : $currentFolder;

    // Fetch quiz details
    $sql = "SELECT * FROM quiz_master WHERE quiz_id = :quiz_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':quiz_id', $quizId, PDO::PARAM_INT);
    $stmt->execute();
    $quiz = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($quiz) {
        $questionIds = array_filter(array_map('trim', explode(',', $quiz['question_ids'])));

        if (!empty($questionIds)) {
            $placeholders = rtrim(str_repeat('?,', count($questionIds)), ',');
            $qSql = "SELECT * FROM question_master WHERE question_master_id IN ($placeholders)";
            $qStmt = $pdo->prepare($qSql);
            $qStmt->execute($questionIds);
            $questions = $qStmt->fetchAll(PDO::FETCH_ASSOC);

            $formattedQuestions = array_map(function ($q) use ($folderToUse) {
                $options = [
                    'option_1' => $q['option_1'],
                    'option_2' => $q['option_2'],
                    'option_3' => $q['option_3'],
                    'option_4' => $q['option_4'],
                ];

                $type = strtolower(trim($q['type']));
                $correctAnswerValues = [];

                if ($type === 'yes_no' || $type === 'true_false') {
                    $val = strtolower(trim($q['correct_answer']));
                    if (!empty($val)) {
                        $correctAnswerValues[] = ucfirst($val); // "yes" → "Yes"
                    }
                } else {
                    $correctAnswerKeys = array_map('trim', explode(',', $q['correct_answer']));
                    foreach ($correctAnswerKeys as $key) {
                        $keyFormatted = strtolower(str_replace(' ', '_', $key));
                        if (isset($options[$keyFormatted])) {
                            $correctAnswerValues[] = $options[$keyFormatted];
                        }
                    }
                    if ($type === 'one right answer' && count($correctAnswerValues) === 1) {
                        $correctAnswerValues = $correctAnswerValues[0];
                    }
                }

                $imageUrl = !empty($q["image_url"]) 
                    ? "./Z1mn7_adm/institutes/{$folderToUse}/question_images/" . $q["image_url"]
                    : null;                

                return [
                    "question_id"     => $q["question_master_id"],
                    "type"            => $q["type"],
                    "question"        => $q["question"],
                    "media"           => [
                        "image"      => $imageUrl,
                        "video"      => $q["video_url"],
                        "video_type" => $q["video_type"]
                    ],
                    "options"         => array_values(array_filter($options)),
                    "correct_answer"  => $correctAnswerValues,
                    "hint"            => $q["hint"],
                    "marks"           => $q["marks"]
                ];
            }, $questions);

            echo json_encode([
                "status"       => "success",
                "quiz_title"   => $quiz['quiz_title'],
                "total_marks"  => $quiz['total_marks'],
                "questions"    => $formattedQuestions
            ]);
        } else {
            echo json_encode(["status" => "error", "message" => "No questions linked to this quiz."]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Quiz not found."]);
    }
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => "Database Error: " . $e->getMessage()]);
}
?>
