<?php
require_once('../includes/connection.php');
header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents("php://input"), true);
    if (!$input) {
        throw new Exception("Invalid JSON input");
    }

    $quiz_id      = intval($input['quiz_id'] ?? 0);
    $user_id      = $_SESSION['user_id'];
    $course_id    = intval($input['course_id'] ?? 0);
    $institute_id = $_SESSION['institute_id'];
    $questions    = $input['questions'] ?? [];

    if (!$quiz_id || !$course_id) {
        throw new Exception("Missing required fields");
    }

    // insert into quiz_attempts
    $stmt = $pdo->prepare("
        INSERT INTO quiz_attempts (quiz_id, user_id, course_id, institute_id) 
        VALUES (:quiz_id, :user_id, :course_id, :institute_id)
    ");
    $stmt->execute([
        ':quiz_id'      => $quiz_id,
        ':user_id'      => $user_id,
        ':course_id'    => $course_id,
        ':institute_id' => $institute_id
    ]);
    $attempt_id = $pdo->lastInsertId();

    $correct_count = 0;
    $total_count   = count($questions);

    $stmtDetail = $pdo->prepare("
        INSERT INTO quiz_attempts_data (quiz_attempt_id, question_id, correct_answer, selected_answer, quiz_id, user_id, course_id) 
        VALUES (:attempt_id, :question_id, :correct_answer, :selected_answer, :quiz_id, :user_id, :course_id)
    ");

    foreach ($questions as $q) {
        $question_id     = intval($q['question_id']);
        $correct_answer  = trim($q['correct_answer'] ?? "");
        $selected_answer = trim($q['selected_answer'] ?? "");

        // save attempt detail
        $stmtDetail->execute([
            ':attempt_id'     => $attempt_id,
            ':question_id'    => $question_id,
            ':correct_answer' => $correct_answer,
            ':selected_answer'=> $selected_answer,
            ':quiz_id'      => $quiz_id,
            ':user_id'      => $user_id,
            ':course_id'    => $course_id,            
        ]);

        // check correctness (multi-answer safe)
        $corrArr = array_map("trim", explode(",", strtolower($correct_answer)));
        $selArr  = array_map("trim", explode(",", strtolower($selected_answer)));
        sort($corrArr);
        sort($selArr);

        if ($corrArr === $selArr) {
            $correct_count++;
        }
    }

    echo json_encode([
        "status" => "success",
        "message" => "Quiz attempt saved successfully",
        "attempt_id" => $attempt_id,
        "score" => $correct_count,
        "total_questions" => $total_count
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}