<?php 
$page_name = 'Assignment';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>

.skin-blue .main-header .navbar {
    background-color: #fff;
}

.login-profile {
    height: 90px;
}

.content-wrapper, .main-footer {
  margin-left: unset !important;
}

.main-header .navbar {
  margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
  border-bottom: 1px solid #5C2C8B;
}

.progress-bar {
  background-color: #5C2C8B;
}

.module-list {
  list-style: none;
  padding: 0;
  margin-top: 15px;
}

.module-list li {
  padding: 5px 15px;
  border-radius: 5px;
  margin-bottom: 15px;
  background-color: #fff;
  cursor: pointer;
  border: 1px solid #ddd;
  transition: all 0.3s ease;
  color: #333;
}

.module-list li:hover {
  background-color: #f2e8fc;
  color: #5C2C8B;
}

.module-list li.active {
  background-color: #E9DFF8;
  color: #5C2C8B;
  font-weight: 600;
  border-left: 5px solid #5C2C8B;
}

.btn-dark {
  background-color: #5C2C8B;
  border-color: #5C2C8B;
}

.course-box {
  padding: 30px 0px;
}



#moduleTitle {
  color: #5C2C8B;
  font-size: 22px;
  font-weight: bold;
}

iframe {
  border-radius: 8px;
}

.assignment-box {
  padding: 30px;
  background-color: #f3ecff;
  border: 2px dashed #5C2C8B;
  border-radius: 10px;
  text-align: center;
  font-size: 18px;
  color: #5C2C8B;
  font-weight: bold;
}

@media (max-width: 767px) {
  .col-md-4, .col-md-8 {
    padding: 10px;
  }
}

.video-container {
  position: relative;
  padding-bottom: 56.25%; /* 16:9 ratio */
  height: 0;
  overflow: hidden;
  margin-bottom: 20px;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.video-container iframe {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border: none;
}


.timeline-toggle {
  margin-bottom: 20px;
  border-radius: 50px !important;
}

.timeline-wrapper {
      border-left: 2px dashed #6A1B9A;
  padding-left: 20px;
  margin-left: 15px;
  max-width: 300px;
}

.timeline-item {
  display: flex;
  align-items: flex-start;
}


.timeline-icon {
  font-size: 20px;
  margin-right: 10px;
  color: #6a1b9a;
}

.timeline-content h4 {
  margin: 0;
  color: #6a1b9a;
  font-size: 16px;
}

.timeline-content p {
  margin: 3px 0 0;
  font-size: 14px;
}

.assignment p {
  font-weight: bold;
}

.assignment.completed p {
  color: #4caf50;
}

.assignment.due-soon p {
  color: #ff5722;
}

.assignment.upcoming p {
  color: #ff9800;
}


.progress {
    height: 5px;
}

.btn-right {
    float: right;
}


.timeline-container {
  display: flex;
  flex-direction: column;
  max-width: 250px;
}



.icon-wrapper {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-right: 10px;
  position: relative;
  width: 24px;
}

.icon {
  width: 20px;
  height: 20px;
  z-index: 2;
}

.line {
  width: 2px;
  height: 50px;
  border-left: 2px dashed #a259cf;
  margin-top: 2px;
  z-index: 1;
}

.content .label {
  font-weight: bold;
  color: #6a1b9a;
  font-size: 16px;
  padding: unset;
}

.content .date {
  font-size: 14px;
  color: #6a1b9a;
}

.content {
    background: #F7F5F9 !important;
        padding: 0px 20px !important;
}

.course-title
{
        color: #5B2E8E;
    line-height: 30px;
    font-size: 20px;
}

@media (min-width: 768px) {
    .navbar-nav > li > a {
        padding-top: 30px;
    }
}



.assignment-option {
  margin-bottom: 10px;
  border-radius: 8px;
  overflow: hidden;
}

.option-label {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 7px 20px;
  border: 1px solid #e0e0e0;
  border-radius: 8px;
  cursor: pointer;
  transition: all 0.3s ease;
  position: relative;
  background: #fff;
}

.option-label:hover {
  box-shadow: 0 0 10px rgba(92, 44, 139, 0.1);
}

.option-text {
  font-weight: 500;
  font-size: 14px;
  color: #333;
}

/* Hide both radio and checkbox inputs */
.option-label input[type="radio"],
.option-label input[type="checkbox"] {
  display: none;
}

/* Base styles */
.custom-radio,
.custom-checkbox {
  width: 15px;
  height: 15px;
  border: 2px solid #ccc;
  position: relative;
  transition: all 0.3s ease;
}

/* Radio style (circle) */
.custom-radio {
  border-radius: 50%;
}

.custom-radio::after {
  content: "";
  position: absolute;
    top: 2px;
    left: 2px;
    width: 7px;
    height: 7px;
  background: #5C2C8B;
  border-radius: 50%;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.option-label input[type="radio"]:checked + .custom-radio {
  border-color: #5C2C8B;
}

.option-label input[type="radio"]:checked + .custom-radio::after {
  opacity: 1;
}

/* Checkbox style (square with tick) */
.custom-checkbox {
  border-radius: 4px;
}

.custom-checkbox::after {
  content: "✔";
  position: absolute;
top: -3px;
    left: 1px;
    font-size: 12px;
  color: #5C2C8B;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.option-label input[type="checkbox"]:checked + .custom-checkbox {
  border-color: #5C2C8B;
}

.option-label input[type="checkbox"]:checked + .custom-checkbox::after {
  opacity: 1;
}

.review-answer-box {
    border: 1px solid #ccc;
    border-left: 4px solid #7B48AB;
    padding: 5px 16px;
    /* border-radius: 8px; */
    margin-bottom: 10px;
    background-color: #fff;
    /* color: #333; */
    position: relative;
    font-weight: 400;
    font-size: 14px;
}

.question-box
{
    margin-top:40px;
}

.review-answer-box.correct {
  //border-color: #28a745;
  //background-color: #eaf9ef;
  color: #42BB0F;
}

.review-answer-box.incorrect {
  //border-color: #dc3545;
  //background-color: #fdecea;
  color: #EF3D24;
}

.review-answer-label {
  font-size: 12px;
  position: absolute;
  right: 12px;
  top: 7px;
  font-weight: 500;
}

strong {
        font-weight: 600 !important;
    color: #5C2C8B;
}

@media (min-width: 1200px) {
    .container {
        width: 1280px;
    }
}

.option-label.correct .option-text {
  color: #42BB0F;
}

.option-label.incorrect .option-text {
  color: #EF3D24;
}


.assignment-box-outter
{
    border: 1px solid #707070;
    border-radius: 23px;
    opacity: 1;
    padding: 0px 20px 15px 20px;
}

.btn-right-mrg
{
    margin-right: 0px;
}

.btn-right
{
    float:right;
}

.thankyou-title
{
    color: #fff;
    background: #5D2B8B;
    padding: 10px;
    font-size: 15px;
    border-radius: 5px;
}

.content-header {
    padding: 20px 45px !important;
}

.hint-text
{
    color: #EF3D24;
    font-weight: 600;    
}
</style>

<div class="content-wrapper">
    <div class="row">

    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg-table" id="responseMessage"></div>
        <div class="box-body">


<div class="content-wrapper">
    
    
<section class="content-header d-flex justify-content-between align-items-center px-3 py-2" style="display: flex; justify-content: space-between; align-items: center;">
  <!-- Left: assignment Title -->
  <span id="assignment-title" style="font-size: 18px;">

  </span>

  <!-- Right: Progress Bar -->
  <div style="text-align: right; min-width: 170px;">
    <div id="progress-text" class="small font-weight-bold mb-1" style="text-align: left;">
    </div>
    <div class="progress" style="height: 6px;">
      <div id="progress-bar" class="progress-bar" role="progressbar"
           style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
      </div>
    </div>
  </div>
</section>


    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg-table" id="responseMessage"></div>
        <div class="box-body">



<div class="container assignment-box-outter">
  <form id="assignmentAttemptForm">
    <div class="questions"></div>
  </form>
</div>

        </div>
      </div>
    </div>
</div>

        </div>
      </div>
    </div>
    </div>
</div>


<!-- Certificate Modal -->
<div class="modal modal-success fade" id="modal-certificate">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" style="float: left;">EPIC LMS Certificate</h4>
        <button type="button" class="close" data-dismiss="modal" style="color: #fff;">&times;</button>
      </div>
      <div class="modal-body" id="certificateModalBody" style="background-color: #fff;">
        <!-- Spinner loader -->
        <div id="cert-loader" class="text-center">
          <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
          </div>
          <p></p>
        </div>
      </div>
    </div>
  </div>
</div>





<?php require_once('includes/footer.php'); ?>

<script>
const answers = {};
  const params = new URLSearchParams(window.location.search);
  const assignmentId = params.get('assignment_id');
  let attempt = parseInt(params.get('attempt') || "1", 10);
  const courseId = params.get('course');

$(document).ready(function() {
    
  async function checkassignmentAttempt(assignmentId, attemptNo) {
    try {
      const attemptRes = await fetch(`apis/get_assignment_attempt_api.php?assignment_id=${assignmentId}&attempt=${attemptNo}&course_id=${courseId}`);
      const attemptData = await attemptRes.json();

      if (attemptData.status === "attempted") {
        showResult(attemptData);
      } else {
        const assignmentRes = await fetch(`apis/get_single_assignment_api.php?assignment_id=${assignmentId}`);
        const assignmentData = await assignmentRes.json();

        if (assignmentData.status === "success" && assignmentData.questions?.length) {
          window.assignmentData = assignmentData;
          renderassignmentHeader(assignmentData);
          renderassignmentQuestions(assignmentData);
        } else {
          document.querySelector(".questions").innerHTML = "<p>No assignment data found.</p>";
        }
      }
    } catch (error) {
      console.error("Error fetching assignment:", error);
      document.querySelector(".questions").innerHTML =
        "<p style='color:red;'>Something went wrong. Please try again.</p>";
    }
  }

  if (!assignmentId) {
    document.querySelector('.questions').innerHTML = '<p>Invalid assignment ID.</p>';
    return;
  }

  // 🔹 First load attempt from URL
  checkassignmentAttempt(assignmentId, attempt);

  // ✅ Re-Attempt button handler
  window.reAttemptAssignment = async function() {
    attempt++; // increase attempt
    const url = new URL(window.location.href);
    url.searchParams.set('attempt', attempt);
    window.history.pushState({}, '', url); // update URL without reload

    // Now check if that attempt exists
    checkassignmentAttempt(assignmentId, attempt);
  };

  // ✅ Re-Attempt button
  window.reAttemptAssignment = async function() {
    attempt++; // increase attempt
    const url = new URL(window.location.href);
    url.searchParams.set('attempt', attempt);
    window.history.pushState({}, '', url); // update URL without reload

    // Now check if that attempt exists
    checkassignmentAttempt(assignmentId, attempt);
  };



function renderassignmentHeader(assignment) {
  document.getElementById('assignment-title').innerText = assignment.assignment_title;
}

function extractVimeoId(url) {
  const match = url.match(/vimeo\.com\/(\d+)/);
  return match ? match[1] : '';
}

function renderassignmentQuestions(assignment) {
  const questions = assignment.questions;
  let currentPage = 0;

function renderPage(pageIdx) {
  const q = questions[pageIdx];
  let opts = Array.isArray(q.options) ? q.options.filter(o => o) : [];

  // ✅ Clear old timers if any
  if (window.autoNextTimer) clearTimeout(window.autoNextTimer);
  if (window.countdownInterval) clearInterval(window.countdownInterval);

  if (opts.length === 0) {
    if (q.type === 'yes_no') opts = ['Yes', 'No'];
    else if (q.type === 'true_false') opts = ['True', 'False'];
  }

  let mediaHTML = '';
  if (q.media?.image) {
    mediaHTML += `<center><img src="${q.media.image}" style="max-width:300px;" class="img-fluid mb-2"></center>`;
  }

  if (q.media?.video) {
    const videoUrl = q.media.video;
    const videoType = (q.media.video_type || '').toLowerCase();

    if (videoType === 'vimeo') {
      const vimeoId = extractVimeoId(videoUrl);
      mediaHTML += `<center><div class="mb-2"><iframe src="https://player.vimeo.com/video/${vimeoId}" width="400" height="225" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe></div></center>`;
    } else if (videoType === 'youtube') {
      mediaHTML += `<center><div class="mb-2"><iframe width="400" height="225" src="${videoUrl}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe></div></center>`;
    } else {
      mediaHTML += `<center><video controls width="300" class="mb-2"><source src="${videoUrl}" type="video/${videoType}">Your browser does not support video.</video></center>`;
    }
  }

  let html = `<div class="question-box">
<div class="d-flex justify-content-between align-items-center mb-2">
<div class="question-header">
  <span class="question-number">Question ${pageIdx + 1}</span>
${q.type === 'multiple_answers' && Array.isArray(q.correct_answer) ? `<span class="hint-text">(Hint: ${q.correct_answer.length} correct answer${q.correct_answer.length > 1 ? 's' : ''} here)</span>` : ''}
</div>
</div>
<p class="question-text"><strong>${decodeHTMLEntities(q.question)}</strong></p>`;

html += `<br>${mediaHTML}<div class="mt-3"><hr>`;


  opts.forEach(op => {
    const inputType = q.type === 'multiple_answers' ? 'checkbox' : 'radio';
    const customClass = inputType === 'checkbox' ? 'custom-checkbox' : 'custom-radio';
    const isChecked = q.type === 'multiple_answers'
      ? (answers[q.question_id] || []).includes(op)
      : answers[q.question_id] === op;

    html += `<div class="assignment-option">
      <label class="option-label">
        <span class="option-text">${decodeHTMLEntities(op)}</span>
        <input type="${inputType}"
          name="q${q.question_id}${inputType === 'checkbox' ? '[]' : ''}"
          value="${op}"
          ${isChecked ? 'checked' : ''}
          onchange="updateAnswer(${q.question_id}, '${op}', '${q.type}')">
        <span class="${customClass}"></span>
      </label>
    </div>`;
  });

  html += `</div></div>`;

  // ⏱ Countdown + Marks placeholder
  if ((q.duration && !isNaN(q.duration)) || q.marks) {
    html += `<div class="question-timer text-center mt-3" id="timer-box" style="font-weight:bold; color:#d9534f;float:left;margin-top:10px;">
               ${q.duration && !isNaN(q.duration) ? `Time left: ${q.duration} sec` : ''}
               ${q.marks ? ` | Marks: ${q.marks}` : ''}
             </div>`;
  }

  html += `<div class="assignment-navigation btn-right mt-4">
    <button type="button" class="btn btn-primary btn-right-mrg" id="nextBtn" disabled
      onclick="${pageIdx === questions.length - 1 ? 'submitassignment()' : `renderPage(${pageIdx + 1})`}">
      ${pageIdx === questions.length - 1 ? 'Submit assignment' : 'Next'}
    </button>
  </div>`;

  const totalQuestions = questions.length;
  const currentQuestionNumber = pageIdx + 1;
  const percent = Math.round((currentQuestionNumber / totalQuestions) * 100);
  document.getElementById('progress-text').innerText = `Question ${currentQuestionNumber} of ${totalQuestions}`;
  const progressBar = document.getElementById('progress-bar');
  progressBar.style.width = `${percent}%`;
  progressBar.setAttribute('aria-valuenow', percent);

  document.querySelector('.questions').innerHTML = html;
  currentPage = pageIdx;

  // ✅ Countdown logic
  if (q.duration && !isNaN(q.duration)) {
    let remaining = parseInt(q.duration, 10); // seconds
    const timerBox = document.getElementById("timer-box");

    function updateTimer() {
      if (timerBox) {
        timerBox.innerText = `Time left: ${remaining} sec${q.marks ? ` | Marks: ${q.marks}` : ''}`;
      }
      if (remaining <= 0) {
        clearInterval(window.countdownInterval);
        if (pageIdx < questions.length - 1) {
          renderPage(pageIdx + 1);
        } else {
          submitassignment();
        }
      }
      remaining--;
    }

    updateTimer(); // run once immediately
    window.countdownInterval = setInterval(updateTimer, 1000);

    // backup auto-next in case setInterval lags
    window.autoNextTimer = setTimeout(() => {
      clearInterval(window.countdownInterval);
      if (pageIdx < questions.length - 1) {
        renderPage(pageIdx + 1);
      } else {
        submitassignment();
      }
    }, remaining * 1000);
  }

  // ✅ Enable Next only if any option selected
  const inputName = `q${q.question_id}${q.type === 'multiple_answers' ? '[]' : ''}`;
  const inputElements = document.querySelectorAll(`input[name="${inputName}"]`);
  const nextBtn = document.getElementById('nextBtn');

  function checkAnswerSelected() {
    let selected = false;
    inputElements.forEach(input => {
      if (input.checked) selected = true;
    });
    if (nextBtn) nextBtn.disabled = !selected;
  }

  inputElements.forEach(input => {
    input.addEventListener('change', checkAnswerSelected);
  });

  checkAnswerSelected();

  showFeedbackIfAnswered(q.question_id, q.type, q.correct_answer);
}



  window.renderPage = renderPage;
  renderPage(currentPage);
  window.assignmentData = assignment;
}

window.updateAnswer = function(qid, ans, type) {
  const assignment = window.assignmentData;
  const q = assignment.questions.find(q => q.question_id == qid);
  if (!q) return;

const correctAnswers = Array.isArray(q.correct_answer)
  ? q.correct_answer.map(c => decodeHTMLEntities((c || '').toString()).trim().toLowerCase())
  : [decodeHTMLEntities((q.correct_answer || '').toString()).trim().toLowerCase()];

  const radios = document.querySelectorAll(`input[name="q${qid}${type === 'multiple_answers' ? '[]' : ''}"]`);

  if (type === 'multiple_answers') {
    if (!answers[qid]) answers[qid] = [];

    const idx = answers[qid].indexOf(ans);
    if (idx === -1) answers[qid].push(ans);
    else answers[qid].splice(idx, 1);

    const selectedNormalized = answers[qid].map(a => 
  decodeHTMLEntities(a.toString()).trim().toLowerCase()
);

    const hasIncorrect = selectedNormalized.some(sel => !correctAnswers.includes(sel));
    const allCorrectSelected = correctAnswers.every(ca => selectedNormalized.includes(ca));

    // if (hasIncorrect || allCorrectSelected) {
    //   radios.forEach(radio => {
    //     radio.disabled = true;
    //     const label = radio.closest('.option-label');
    //     const value = radio.value.toString().trim().toLowerCase();

    //     if (correctAnswers.includes(value)) {
    //       label.classList.add('correct');
    //       label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ✔️</span>';
    //     }

    //     if (selectedNormalized.includes(value) && !correctAnswers.includes(value)) {
    //       label.classList.add('incorrect');
    //       label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ❌</span>';
    //     }
    //   });
    // }

  } else {
    answers[qid] = ans;

    // radios.forEach(radio => {
    //   radio.disabled = true;
    //   const label = radio.closest('.option-label');
    //   const value = radio.value.toString().trim().toLowerCase();

    //   if (correctAnswers.includes(value)) {
    //     label.classList.add('correct');
    //     label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ✔️</span>';
    //   }

    //   if (radio.value === ans && !correctAnswers.includes(value)) {
    //     label.classList.add('incorrect');
    //     label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ❌</span>';
    //   }
    // });
  }
}

function showFeedbackIfAnswered(qid, type, correctAnswer) {
const correctAnswers = Array.isArray(correctAnswer)
  ? correctAnswer.map(c => decodeHTMLEntities((c || '').toString()).trim().toLowerCase())
  : [decodeHTMLEntities((correctAnswer || '').toString()).trim().toLowerCase()];


  const inputName = `q${qid}${type === 'multiple_answers' ? '[]' : ''}`;
  const inputs = document.querySelectorAll(`input[name="${inputName}"]`);
  if (!answers[qid]) return;

  if (type === 'multiple_answers') {
    const selected = (answers[qid] || []).map(a => a.toString().trim().toLowerCase());

    inputs.forEach(input => {
      input.disabled = true;
      const label = input.closest('.option-label');
      const value = input.value.toString().trim().toLowerCase();
      const textEl = label.querySelector('.option-text');

      if (correctAnswers.includes(value)) {
        label.classList.add('correct');
        if (!textEl.innerHTML.includes('✔️')) textEl.innerHTML += ' <span class="icon-feedback"> ✔️</span>';
      }
      if (selected.includes(value) && !correctAnswers.includes(value)) {
        label.classList.add('incorrect');
        if (!textEl.innerHTML.includes('❌')) textEl.innerHTML += ' <span class="icon-feedback"> ❌</span>';
      }
    });

  } else {
    const selected = (answers[qid] || '').toString().trim().toLowerCase();

    inputs.forEach(input => {
      input.disabled = true;
      const label = input.closest('.option-label');
      const value = input.value.toString().trim().toLowerCase();
      const textEl = label.querySelector('.option-text');

      if (correctAnswers.includes(value)) {
        label.classList.add('correct');
        if (!textEl.innerHTML.includes('✔️')) textEl.innerHTML += ' <span class="icon-feedback"> ✔️</span>';
      }

      if (selected === value && !correctAnswers.includes(value)) {
        label.classList.add('incorrect');
        if (!textEl.innerHTML.includes('❌')) textEl.innerHTML += ' <span class="icon-feedback"> ❌</span>';
      }
    });
  }
}

function decodeHTMLEntities(str) {
  const txt = document.createElement("textarea");
  txt.innerHTML = str;
  return txt.value;
}

function showResult(resultData) {
  const assignment = resultData;
  $('.progress').hide();
  
  document.getElementById('assignment-title').innerText = assignment.assignment_title;
  
  let html = `<h3 class="text-center mb-4 thankyou-title">Thank you for completing ${assignment.assignment_title}</h3>`;

html += `<div style="text-align:center;padding:15px; border:1px solid #eee; border-radius:8px; background:#fbf9ff;">
  <h3 style="color:#5D2B8B; margin-bottom:10px;">Your Score</h3>
  <p style="font-size:18px; color:#333;">
    You have obtained <strong>${assignment.obtained_marks}</strong> out of <strong>${assignment.total_marks}</strong> marks.
  </p>
</div>`;
//   assignment.questions.forEach((q, idx) => {
//     let opts = Array.isArray(q.options) ? q.options.filter(o => o) : [];
//     if (opts.length === 0) {
//       if (q.type === 'yes_no') opts = ['Yes', 'No'];
//       else if (q.type === 'true_false') opts = ['True', 'False'];
//     }

//     // ✅ Decode all options before comparison
//     opts = opts.map(op => decodeHTMLEntities(op || ''));

//     const optionMap = {};
//     opts.forEach((op, i) => {
//       optionMap[op.toString().trim().toLowerCase()] = `option_${i + 1}`;
//     });

//     // ✅ Decode correct answers
//     const correctArr = Array.isArray(q.correct_answer)
//       ? q.correct_answer.map(c => decodeHTMLEntities((c || '').toString()).trim().toLowerCase())
//       : [decodeHTMLEntities((q.correct_answer || '').toString()).trim().toLowerCase()];

//     // ✅ Decode selected answers
//     const selectedRaw = q.selected_answer;
//     const selectedArr = Array.isArray(selectedRaw)
//       ? selectedRaw.map(s => decodeHTMLEntities((s || '').toString()).trim().toLowerCase())
//       : [decodeHTMLEntities((selectedRaw || '').toString()).trim().toLowerCase()];

//     const correctCols = correctArr.map(c => optionMap[c] || '').filter(Boolean);
//     const selectedCols = selectedArr.map(s => optionMap[s] || '').filter(Boolean);

//     html += `<div class="question-box"><p><hr><strong>${idx + 1}. ${decodeHTMLEntities(q.question)}</strong></p>`;
//     opts.forEach(op => {
//       const opNorm = (op || '').toString().trim().toLowerCase();
//       const isCorr = correctArr.includes(opNorm);
//       const isSel = selectedArr.includes(opNorm);

//       let classList = 'review-answer-box';
//       if (isCorr) classList += ' correct';
//       else if (isSel) classList += ' incorrect';

//       let label = '';
//       if (isSel && isCorr) label = 'Your Answer [Correct Answer]';
//       else if (isSel) label = 'Your Answer';
//       else if (isCorr) label = 'Correct Answer';

//       html += `<div class="${classList}">${decodeHTMLEntities(op)}${label ? `<span class="review-answer-label">${label}</span>` : ''}</div>`;
//     });
//     html += `</div>`;
//   });

  const attemptCount = assignment.attempt_count || 0;
  const maxMarks = assignment.total_marks || 0;
  const score = assignment.obtained_marks || 0;
  const percentage = maxMarks > 0 ? (score / maxMarks) * 100 : 0;

  // ✅ Add pass/fail message block
if (percentage < 70) {
  html += `
    <div style="text-align: center; padding: 20px; font-family: Arial, sans-serif;">
      <h2 style="color: #D9534F; font-weight: bold;">We appreciate your effort in completing the course!</h2>
      <p style="font-size: 16px; color: #5C2C8B;">
        Unfortunately, you did not pass the final assignment this time.
      </p>
      ${
        attempt < 3
          ? `<p style="font-size: 16px; color: #5C2C8B;">
              You can review the course materials and attempt the assignment again to improve your score. 
              Remember, every step brings you closer to mastery - keep going!
             </p>`
          : `<p style="font-size: 16px; color: #5C2C8B;">
              Remember, every step brings you closer to mastery - keep going!
             </p>`
      }
    </div>
  `;
} else {
    html += `
      <div style="text-align: center; padding: 20px; font-family: Arial, sans-serif;">
        <h2 style="color: #6A1B9A; font-weight: bold;">Congratulations on completing the course!</h2><br>
        <p style="font-size: 16px; color: #5C2C8B;">
          Your learning journey has been successfully recorded. You can now download your
          course completion certificate using the link below.
        </p>
        <p style="font-size: 16px; color: #5C2C8B;">
          Please also check your registered email for a copy of your certificate along with a confirmation
          of your course completion.
        </p>
        <p style="font-size: 16px; color: #5C2C8B;">
          You can view your certificates anytime on your dashboard. The dashboard also allows you to track
          your pending courses, upcoming courses, and certificates earned.
        </p>
        <p style="font-weight: bold; font-style: italic; color: #6A1B9A;">
          Keep learning and achieving more!
        </p>
      </div>
    `;
  }

  // ✅ Show buttons conditionally
  html += `<center>`;

  if (attemptCount < 3 && percentage < 70) {
    // Show re-attempt button
    const nextAttempt = Math.min(attemptCount + 1, 3); // prevent going above 3
    html += `<button type="button" class="btn btn-primary ms-2" 
                onclick="location.href='assignment.php?assignment_id=${assignmentId}&course=${courseId}&attempt=${nextAttempt}'">
                Re-Attempt
             </button>`;
  } else if (percentage >= 70) {
    // Show certificate button
    html += `<button type="button" class="btn btn-primary ms-2" 
                onclick="generateCertificate('${assignment.assignment_title}')">
                Generate Certificate
             </button>`;
  }

  html += `</center>`;

  document.querySelector('.questions').innerHTML = html;
}





let isSubmitting = false;

window.submitassignment = function () {
    
  if (isSubmitting) return; 
  isSubmitting = true;
  
  const assignment = window.assignmentData;

$('.progress').hide();

  let html = `<h3 class="text-center mb-4 thankyou-title">
                Thank you for completing ${assignment.assignment_title}
              </h3>`;


  const questionsPayload = [];
  let obtainedMarks = 0;
  let totalMarks = 0;

  assignment.questions.forEach((q, idx) => {
    let opts = Array.isArray(q.options) ? q.options.filter(o => o) : [];
    if (opts.length === 0) {
      if (q.type === 'yes_no') opts = ['Yes', 'No'];
      else if (q.type === 'true_false') opts = ['True', 'False'];
    }

    // ✅ Build mapping option text → option_N
    const optionMap = {};
    opts.forEach((op, i) => {
      const decodedOp = decodeHTMLEntities((op || '').toString()).trim().toLowerCase();
      optionMap[decodedOp] = `option_${i + 1}`;
    });

    // correct answers
    const correctArr = Array.isArray(q.correct_answer)
      ? q.correct_answer.map(c => decodeHTMLEntities((c || '').toString()).trim().toLowerCase())
      : [decodeHTMLEntities((q.correct_answer || '').toString()).trim().toLowerCase()];

    // selected answers
    const selectedRaw = answers[q.question_id];
    const selectedArr = Array.isArray(selectedRaw)
      ? selectedRaw.map(s => decodeHTMLEntities((s || '').toString()).trim().toLowerCase())
      : [decodeHTMLEntities((selectedRaw || '').toString()).trim().toLowerCase()];

    // marks handling
    const questionMarks = parseInt(q.marks || 1, 10);
    totalMarks += questionMarks;

    // ✅ check correctness
    const isCorrect =
      q.type === 'multiple_answers'
        ? correctArr.length === selectedArr.length && correctArr.every(c => selectedArr.includes(c))
        : correctArr[0] === selectedArr[0];

    if (isCorrect) {
      obtainedMarks += questionMarks;
    }

    // prepare columns for saving
    let correctCols, selectedCols;
    if (q.type === 'yes_no' || q.type === 'true_false') {
      correctCols = correctArr.map(c => c.charAt(0).toUpperCase() + c.slice(1));
      selectedCols = selectedArr.map(s => s.charAt(0).toUpperCase() + s.slice(1));
    } else {
      correctCols = correctArr.map(c => optionMap[c] || '').filter(Boolean);
      selectedCols = selectedArr.map(s => optionMap[s] || '').filter(Boolean);
    }

    // save payload for backend
    questionsPayload.push({
      question_id: q.question_id,
      marks: q.marks,
      correct_answer: correctCols.join(","),
      selected_answer: selectedCols.join(",")
    });

  });

  // ✅ Save marks into assignment object
  assignment.total_marks = totalMarks;
  assignment.obtained_marks = obtainedMarks;

  // 🔹 Calculate percentage
  const percentage = totalMarks > 0 ? (obtainedMarks / totalMarks) * 100 : 0;


html += `<div style="text-align:center;padding:15px; border:1px solid #eee; border-radius:8px; background:#fbf9ff;">
  <h3 style="color:#5D2B8B; margin-bottom:10px;">Your Score</h3>
  <p style="font-size:18px; color:#333;">
    You have obtained <strong>${obtainedMarks}</strong> out of <strong>${totalMarks}</strong> marks.
  </p>
</div>`;

  // 🔹 Pass/Fail message
if (percentage < 70) {
  html += `
    <div style="text-align: center; padding: 20px; font-family: Arial, sans-serif;">
      <h2 style="color: #D9534F; font-weight: bold;">We appreciate your effort in completing the course!</h2>
      <p style="font-size: 16px; color: #5C2C8B;">
        Unfortunately, you did not pass the final assignment this time.
      </p>
      ${
        attempt < 3
          ? `<p style="font-size: 16px; color: #5C2C8B;">
              You can review the course materials and attempt the assignment again to improve your score. 
              Remember, every step brings you closer to mastery - keep going!
             </p>`
          : `<p style="font-size: 16px; color: #5C2C8B;">
              Remember, every step brings you closer to mastery - keep going!
             </p>`
      }
    </div>
  `;
} else {
    html += `
      <div style="text-align: center; padding: 20px; font-family: Arial, sans-serif;">
        <h2 style="color: #6A1B9A; font-weight: bold;">Congratulations on completing the course!</h2><br>
        <p style="font-size: 16px; color: #5C2C8B;">
          Your learning journey has been successfully recorded. You can now download your
          course completion certificate using the link below.
        </p>
        <p style="font-size: 16px; color: #5C2C8B;">
          Please also check your registered email for a copy of your certificate along with a confirmation
          of your course completion.
        </p>
        <p style="font-size: 16px; color: #5C2C8B;">
          You can view your certificates anytime on your dashboard. The dashboard also allows you to track
          your pending courses, upcoming courses, and certificates earned.
        </p>
        <p style="font-weight: bold; font-style: italic; color: #6A1B9A;">
          Keep learning and achieving more!
        </p>
      </div>
    `;
  }

  // 🔹 Action buttons
  html += `<center>`;

  if (percentage < 70 && attempt < 3) {
    const params = new URLSearchParams(window.location.search);
    const currentAttempt = parseInt(params.get("attempt")) || 0;  
    const nextAttempt = currentAttempt + 1;
    
    html += `<button type="button" class="btn btn-primary ms-2" 
               onclick="location.href='assignment.php?assignment_id=${assignmentId}&course=${courseId}&attempt=${nextAttempt}'">
               Re-Attempt
             </button>`;
  } else if (percentage >= 70) {
    html += `<button type="button" class="btn btn-primary ms-2" onclick="generateCertificate('${assignment.assignment_title}')">
               Generate Certificate
             </button>`;
  }

  html += `</center>`;

  document.querySelector('.questions').innerHTML = html;

  // 🔹 Send data to backend
  const payload = {
    assignment_id: assignmentId,
    course_id: courseId,
    total_marks: totalMarks,
    obtained_marks: obtainedMarks,
    percentage: percentage,
    questions: questionsPayload
  };

// 🔹 Send assignment data to backend using jQuery AJAX
$.ajax({
  url: "apis/save_assignment_attempt.php",
  type: "POST",
  contentType: "application/json",
  data: JSON.stringify(payload),
  success: function(resp) {
    if (resp.status === "success") {
      $.ajax({
        url: 'certificate_emailer.php?download=pdf&course='+courseId+'&total='+totalMarks+'&obtained='+obtainedMarks,
        type: 'POST',
        data: {
          assignment_id: assignmentId,
          course_id: courseId,
          obtained_marks: obtainedMarks,
          total_marks: totalMarks
        },
        success: function(emailResp) {
        },
        error: function(xhr, status, error) {
        }
      });

    } else {
      console.error("❌ Failed to save assignment attempt", resp);
    }
  },
  error: function(xhr, status, error) {
    console.error("❌ API Error:", error);
  }
});


};





});



function generateCertificate(courseName) {

  // Show modal
  $('#modal-certificate').modal('show');

  // Show loader
  $('#certificateModalBody').html(`
    <div id="cert-loader" class="text-center">
      <p style="color:#5C2C8B;font-weight:500;">Generating Certificate...</p>
    </div>
  `);

  // Simulate generating certificate (2 seconds delay)
  setTimeout(() => {
    const url = `certificate.php?course=${courseId}`;
    
    $.get(url, function(html) {
      $('#certificateModalBody').html(html);
    }).fail(function() {
      $('#certificateModalBody').html("<p class='text-danger'>Failed to load certificate.</p>");
    });
  }, 4000); // 3 seconds loader
}


function decodeHTMLEntities(str) {
  const txt = document.createElement("textarea");
  txt.innerHTML = str;
  return txt.value;
}


</script>




</body>
</html>