<?php
require_once('includes/connection.php');

require_once('includes/PHPMailerAutoload.php');
require_once('includes/class.phpmailer.php');
require_once('includes/class.smtp.php');

require_once __DIR__ . '/vendor/pdf/dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;

// For now, hardcode course_id to 1

$total_marks = $_GET['total'];
$obtained_marks = $_GET['obtained'];


if (!isset($_GET['course'])) {
    echo json_encode(['status' => 'error', 'message' => 'Missing course_id']);
    exit;
}

$course_id = intval($_GET['course']);

$percentage = ($obtained_marks / $total_marks) * 100;
if ($percentage < 70) {
    echo json_encode(['status' => 'error', 'message' => 'Certificate not generated. Score is below 70%.']);
    exit;
}

// Make sure $user_id and $institute_id are defined, e.g., from session or other source
$user_id = $_SESSION['user_id'] ?? null;
$institute_id = $_SESSION['institute_id'] ?? null;

if (!$user_id || !$institute_id) {
    echo json_encode(['status' => 'error', 'message' => 'User or Institute not identified']);
    exit;
}

// Fetch course details
$courseStmt = $pdo->prepare("
    SELECT course_title, created_date
    FROM course_master
    WHERE course_id = :id
");
$courseStmt->bindParam(':id', $course_id, PDO::PARAM_INT);
$courseStmt->execute();
$course = $courseStmt->fetch(PDO::FETCH_ASSOC);

if (!$course) {
    echo json_encode(['status' => 'error', 'message' => 'Course not found']);
    exit;
}

$course_title = $course['course_title'];

// Fetch latest completion date from assignment_attempts where obtained >= 70%
$attemptStmt = $pdo->prepare("
    SELECT created_date
    FROM assignment_attempts
    WHERE course_id = :course_id
      AND user_id = :user_id
      AND institute_id = :institute_id
      AND (obtained_marks / total_marks * 100) >= 70
    ORDER BY created_date DESC
    LIMIT 1
");
$attemptStmt->execute([
    ':course_id' => $course_id,
    ':user_id' => $user_id,
    ':institute_id' => $institute_id
]);
$attempt = $attemptStmt->fetch(PDO::FETCH_ASSOC);

if ($attempt && !empty($attempt['created_date'])) {
    $cert_date = date('d / M / Y', strtotime($attempt['created_date']));
} else {
    $cert_date = date('d / M / Y'); // fallback to current date
}

$user_name = $_SESSION['user_name'] ?? "Student";

// Generate and save PDF if requested
if (isset($_GET['download']) && $_GET['download'] === 'pdf') {
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('isRemoteEnabled', true);
    $dompdf = new Dompdf($options);

    ob_start();
    ?>
    <div style="
        width: 100%;
        height: 90%;
        text-align: center;
        font-family: Arial, sans-serif;
        background: url('https://kapps.co.in/EPIC_LMS/vendor/pdf/dompdf/certificate_background.png') no-repeat center center;
        background-size: cover;
        box-sizing: border-box;
    ">
        <br><br><br><br>    
        <img src="https://kapps.co.in/EPIC_LMS/vendor/pdf/dompdf/certificate-watermark.png"
            style="
                position: absolute;
                top: 15%;
                left: 50%;
                transform: translate(-50%, -50%);
                opacity: 0.2;
                height: 300px;
                z-index: 0;
            " />
        <h1 style="
            font-weight: 700;
            margin: 0;
            color: #6A1B9A;
            font-size: 26px;
            margin-bottom: 10px;
            letter-spacing: 6px;
        ">CERTIFICATE</h1>
        <div style="font-size: 12px; color: #555; margin-bottom: 25px;">OF ACHIEVEMENT</div>
        <div style="font-size: 12px; color: #555; margin: 40px 0 40px 0;">
            THIS CERTIFICATE IS PROUDLY PRESENTED TO
        </div>
        <div style="
            font-size: 28px;
            font-weight: 700;
            color: #6A1B9A;
            letter-spacing: 6px;
            margin: 20px 0;
            text-transform: uppercase;
        "><?= htmlspecialchars($user_name) ?></div>
        <div style="font-size:14px; margin:3px 0; color: #555;">
            FOR THE SUCCESSFUL COMPLETION OF:
        </div>
        <div style="font-size:16px; margin:50px 0;">
            <div style="font-size:12px;">
                <strong>COURSE:</strong> <?= htmlspecialchars($course_title) ?>&nbsp;&nbsp;&nbsp;
                <strong>DATE:</strong> <?= htmlspecialchars($cert_date) ?>
            </div>
            <div style="font-size:16px; color:#555; margin:30px 0;">
                We applaud your commitment to learning and congratulate you on your success!
            </div>
            <div style="margin-top:55px;">
                <img src="https://kapps.co.in/EPIC_LMS/vendor/pdf/dompdf/logo.png" style="height: 60px;">
            </div>
        </div>
    </div>
    <?php
    $html = ob_get_clean();

    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();

    $filename = "Certificate_" . preg_replace('/\s+/', '_', $user_name) . "_" . uniqid() . ".pdf";
    $certificatesDir = 'certificates/';


    $filePath = $certificatesDir . $filename;
    file_put_contents($filePath, $dompdf->output());

// After file_put_contents($filePath, $dompdf->output());

$user_email = $_SESSION['email_id'];
$user_name = $_SESSION['user_name'] ?? "Student";

if (sendCertificateEmail($user_email, $user_name, $filePath, $filename)) {
        if (file_exists($filePath)) {
        unlink($filePath);
    }
    echo json_encode(['status' => 'success', 'message' => 'Certificate generated and emailed', 'file' => $filename]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Certificate generated but email failed']);
}

exit;

}



function sendCertificateEmail($toEmail, $toName, $filePath, $filename) {

    $url = 'https://kapps.co.in/EPIC_LMS/certificates/' . $filename;
    $filePathCert = file_get_contents($url);
    
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.zoho.com';
        $mail->SMTPAuth   = true;
        $mail->Username = 'notifications@epichim.com';
        $mail->Password = '@Hhbmet4';
        $mail->SMTPSecure = 'ssl';
        $mail->Port       = 465;
        $mail->From = 'notifications@epichim.com';
        $mail->FromName = 'LMS';
        $mail->addAddress($_SESSION['email_id']);        

        $mail->setFrom('notifications@epichim.com', 'EPIC LMS');
        $mail->addAddress($toEmail, $toName);

        $mail->isHTML(true);
        $mail->Subject = 'Your Course Completion Certificate';

        $mail->Body = "
            <p>Dear $toName,</p>
            <p>Congratulations on successfully completing the course! Please find your certificate attached.</p>
            <p>Keep up the great work!</p>
            <p>Best regards,<br>EPIC LMS Team</p>
        ";

        $mail->AltBody = "Dear $toName, congratulations on completing your course. Certificate is attached.";

        $mail->addStringAttachment($filePathCert, $filename);

        $mail->send();

        return true;
    } catch (Exception $e) {
        // Log error or handle as needed
        return false;
    }
}

?>
