<?php 
$page_name = 'Courses';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>
.content-wrapper, .main-footer {
    margin-left: unset !important;
}

.main-header .navbar {
    margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
    border-bottom: 1px solid #5C2C8B;
}

.course-card {
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 0 10px rgba(0,0,0,0.06);
  overflow: hidden;
  margin-bottom: 30px;
  transition: 0.3s;
  text-align: left;
  height: 100%;
  width: 75%;
  margin: 35px 0px;  
  box-shadow: 0 6px 16px rgba(59, 30, 132, 0.15);
}

.course-img {
  width: 100%;
  height: 150px;
  object-fit: cover;
  margin-bottom: 10px;
}

.course-meta {
    font-size: 10px;
    color: #5C2C8B;
    margin-bottom: 5px;
    text-transform: uppercase;
    background: #F2E9FD;
    padding: 5px;
    border-radius: 5px;
}

.course-title {
    font-size: 13px;
    font-weight: 600;
    color: #3b1e84;
    margin-bottom: 8px;
    padding: 10px 10px 0px 10px;

    /* Ellipsis styles */
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    display: block;        /* required */
    max-width: 100%;       /* or fixed width like 200px if needed */
}


.course-duration {
    font-size: 14px;
    color: #666;
    padding: 0px 10px 10px 10px;
}

.course-hr
{
    margin-top: 15px;
    margin-bottom: 15px;
}

.tags-course
{
    padding: 5px 10px;
}

.course-box-user {
    width: 75%;
    box-shadow: 0 6px 16px rgba(59, 30, 132, 0.15);
    display: flex;
    align-items: center;    
    min-height: 100px;
    background: #fff;
    border-radius: 10px;
    padding: 15px;    
}

.content {
    padding: 20px 50px;
}

.category-title
{
    font-size: 16px;
    font-weight: 600;
    color: #3b1e84;
    margin-top: 0;
}

/* Category Box Styling */
.category-box {
    cursor: pointer;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    background-color: #f7f7f7;
    transition: background-color 0.3s ease;
}

.category-box:hover {
    background-color: #ddd;
}

</style>

<section class="content">
    <h3 style="font-weight: 600; color: #3b1e84;">Hello <?php echo $_SESSION['user_name'];?></h3>
    <p>Welcome to EPiC learning management system.</p>   

    <div class="row course-card-container" id="course-list"></div>
    
    <h3 style="margin-top: 50px; font-weight: 600; color: #3b1e84;">Explore courses by category</h3>
    <br>
    
    <div class="row" id="category-container"></div>

</section>

<?php require_once('includes/footer.php'); ?>

<script>
var coursesByCategory = {};
var allCourses = [];

$.ajax({
    url: 'apis/fetch_courses.php',
    type: 'GET',
    dataType: 'json',
    success: function (response) {
        // Organize courses by category and store all courses
        if (response.status === "success" && response.courses) {
            $.each(response.courses, function (index, course) {
                const encId = btoa(course.course_id.toString());
                if (!coursesByCategory[course.category_name]) {
                    coursesByCategory[course.category_name] = [];
                }
                coursesByCategory[course.category_name].push(course);
                allCourses.push(course); // Storing all courses
            });
        }

        // Render Categories
        if (response.status === "success" && response.categories) {
            var categoryContainer = $("#category-container");
            categoryContainer.empty();
            
            const colors = ['#FAF7FE', '#F7FEF7', '#F7FEFE', '#F7FEF8', '#FFF7F6', '#FEF7FE', '#F3F3F3'];

            $.each(response.categories, function (index, category) {
                // Pick color based on index, loop back if more categories than colors
                var bgColor = colors[index % colors.length];
                
                var categoryBox = `
                    <div class="col-md-3">
                        <div class="course-box-user category-box" style="background-color: ${bgColor};" data-category="${category.category_name}">
                            <h2 class="category-title">${category.category_name}</h2>
                        </div>
                    </div>
                `;
                categoryContainer.append(categoryBox);
            });

            // Add click handler to categories
            $(".category-box").click(function() {
                var categoryName = $(this).data("category");
                showCoursesByCategory(categoryName);
            });

            // By default, show all courses
            showAllCourses();
        }
    },
    error: function (xhr, status, error) {
        console.error("AJAX Error:", status, error);
    }
});

// Function to show all courses
function showAllCourses() {
    var container = $("#course-list");
    container.empty();

    $.each(allCourses, function (index, course) {
        const encId = btoa(course.course_id.toString());
        var courseCard = `
            <div class="col-md-3">
                <div class="course-card" style="cursor:pointer;" onclick="window.location.href='course_details.php?id=${encId}'">
                    <img src="${course.course_img}" alt="${course.course_title}" class="course-img">
                    <div class="tags-course">
                        <span class="course-meta">${course.category_name}</span>
                    </div>
                    <h4 class="course-title" title="${course.course_title}">${course.course_title}</h4>
                    <hr class="course-hr">
                    <div class="course-duration">${course.hours} hrs.</div>
                </div>
            </div>
        `;
        container.append(courseCard);
    });
}

// Function to show courses based on selected category
function showCoursesByCategory(categoryName) {
    var container = $("#course-list");
    container.empty();

    if (coursesByCategory[categoryName]) {
        $.each(coursesByCategory[categoryName], function (index, course) {
            const encId = btoa(course.course_id.toString());
            var courseCard = `
                <div class="col-md-3">
                    <div class="course-card" style="cursor:pointer;" onclick="window.location.href='course_details.php?id=${encId}'">
                        <img src="${course.course_img}" alt="${course.course_title}" class="course-img">
                        <div class="tags-course">
                            <span class="course-meta">${course.category_name}</span>
                        </div>
                        <h4 class="course-title" title="${course.course_title}">${course.course_title}</h4>
                        <hr class="course-hr">
                        <div class="course-duration">${course.hours} hrs.</div>
                    </div>
                </div>
            `;
            container.append(courseCard);
        });
    }
}
</script>

</body>
</html>
