<?php 
require_once('includes/login_header.php');
?>

<body>
    <div class="login-box">
        <div class="login-box-body">
            <div class="row">
                <div class="col-md-6">
                    <h2 class="pl-15 mb-15 text-color">WELCOME TO EPIC LEARNING</h2>

                    <form id="loginForm" class="login-form">
                        <div class="error-message text-danger pl-15" style="margin-bottom: 20px;"></div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="text-color">Username</label>
                                <input class="form-control login-textbox" type="text" id="username" name="username" required="" value="<?php echo isset($_COOKIE['remembered_username']) ? htmlspecialchars($_COOKIE['remembered_username']) : ''; ?>">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="text-color">Password</label>
                                <input class="form-control login-textbox" type="password" id="password" name="password" value="<?php echo isset($_COOKIE['remembered_password']) ? htmlspecialchars($_COOKIE['remembered_password']) : ''; ?>" required="" onpaste="return false;">
                                <span class="input-group-text password-eye cursor-pointer" id="togglePassword">
                                    <i class="fa fa-eye" id="eyeIcon"></i>
                                </span> 
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="form-group hover-underline" style="float: right;">
                                <a href="forgot_password.php" style="color:#5C2C8B;">Forgot Password?</a>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <input type="checkbox" id="md_checkbox_25" class="chk-col-blue">
                                <label for="md_checkbox_25" class="text-color">I accept Terms and Conditions</label><a href="includes/EPiC HIM LMS – Terms and Conditions.pdf" target="_blank"><i class="fa fa-info-circle" title="Terms And Conditions" style="color: #5C2C8B; margin-left: 6px; font-size: 16px;"></i></a>
                                <br>
                                <input type="checkbox" id="md_checkbox_24" class="chk-col-blue" name="remember_me" value="1"
    <?php echo (isset($_COOKIE['remembered_username']) && isset($_COOKIE['remembered_password'])) ? 'checked' : ''; ?>>            
                                <label for="md_checkbox_24" class="text-color">Remember my ID</label>
                            </div>
                        </div>

                        <div class="col-md-12" style="margin-bottom:20px;">
                            <button type="submit" class="btn btn-primary form-control" id="loginBtn">Login</button>
                        </div>            

                    </form>

                    <div class="margin-top-30 text-center">
                        <p style="color:#5C2C8B;">Don't have an account? <a href="#" class="text-info m-l-5 hover-underline" style="color:#5C2C8B;">Sign Up</a></p>
                    </div>

                </div>

                <!-- Image Section (Right Side) -->
                <div class="col-md-6">
                    <div class="login-image">
                        <img src="https://kapps.co.in/EPIC_LMS/images/login-img.png" class="img-fluid" alt="Epic Learning" style="max-height: 300px; margin-top: 75px; width: 100%;">
                    </div>
                </div>
                
            </div>
        </div>
    </div>

<?php require_once('includes/login_footer.php'); ?>

<script>
    $(document).ready(function() {
        $("#loginForm").submit(function(e) {
            e.preventDefault();

            var username = $("#username").val();
            var password = $("#password").val();
            var remember_me = $("#md_checkbox_24").is(':checked') ? 1 : 0;
            $(".error-message").text("");

            $.ajax({
                url: 'apis/login_api.php',
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    username: username,
                    password: password,
                    remember_me: remember_me,
                }),                    
                success: function(response) {
                    if (response.status === 'success') {
                        window.location.href = 'verify_otp.php'; 
                    } else {
                        $(".error-message").text(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    $(".error-message").text("An error occurred. Please try again.");
                }
            });
        });

        // Enable or disable login button based on terms checkbox
        $('#md_checkbox_25').change(function() {
            if ($(this).prop('checked')) {
                $('#loginBtn').prop('disabled', false);
            } else {
                $('#loginBtn').prop('disabled', true);
            }
        });
        $('#md_checkbox_25').trigger('change'); // Trigger change event on page load
    });
</script>
</body>
</html>