<?php 
$page_name = 'Masters';
require_once('includes/connection.php');
require_once('includes/header_user.php');
?>

<style>

.skin-blue .main-header .navbar {
    background-color: #fff;
}

.login-profile {
    height: 90px;
}

.content-wrapper, .main-footer {
  margin-left: unset !important;
}

.main-header .navbar {
  margin-left: unset !important;    
}

.skin-blue .main-header .navbar {
  border-bottom: 1px solid #5C2C8B;
}

.progress-bar {
  background-color: #5C2C8B;
}

.module-list {
  list-style: none;
  padding: 0;
  margin-top: 15px;
}

.module-list li {
  padding: 5px 15px;
  border-radius: 5px;
  margin-bottom: 15px;
  background-color: #fff;
  cursor: pointer;
  border: 1px solid #ddd;
  transition: all 0.3s ease;
  color: #333;
}

.module-list li:hover {
  background-color: #f2e8fc;
  color: #5C2C8B;
}

.module-list li.active {
  background-color: #E9DFF8;
  color: #5C2C8B;
  font-weight: 600;
  border-left: 5px solid #5C2C8B;
}

.btn-dark {
  background-color: #5C2C8B;
  border-color: #5C2C8B;
}

.course-box {
  padding: 30px 0px;
}



#moduleTitle {
  color: #5C2C8B;
  font-size: 22px;
  font-weight: bold;
}

iframe {
  border-radius: 8px;
}

.quiz-box {
  padding: 30px;
  background-color: #f3ecff;
  border: 2px dashed #5C2C8B;
  border-radius: 10px;
  text-align: center;
  font-size: 18px;
  color: #5C2C8B;
  font-weight: bold;
}

@media (max-width: 767px) {
  .col-md-4, .col-md-8 {
    padding: 10px;
  }
}

.video-container {
  position: relative;
  padding-bottom: 56.25%; /* 16:9 ratio */
  height: 0;
  overflow: hidden;
  margin-bottom: 20px;
  border-radius: 8px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.video-container iframe {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border: none;
}


.timeline-toggle {
  margin-bottom: 20px;
  border-radius: 50px !important;
}

.timeline-wrapper {
      border-left: 2px dashed #6A1B9A;
  padding-left: 20px;
  margin-left: 15px;
  max-width: 300px;
}

.timeline-item {
  display: flex;
  align-items: flex-start;
}


.timeline-icon {
  font-size: 20px;
  margin-right: 10px;
  color: #6a1b9a;
}

.timeline-content h4 {
  margin: 0;
  color: #6a1b9a;
  font-size: 16px;
}

.timeline-content p {
  margin: 3px 0 0;
  font-size: 14px;
}

.assignment p {
  font-weight: bold;
}

.assignment.completed p {
  color: #4caf50;
}

.assignment.due-soon p {
  color: #ff5722;
}

.assignment.upcoming p {
  color: #ff9800;
}


.progress {
    height: 5px;
}

.btn-right {
    float: right;
}


.timeline-container {
  display: flex;
  flex-direction: column;
  max-width: 250px;
}



.icon-wrapper {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-right: 10px;
  position: relative;
  width: 24px;
}

.icon {
  width: 20px;
  height: 20px;
  z-index: 2;
}

.line {
  width: 2px;
  height: 50px;
  border-left: 2px dashed #a259cf;
  margin-top: 2px;
  z-index: 1;
}

.content .label {
  font-weight: bold;
  color: #6a1b9a;
  font-size: 16px;
  padding: unset;
}

.content .date {
  font-size: 14px;
  color: #6a1b9a;
}

.content {
    background: #F7F5F9 !important;
        padding: 0px 20px !important;
}

.course-title
{
        color: #5B2E8E;
    line-height: 30px;
    font-size: 20px;
}

@media (min-width: 768px) {
    .navbar-nav > li > a {
        padding-top: 30px;
    }
}



.quiz-option {
  margin-bottom: 10px;
  border-radius: 8px;
  overflow: hidden;
}

.option-label {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 7px 20px;
  border: 1px solid #e0e0e0;
  border-radius: 8px;
  cursor: pointer;
  transition: all 0.3s ease;
  position: relative;
  background: #fff;
}

.option-label:hover {
  box-shadow: 0 0 10px rgba(92, 44, 139, 0.1);
}

.option-text {
  font-weight: 500;
  font-size: 14px;
  color: #333;
}

/* Hide both radio and checkbox inputs */
.option-label input[type="radio"],
.option-label input[type="checkbox"] {
  display: none;
}

/* Base styles */
.custom-radio,
.custom-checkbox {
  width: 15px;
  height: 15px;
  border: 2px solid #ccc;
  position: relative;
  transition: all 0.3s ease;
}

/* Radio style (circle) */
.custom-radio {
  border-radius: 50%;
}

.custom-radio::after {
  content: "";
  position: absolute;
    top: 2px;
    left: 2px;
    width: 7px;
    height: 7px;
  background: #5C2C8B;
  border-radius: 50%;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.option-label input[type="radio"]:checked + .custom-radio {
  border-color: #5C2C8B;
}

.option-label input[type="radio"]:checked + .custom-radio::after {
  opacity: 1;
}

/* Checkbox style (square with tick) */
.custom-checkbox {
  border-radius: 4px;
}

.custom-checkbox::after {
  content: "✔";
  position: absolute;
top: -3px;
    left: 1px;
    font-size: 12px;
  color: #5C2C8B;
  opacity: 0;
  transition: opacity 0.3s ease;
}

.option-label input[type="checkbox"]:checked + .custom-checkbox {
  border-color: #5C2C8B;
}

.option-label input[type="checkbox"]:checked + .custom-checkbox::after {
  opacity: 1;
}

.review-answer-box {
    border: 1px solid #ccc;
    border-left: 4px solid #7B48AB;
    padding: 5px 16px;
    /* border-radius: 8px; */
    margin-bottom: 10px;
    background-color: #fff;
    /* color: #333; */
    position: relative;
    font-weight: 400;
    font-size: 14px;
}

.question-box
{
    margin-top:40px;
}

.review-answer-box.correct {
  //border-color: #28a745;
  //background-color: #eaf9ef;
  color: #42BB0F;
}

.review-answer-box.incorrect {
  //border-color: #dc3545;
  //background-color: #fdecea;
  color: #EF3D24;
}

.review-answer-label {
  font-size: 12px;
  position: absolute;
  right: 12px;
  top: 7px;
  font-weight: 500;
}

strong {
        font-weight: 600 !important;
    color: #5C2C8B;
}

@media (min-width: 1200px) {
    .container {
        width: 1280px;
    }
}

.option-label.correct .option-text {
  color: #42BB0F;
}

.option-label.incorrect .option-text {
  color: #EF3D24;
}


.quiz-box-outter
{
    border: 1px solid #707070;
    border-radius: 23px;
    opacity: 1;
    padding: 0px 20px 15px 20px;
}

.btn-right-mrg
{
    margin-right: 0px;
}

.btn-right
{
    float:right;
}

.thankyou-title
{
    color: #fff;
    background: #5D2B8B;
    padding: 10px;
    font-size: 15px;
    border-radius: 5px;
}

.content-header {
    padding: 20px 45px !important;
}

.hint-text
{
    color: #EF3D24;
    font-weight: 600;    
}
</style>

<div class="content-wrapper">
    <div class="row">

    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg-table" id="responseMessage"></div>
        <div class="box-body">


<div class="content-wrapper">
    
    
<section class="content-header d-flex justify-content-between align-items-center px-3 py-2" style="display: flex; justify-content: space-between; align-items: center;">
  <!-- Left: Quiz Title -->
  <span id="quiz-title" style="font-size: 18px;">
    Quiz Title
  </span>

  <!-- Right: Progress Bar -->
  <div style="text-align: right; min-width: 170px;">
    <div id="progress-text" class="small font-weight-bold mb-1" style="text-align: left;">

    </div>
    <div class="progress" style="height: 6px;">
      <div id="progress-bar" class="progress-bar" role="progressbar"
           style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
      </div>
    </div>
  </div>
</section>


    <div class="box box-default">
      <div class="box-header with-border">
        <div class="col-md-4 response-msg-table" id="responseMessage"></div>
        <div class="box-body">



<div class="container quiz-box-outter">
  <form id="quizAttemptForm">
    <div class="questions"></div>
  </form>
</div>

        </div>
      </div>
    </div>
</div>

        </div>
      </div>
    </div>
    </div>
</div>





<?php require_once('includes/footer.php'); ?>

<script>
const answers = {};
  const params = new URLSearchParams(window.location.search);
  const quizId = params.get('quiz_id');
  const courseId = params.get('course');

$(document).ready(function() {
    
async function checkQuizAttempt(quizId) {
  try {
    const attemptRes = await fetch(`apis/get_quiz_attempt_api.php?quiz_id=${quizId}&course_id=${courseId}`);
    const attemptData = await attemptRes.json();

    if (attemptData.status === "attempted") {
      // Already attempted → show result
      showResult(attemptData);
    } else {
      // Not attempted → fetch quiz data
      const quizRes = await fetch(`apis/get_single_quiz_api.php?quiz_id=${quizId}`);
      const quizData = await quizRes.json();

      if (quizData.status === "success" && quizData.questions?.length) {
        renderQuizHeader(quizData);
        renderQuizQuestions(quizData);
      } else {
        document.querySelector(".questions").innerHTML = "<p>No quiz data found.</p>";
      }
    }
  } catch (error) {
    console.error("Error fetching quiz:", error);
    document.querySelector(".questions").innerHTML =
      "<p style='color:red;'>Something went wrong. Please try again.</p>";
  }
}

// Call once
checkQuizAttempt(quizId);





  if (!quizId) {
    document.querySelector('.questions').innerHTML = '<p>Invalid quiz ID.</p>';
    return;
  }



function renderQuizHeader(quiz) {
  document.getElementById('quiz-title').innerText = quiz.quiz_title;
}

function extractVimeoId(url) {
  const match = url.match(/vimeo\.com\/(\d+)/);
  return match ? match[1] : '';
}

function renderQuizQuestions(quiz) {
  const questions = quiz.questions;
  let currentPage = 0;

  function renderPage(pageIdx) {
    const q = questions[pageIdx];
    let opts = Array.isArray(q.options) ? q.options.filter(o => o) : [];

    if (opts.length === 0) {
      if (q.type === 'yes_no') opts = ['Yes', 'No'];
      else if (q.type === 'true_false') opts = ['True', 'False'];
    }

    let mediaHTML = '';
    if (q.media?.image) {
      mediaHTML += `<center><img src="${q.media.image}" style="max-width:300px;" class="img-fluid mb-2"></center>`;
    }

    if (q.media?.video) {
      const videoUrl = q.media.video;
      const videoType = (q.media.video_type || '').toLowerCase();

      if (videoType === 'vimeo') {
        const vimeoId = extractVimeoId(videoUrl);
        mediaHTML += `<center><div class="mb-2"><iframe src="https://player.vimeo.com/video/${vimeoId}" width="400" height="225" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe></div></center>`;
      } else if (videoType === 'youtube') {
        mediaHTML += `<center><div class="mb-2"><iframe width="400" height="225" src="${videoUrl}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe></div></center>`;
      } else {
        mediaHTML += `<center><video controls width="300" class="mb-2"><source src="${videoUrl}" type="video/${videoType}">Your browser does not support video.</video></center>`;
      }
    }

    let html = `<div class="question-box">
<div class="d-flex justify-content-between align-items-center mb-2">
<div class="question-header">
  <span class="question-number">Question ${pageIdx + 1}</span>
${q.type === 'multiple_answers' && Array.isArray(q.correct_answer) ? `<span class="hint-text">(Hint: ${q.correct_answer.length} correct answer${q.correct_answer.length > 1 ? 's' : ''} here)</span>` : ''}
</div>
</div>
<p class="question-text"><strong>${q.question}</strong></p>`;


    html += `<br>${mediaHTML}<div class="mt-3"><hr>`;

    opts.forEach(op => {
      const inputType = q.type === 'multiple_answers' ? 'checkbox' : 'radio';
      const customClass = inputType === 'checkbox' ? 'custom-checkbox' : 'custom-radio';
      const isChecked = q.type === 'multiple_answers'
        ? (answers[q.question_id] || []).includes(op)
        : answers[q.question_id] === op;

      html += `<div class="quiz-option">
        <label class="option-label">
          <span class="option-text">${op}</span>
          <input type="${inputType}"
            name="q${q.question_id}${inputType === 'checkbox' ? '[]' : ''}"
            value="${op}"
            ${isChecked ? 'checked' : ''}
            onchange="updateAnswer(${q.question_id}, '${op}', '${q.type}')">
          <span class="${customClass}"></span>
        </label>
      </div>`;
    });

    html += `</div></div>`;

    html += `<div class="quiz-navigation btn-right mt-4">
      <button type="button" class="btn btn-secondary" ${pageIdx === 0 ? 'disabled' : ''} onclick="renderPage(${pageIdx - 1})">Back</button>
      <button type="button" class="btn btn-primary btn-right-mrg" id="nextBtn" disabled
        onclick="${pageIdx === questions.length - 1 ? 'submitQuiz()' : `renderPage(${pageIdx + 1})`}">
        ${pageIdx === questions.length - 1 ? 'Submit Quiz' : 'Next'}
      </button>
    </div>`;

    const totalQuestions = questions.length;
    const currentQuestionNumber = pageIdx + 1;
    const percent = Math.round((currentQuestionNumber / totalQuestions) * 100);
    document.getElementById('progress-text').innerText = `Question ${currentQuestionNumber} of ${totalQuestions}`;
    const progressBar = document.getElementById('progress-bar');
    progressBar.style.width = `${percent}%`;
    progressBar.setAttribute('aria-valuenow', percent);

    document.querySelector('.questions').innerHTML = html;
    currentPage = pageIdx;

    // ✅ Enable Next only if any option selected
    const inputName = `q${q.question_id}${q.type === 'multiple_answers' ? '[]' : ''}`;
    const inputElements = document.querySelectorAll(`input[name="${inputName}"]`);
    const nextBtn = document.getElementById('nextBtn');

    function checkAnswerSelected() {
      let selected = false;
      inputElements.forEach(input => {
        if (input.checked) selected = true;
      });
      if (nextBtn) nextBtn.disabled = !selected;
    }

    inputElements.forEach(input => {
      input.addEventListener('change', checkAnswerSelected);
    });

    checkAnswerSelected();

    showFeedbackIfAnswered(q.question_id, q.type, q.correct_answer);
  }

  window.renderPage = renderPage;
  renderPage(currentPage);
  window.quizData = quiz;
}

window.updateAnswer = function(qid, ans, type) {
  const quiz = window.quizData;
  const q = quiz.questions.find(q => q.question_id == qid);
  if (!q) return;

  const correctAnswers = Array.isArray(q.correct_answer)
    ? q.correct_answer.map(c => (c || '').toString().trim().toLowerCase())
    : [(q.correct_answer || '').toString().trim().toLowerCase()];

  const radios = document.querySelectorAll(`input[name="q${qid}${type === 'multiple_answers' ? '[]' : ''}"]`);

  if (type === 'multiple_answers') {
    if (!answers[qid]) answers[qid] = [];

    const idx = answers[qid].indexOf(ans);
    if (idx === -1) answers[qid].push(ans);
    else answers[qid].splice(idx, 1);

    const selectedNormalized = answers[qid].map(a => a.toString().trim().toLowerCase());
    const hasIncorrect = selectedNormalized.some(sel => !correctAnswers.includes(sel));
    const allCorrectSelected = correctAnswers.every(ca => selectedNormalized.includes(ca));

    if (hasIncorrect || allCorrectSelected) {
      radios.forEach(radio => {
        radio.disabled = true;
        const label = radio.closest('.option-label');
        const value = radio.value.toString().trim().toLowerCase();

        if (correctAnswers.includes(value)) {
          label.classList.add('correct');
          label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ✔️</span>';
        }

        if (selectedNormalized.includes(value) && !correctAnswers.includes(value)) {
          label.classList.add('incorrect');
          label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ❌</span>';
        }
      });
    }

  } else {
    answers[qid] = ans;

    radios.forEach(radio => {
      radio.disabled = true;
      const label = radio.closest('.option-label');
      const value = radio.value.toString().trim().toLowerCase();

      if (correctAnswers.includes(value)) {
        label.classList.add('correct');
        label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ✔️</span>';
      }

      if (radio.value === ans && !correctAnswers.includes(value)) {
        label.classList.add('incorrect');
        label.querySelector('.option-text').innerHTML += ' <span class="icon-feedback"> ❌</span>';
      }
    });
  }
}

function showFeedbackIfAnswered(qid, type, correctAnswer) {
  const correctAnswers = Array.isArray(correctAnswer)
    ? correctAnswer.map(c => (c || '').toString().trim().toLowerCase())
    : [(correctAnswer || '').toString().trim().toLowerCase()];

  const inputName = `q${qid}${type === 'multiple_answers' ? '[]' : ''}`;
  const inputs = document.querySelectorAll(`input[name="${inputName}"]`);
  if (!answers[qid]) return;

  if (type === 'multiple_answers') {
    const selected = (answers[qid] || []).map(a => a.toString().trim().toLowerCase());

    inputs.forEach(input => {
      input.disabled = true;
      const label = input.closest('.option-label');
      const value = input.value.toString().trim().toLowerCase();
      const textEl = label.querySelector('.option-text');

      if (correctAnswers.includes(value)) {
        label.classList.add('correct');
        if (!textEl.innerHTML.includes('✔️')) textEl.innerHTML += ' <span class="icon-feedback"> ✔️</span>';
      }
      if (selected.includes(value) && !correctAnswers.includes(value)) {
        label.classList.add('incorrect');
        if (!textEl.innerHTML.includes('❌')) textEl.innerHTML += ' <span class="icon-feedback"> ❌</span>';
      }
    });

  } else {
    const selected = (answers[qid] || '').toString().trim().toLowerCase();

    inputs.forEach(input => {
      input.disabled = true;
      const label = input.closest('.option-label');
      const value = input.value.toString().trim().toLowerCase();
      const textEl = label.querySelector('.option-text');

      if (correctAnswers.includes(value)) {
        label.classList.add('correct');
        if (!textEl.innerHTML.includes('✔️')) textEl.innerHTML += ' <span class="icon-feedback"> ✔️</span>';
      }

      if (selected === value && !correctAnswers.includes(value)) {
        label.classList.add('incorrect');
        if (!textEl.innerHTML.includes('❌')) textEl.innerHTML += ' <span class="icon-feedback"> ❌</span>';
      }
    });
  }
}

function showResult(resultData) {
  const quiz = resultData;
  const courseId = params.get('course');

  $('.progress').hide();
  
  let html = `<h3 class="text-center mb-4 thankyou-title">Thank you for completing ${quiz.quiz_title}</h3>`;

  quiz.questions.forEach((q, idx) => {
    let opts = Array.isArray(q.options) ? q.options.filter(o => o) : [];
    if (opts.length === 0) {
      if (q.type === 'yes_no') opts = ['Yes', 'No'];
      else if (q.type === 'true_false') opts = ['True', 'False'];
    }

    // ✅ Build mapping option text → option_N
    const optionMap = {};
    opts.forEach((op, i) => {
      optionMap[(op || '').toString().trim().toLowerCase()] = `option_${i + 1}`;
    });

    // correct answers
    const correctArr = Array.isArray(q.correct_answer)
      ? q.correct_answer.map(c => (c || '').toString().trim().toLowerCase())
      : [(q.correct_answer || '').toString().trim().toLowerCase()];

    // ✅ selected answers (from API response instead of local answers object)
    const selectedRaw = q.selected_answer;
    const selectedArr = Array.isArray(selectedRaw)
      ? selectedRaw.map(s => (s || '').toString().trim().toLowerCase())
      : [(selectedRaw || '').toString().trim().toLowerCase()];

    // ✅ Convert values → column names (option_1, option_2…)
    const correctCols = correctArr.map(c => optionMap[c] || '').filter(Boolean);
    const selectedCols = selectedArr.map(s => optionMap[s] || '').filter(Boolean);

    // build review UI
    html += `<div class="question-box"><p><hr><strong>${idx + 1}. ${q.question}</strong></p>`;
    opts.forEach(op => {
      const opNorm = (op || '').toString().trim().toLowerCase();
      const isCorr = correctArr.includes(opNorm);
      const isSel = selectedArr.includes(opNorm);

      let classList = 'review-answer-box';
      if (isCorr) classList += ' correct';
      else if (isSel) classList += ' incorrect';

      let label = '';
      if (isSel && isCorr) label = 'Your Answer [Correct Answer]';
      else if (isSel) label = 'Your Answer';
      else if (isCorr) label = 'Correct Answer';

      html += `<div class="${classList}">${op}${label ? `<span class="review-answer-label">${label}</span>` : ''}</div>`;
    });
    html += `</div>`;
  });

  html += `<center><button type="button" class="btn btn-primary" onclick="history.back()">Click To Resume Study</button></center>`;
  document.querySelector('.questions').innerHTML = html;
}


window.submitQuiz = function() {
  const quiz = window.quizData;

  let html = `<h3 class="text-center mb-4 thankyou-title">Thank you for completing ${quiz.quiz_title}</h3>`;

  const questionsPayload = [];

  quiz.questions.forEach((q, idx) => {
    let opts = Array.isArray(q.options) ? q.options.filter(o => o) : [];
    if (opts.length === 0) {
      if (q.type === 'yes_no') opts = ['Yes', 'No'];
      else if (q.type === 'true_false') opts = ['True', 'False'];
    }

    // ✅ Build mapping option text → option_N
    const optionMap = {};
    opts.forEach((op, i) => {
      optionMap[(op || '').toString().trim().toLowerCase()] = `option_${i+1}`;
    });

    // correct answers
    const correctArr = Array.isArray(q.correct_answer)
      ? q.correct_answer.map(c => (c || '').toString().trim().toLowerCase())
      : [(q.correct_answer || '').toString().trim().toLowerCase()];

    // selected answers
    const selectedRaw = answers[q.question_id];
    const selectedArr = Array.isArray(selectedRaw)
      ? selectedRaw.map(s => (s || '').toString().trim().toLowerCase())
      : [(selectedRaw || '').toString().trim().toLowerCase()];

    let correctCols, selectedCols;

    if (q.type === 'yes_no' || q.type === 'true_false') {
      // ✅ Save actual words
      correctCols = correctArr.map(c => c.charAt(0).toUpperCase() + c.slice(1)); 
      selectedCols = selectedArr.map(s => s.charAt(0).toUpperCase() + s.slice(1));
    } else {
      // ✅ Save option_1, option_2 …
      correctCols = correctArr.map(c => optionMap[c] || '').filter(Boolean);
      selectedCols = selectedArr.map(s => optionMap[s] || '').filter(Boolean);
    }

    // save payload for backend
    questionsPayload.push({
      question_id: q.question_id,
      correct_answer: correctCols.join(","),   // "Yes" or "option_2"
      selected_answer: selectedCols.join(",")  // "No" or "option_3"
    });

    // build review UI
    html += `<div class="question-box"><p><hr><strong>${idx + 1}. ${q.question}</strong></p>`;
    opts.forEach(op => {
      const opNorm = (op || '').toString().trim().toLowerCase();
      const isCorr = correctArr.includes(opNorm);
      const isSel = selectedArr.includes(opNorm);

      let classList = 'review-answer-box';
      if (isCorr) classList += ' correct';
      else if (isSel) classList += ' incorrect';

      let label = '';
      if (isSel && isCorr) label = 'Your Answer [Correct Answer]';
      else if (isSel) label = 'Your Answer';
      else if (isCorr) label = 'Correct Answer';

      html += `<div class="${classList}">${op}${label ? `<span class="review-answer-label">${label}</span>` : ''}</div>`;
    });
    html += `</div>`;
  });

  html += `<center><button type="button" class="btn btn-primary" onclick="history.back()">Click To Resume Study</button></center>`;
  document.querySelector('.questions').innerHTML = html;

  // 🔹 Send data to backend
  const params = new URLSearchParams(window.location.search);
  const quiz_id = params.get('quiz_id');

  const payload = {
    quiz_id: quiz_id,
    course_id: courseId,
    questions: questionsPayload
  };

  fetch("apis/save_quiz_attempt.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(payload)
  })
  .then(res => res.json())
  .then(resp => {
    if (resp.status === "success") {
      console.log("✅ Quiz attempt saved", resp);
    } else {
      console.error("❌ Failed to save quiz attempt", resp);
    }
  })
  .catch(err => console.error("❌ API Error:", err));
};


});
</script>




</body>
</html>