<?php 
$page_name = 'Add Course Material';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">

<div id="uploadLoader"  style="display:none;">
  <div class="loader-overlay">
    <div class="loader-text">⏳ Your file is uploading, please wait...</div>
  </div>
</div>

  <section class="content-header">
    <span class="p-10">
      ADD COURSE MATERIAL
    </span>
    <ol class="breadcrumb">
      <li><a href="masters.php"> Masters</a></li>
      <li><a href="course_material_master.php">Course Material</a></li>
      <li class="active">Add Course Material</li>
    </ol>
  </section>
  
  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <p class="box-title">* All fields marked with an asterisk are required</p>
        <div class="col-md-4 response-msg" id="responseMessage"></div>  
      </div>

      <form id="studyMaterialForm">
        <div class="box-body">
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label>Study Title <span class="text-danger">*</span></label>
                <input class="form-control" type="text" id="study_title" name="study_title" required>
              </div>
            </div>

            <div class="col-md-4">
              <div class="form-group">
                <label>Category <span class="text-danger">*</span></label>
                <select class="form-control select2" id="category" name="category" style="width: 100%;" required></select>
              </div>
            </div>                        

            <div class="col-md-4">
              <div class="form-group">
                <label>Study Content <span class="text-danger">*</span></label>
                <input class="form-control" type="file" id="study_content" name="study_content" accept=".pdf,.ppt,.pptx,.png,.jpg,.jpeg,.mp4,.txt" required>
              </div>
            </div>                        

            <div class="col-md-4">
              <div class="form-group">
                <label>Description</label>
                <textarea class="form-control" id="description" name="description"></textarea>
              </div>
            </div> 
                
            <div class="col-md-4">
              <div class="form-group">
                <div class="radio">
                  <input name="block_content" value="0" type="radio" id="Option_1" class="with-gap radio-col-red" checked>
                  <label for="Option_1">Active</label>                    
                </div>
                <div class="radio">
                  <input name="block_content" value="1" type="radio" id="Option_2" class="with-gap radio-col-red">
                  <label for="Option_2">Inactive</label>   
                </div>
              </div>
            </div>                         
          </div>
        
          <div class="box-footer">
            <button type="submit" class="btn btn-primary">Submit</button>
            <a href="course_material_master.php" class="btn btn-secondary">Back</a>
          </div>
        </div>
      </form>
    </div>
  </section>
</div>

<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
  populateCategories('category');

  $('#studyMaterialForm').on('submit', function(event) {
    event.preventDefault();

    const allowedExtensions = ['pdf','ppt','pptx','png','jpg','jpeg','mp4','txt'];
    const studyContent = $('#study_content')[0].files[0];

    if (studyContent) {
      const fileExt = studyContent.name.split('.').pop().toLowerCase();
      if (!allowedExtensions.includes(fileExt)) {
        alert("Invalid file type! Please upload only PDF, PPT, TXT, PNG, JPG, JPEG, or MP4 files.");
        $('#study_content').val('');
        return;
      }
    }

    let formData = new FormData();
    formData.append('study_title', $('#study_title').val());
    formData.append('description', $('#description').val());
    formData.append('category', $('#category').val());
    formData.append('block_content', $('input[name="block_content"]:checked').val());

    if (studyContent) {
      formData.append('study_content', studyContent);
    }

$('#uploadLoader').show();

    $.ajax({
      url: 'apis/add_course_material_api.php',
      method: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      success: function(response) {
          $('#uploadLoader').hide();
        let data;
        try {
          data = (typeof response === "string") ? JSON.parse(response) : response;
        } catch(e) {
          console.error("Invalid JSON:", response);
          showAlert('Unexpected server response.', 'danger');
          return;
        }

        if (data.status === 'success') {
          showAlert(data.message, 'success');
          $('#studyMaterialForm')[0].reset();
          $('#category').val(null).trigger('change');
        } else {
          showAlert(data.message || 'Something went wrong.', 'danger');
        }
      },
      error: function(xhr, status, error) {
          $('#uploadLoader').hide();
        console.error('Error:', error);
        showAlert('An error occurred while processing your request.', 'danger');
      }
    });
  });
});
</script>
</body>
</html>