<?php
$page_name = 'Bulk Notification';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

<div class="content-wrapper">
    <section class="content-header">
        <span class="p-10">Email Templates</span>
        <ol class="breadcrumb">
            <li><a href="masters.php">Masters</a></li>
            <li><a href="student_master.php">Student</a></li>
            <li class="active">Bulk Notification</li>
        </ol>
    </section>

    <section class="content">
        <div class="box box-default">
            <div class="box-header with-border">
                <div class="col-md-6 response-msg" id="responseMessage"></div>
            </div>

            <form id="emailForm">
                <div class="box-body">
                    <div class="col-md-12">

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label"><b>Email Content</b></label>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Email Title</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="email_title" required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Subject</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" id="subject" required>
                            </div>
                        </div>

                        <div class="form-group clearfix">
                            <label class="col-md-2 col-form-label">Message</label>
                            <div class="col-md-6">
                                <textarea class="form-control" id="email_message" rows="5"></textarea>
                            </div>
                        </div>

                        <div class="box-footer" style="margin-top:30px;">
                            <button type="submit" class="btn btn-primary" id="btnText">
                                Save Template
                            </button>
                            <button type="button" class="btn btn-secondary"
                                onclick="window.location.href='templates.php'">
                                Back
                            </button>
                        </div>

                    </div>
                </div>
            </form>
        </div>
    </section>
</div>

<?php require_once('includes/footer.php'); ?>

<!-- Submit handler -->
<script>
$(document).ready(function () {
    $('#emailForm').on('submit', function (e) {
        e.preventDefault();

        const btn = $('#btnText');
        btn.prop('disabled', true).text('Saving...');

        const postData = {
            email_title: $('#email_title').val(),
            subject: $('#subject').val(),
            email_content: tinymce.get('email_message') ? tinymce.get('email_message').getContent() : ''
        };

        $.ajax({
            url: 'apis/save_template_api.php',
            type: 'POST',
            data: postData,
            dataType: 'json',
            success: function (res) {
                if (res.status === 'success') {
                    showAlert(res.message, 'success');
                    $('#emailForm')[0].reset();
                    if (tinymce.get('email_message')) {
                        tinymce.get('email_message').setContent('');
                    }
                } else {
                    showAlert(res.message, 'danger');
                }
                btn.prop('disabled', false).text('Save Template');
            },
            error: function () {
                showAlert('Server error occurred', 'danger');
                btn.prop('disabled', false).text('Save Template');
            }
        });
    });
});
</script>

<!-- TinyMCE self-hosted -->
<script src="tinymce_editor/tinymce/js/tinymce/tinymce.min.js"></script>
<script>
tinymce.init({
    selector: '#email_message',
    height: 250,
    menubar: false,
    plugins: [
        'advlist autolink lists link image charmap print preview anchor',
        'searchreplace visualblocks code fullscreen',
        'insertdatetime media table paste code help wordcount'
    ],
    toolbar: 'undo redo | formatselect | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image | removeformat | help',
    content_css: 'tinymce_editor/tinymce/skins/content/default/content.css'
});
</script>

</body>
</html>