<?php 
$page_name = 'Add Employee';

require_once('includes/connection.php');
require_once('includes/header.php');
?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD EMPLOYEE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="employee_master.php">Employee</a></li>
        <li class="active">Add Employee</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="employeeForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>First Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="first_name" name="first_name" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Last Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="last_name" name="last_name" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Mobile No. <span class="text-danger">*</span></label>
                                <input class="form-control" type="tel" pattern="\d{10}" maxlength="10" minlength="10" autocomplete="off" id="mobile_no" name="mobile_no" title="Please enter exactly 10 digits (numbers only)" required>
                            </div>
                        </div> 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email ID <span class="text-danger">*</span></label>
                                <input class="form-control" type="email"  autocomplete="new-email" id="email_id" name="email_id" pattern=".+\..{2,4}$" 
                              title="Please enter a valid email address" required>
                            </div>
                        </div> 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Password <span class="text-danger">*</span></label>
                                    <input class="form-control" type="password"  autocomplete="new-password" id="password" name="password" required>
                                        <span class="input-group-text password-eye" id="togglePassword">
                                            <i class="fa fa-eye" id="eyeIcon"></i> <!-- Eye Icon -->
                                        </span>                                        
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Roles</label>
                                <select class="form-control select2" multiple="multiple" id="role_name" name="role_name" data-placeholder="Select roles"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Address</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="address" name="address"></textarea>
                            </div>
                        </div> 
                        <div class="col-md-4">
                <div class="form-group">
                  <div class="radio">
                  	  <input name="block_employee" value="0" type="radio" id="Option_1" class="with-gap radio-col-red" checked="">
					  <label for="Option_1">Active</label>                    
                  </div>
                  <div class="radio">
                  	  <input name="block_employee" value="1" type="radio" id="Option_2" class="with-gap radio-col-red">
					  <label for="Option_2">Inactive</label>   
                  </div>
                </div>
                        </div>                         
                    </div>
                
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <a href="employee_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function() {
    $.ajax({
        url: 'apis/role_api.php',
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            if (Array.isArray(data)) {

                let options = '';
                $.each(data, function(index, role) {
                    options += `<option value="${role.role_id}">${role.role_name}</option>`;
                });

                $('#role_name').html(options);

                $('#role_name').select2();
            } else {
                console.error('Error: Invalid response format', data);
            }
        },
        error: function(error) {
            console.error('Error occurred while fetching data:', error);
        }
    });

    $('#employeeForm').on('submit', function(event) {
        event.preventDefault();

        const firstName = $('#first_name').val();
        const lastName = $('#last_name').val();
        const mobileNo = $('#mobile_no').val();
        const emailId = $('#email_id').val();
        const password = $('#password').val();
        const role = $('#role_name').val();
        const address = $('#address').val();
        const blockEmployee = $('input[name="block_employee"]:checked').val();

        const formData = {
            first_name: firstName,
            last_name: lastName,
            phone_no: mobileNo,
            email_id: emailId,
            password: password,
            role_name: role,
            address: address,
            block_employee: blockEmployee
        };

        $.ajax({
            url: 'apis/add_employee_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            success: function(data) {
                const responseMessage = $('#responseMessage');
                if (data.status === 'success') {
                    showAlert(data.message, 'success');

                    $('#employeeForm')[0].reset();
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function(error) {
                console.error('Error:', error);
                showAlert('An error occurred while submitting the form.', 'danger');
            }
        });
    });

});
</script>


</body>
</html>