<?php 
$page_name = 'Add Institute Course Details';

require_once('includes/connection.php');
require_once('includes/header.php');

?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD INSTITUTE COURSE DETAILS
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="course_master.php">Course</a></li>
        <li class="active">Add Institute Course Details</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">* All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="courseForm">
                <div class="box-body">
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Institutes</label>
                                <select class="form-control select2" multiple="multiple" id="institute_name" name="institute_name" data-placeholder="Select Institutes"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>                        
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" readonly>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Category <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" readonly>
                            </div>
                        </div> 
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Level <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="course_name" name="course_name" readonly>
                            </div>
                        </div>                         
 
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No. Of Installments<span class="text-danger">*</span></label>
                                <input class="form-control" type="number" autocomplete="off" id="course_name" name="course_name" required>
                            </div>
                        </div>
                    

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>No. Of Hours<span class="text-danger">*</span></label>
                                <input class="form-control" type="number" autocomplete="off" id="course_name" name="course_name" required>
                            </div>
                        </div>  
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Course Mentors</label>
                                <select class="form-control select2" multiple="multiple" id="institute_name" name="institute_name" data-placeholder="Select Mentors"
                                        style="width: 100%;">
                                    <!-- Options will be populated dynamically -->
                                </select>
                            </div>
                        </div>                         
                        
                        
                        <!--<div class="col-md-4">-->
                        <!--    <div class="form-group">-->
                        <!--        <label>Course Image</label>-->
                        <!--        <input class="form-control" type="file" autocomplete="off" id="course_img" name="course_img" accept="image/png, image/gif, image/jpeg">-->
                        <!--    </div>-->
                        <!--</div>                        -->
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                            </div>
                        </div>
        
                        
                    </div>
                
<hr>

                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Course Start Date <span class="text-danger">*</span></label>
                                <input class="form-control" type="date" autocomplete="off" id="course_start_date" name="course_start_date[]" required>
                            </div>
                        </div>
                        
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Course End Date <span class="text-danger">*</span></label>
                                <input class="form-control" type="date" autocomplete="off" id="course_end_date" name="course_end_date[]" required>
                            </div>
                        </div> 
                        
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>No. Of Licenses<span class="text-danger">*</span></label>
                                <input class="form-control" type="number" autocomplete="off" id="licenses" name="licenses[]" required>
                            </div>
                        </div> 
                        
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Course Fees<span class="text-danger">*</span></label>
                                <input class="form-control" type="number" autocomplete="off" id="course_fees" name="course_fees[]" required>
                            </div>
                        </div>                         
                        
                        
                        <div class="col-md-2">
                            <button type="button" class="btn btn-primary mb-25 mt-25 btn-circle" id="addMoreButton" style="border-radius: 50% !important;"><i class="fas fa-plus"></i></button>  
                        </div>    

                    </div>
                    
                    <div id="additionalSubmodules"></div>
                    
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <a href="course_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>

<script>
$(document).ready(function () {
 
     prepopulateInstituteDropdowns(); 


    // Handle the "Add More" button click
    $('#addMoreButton').on('click', function() {
        const newInputHTML = `
        <div class="row">
            <div class="col-md-2">
                <div class="form-group">
                    <label>Course Start Date <span class="text-danger">*</span></label>
                    <input class="form-control" type="date" autocomplete="off" id="course_start_date" name="course_start_date[]" required>
                </div>
            </div>
            
            <div class="col-md-2">
                <div class="form-group">
                    <label>Course End Date <span class="text-danger">*</span></label>
                    <input class="form-control" type="date" autocomplete="off" id="course_end_date" name="course_end_date[]" required>
                </div>
            </div> 
            
            <div class="col-md-2">
                <div class="form-group">
                    <label>No. Of Licenses<span class="text-danger">*</span></label>
                    <input class="form-control" type="number" autocomplete="off" id="licenses" name="licenses[]" required>
                </div>
            </div> 
            
            <div class="col-md-2">
                <div class="form-group">
                    <label>Course Fees<span class="text-danger">*</span></label>
                    <input class="form-control" type="number" autocomplete="off" id="course_fees" name="course_fees[]" required>
                </div>
            </div>  
            <div class="col-md-4">
                <button type="button" class="btn btn-danger removeButton mb-25 mt-25 btn-circle" style="border-radius: 50% !important;"><i class="fas fa-minus"></i></button>
            </div>
        </div>    
        `;
        $('#additionalSubmodules').append(newInputHTML);
    });

    // Event delegation for removing input fields
    $('#additionalSubmodules').on('click', '.removeButton', function() {
        // Remove the parent div (row) of the clicked button
        $(this).closest('.row').remove();
    });
    
    
    // Handle form submission
    $('#courseForm').on('submit', function (event) {
        event.preventDefault();

    var formData = new FormData();

    formData.append('course_name', $('#course_name').val());
    formData.append('course_category', $('#course_category').val());
    formData.append('level', $('#level').val());
    formData.append('description', $('#description').val());
    var courseImg = $('#course_img')[0].files[0];

    if (courseImg) {
        if (courseImg.size > 1048576) {
            // If file size is more than 1MB, show an error message
            showAlert('File size exceeds the 1MB limit.', 'danger');
            return;
        } else {
            formData.append('course_img', courseImg);
        }
    }

        // Submit the form data
        $.ajax({
            url: 'apis/add_course_api.php',
            method: 'POST',
            data: formData,
            processData: false, 
            contentType: false,            
            success: function (data) {
                if (data.status === 'success') {
                    showAlert(data.message, 'success');
                    $('#courseForm')[0].reset(); // Reset the form
                    $('#course_mentors').val(null).trigger('change'); // Reset mentor dropdown
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function (error) {
                console.error('Error:', error);
                showAlert('An error occurred while processing your request.', 'danger');
            }
        });
    });
});
</script>

</body>
</html>