<?php
$page_name = 'Add Quiz';
require_once('includes/connection.php');
require_once('includes/header.php');
?>
<div class="content-wrapper">
  <section class="content-header">
    <span class="p-10">ADD QUIZ</span>
    <ol class="breadcrumb">
      <li><a href="masters.php">Masters</a></li>
      <li><a href="quiz_master.php">Quiz</a></li>
      <li class="active">Add Quiz</li>
    </ol>
  </section>
  <section class="content">
    <div class="box box-default">
      <div class="box-header with-border">
        <p class="box-title">* All fields are required.</p>
        <div class="col-md-4 response-msg" id="responseMessage"></div>
      </div>
      <form id="quizForm" enctype="multipart/form-data">
        <div class="box-body">
          <div class="row">
            
            <div class="col-md-4">
              <div class="form-group">
                <label for="quizTitle">Quiz Title</label>
                <input type="text" id="quizTitle" name="quizTitle" class="form-control" required />
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label>Category</label>
                <select class="form-control select2" id="category" name="category" style="width: 100%;"></select>
              </div>
            </div>
          </div>
        </div>
        <div class="box-body table-padding">
          <table id="dataGrid" class="table display">
            <thead style="background: #FAF7FE;">
              <tr>
                <th><input type="checkbox" id="select-all" style="margin-top: -15px;" /></th>
                <th>Question</th>
                <th>Category</th>
                <th>Media</th>
              </tr>
            </thead>
          </table>
        </div>
        <div class="box-footer">
          <input type="hidden" name="selected_questions" id="selected_questions" />
          <button type="submit" class="btn btn-primary">Submit</button>
          <a href="quiz_master.php" class="btn btn-secondary">Back</a>
        </div>
      </form>
    </div>
  </section>
</div>
<?php require_once('includes/footer.php'); ?>
<script>
let dataTable;
let selectedQuestions = new Set();

$(document).ready(function () {
  populateCategories('category');


  dataTable = $('#dataGrid').DataTable({
    processing: true,
    serverSide: true,
    ordering: false,
    autoWidth: false,
    language: { search: "Search:" },
    ajax: {
      url: 'apis/question_api.php',
      type: 'POST',
      data: function (d) {
        d.category_id = $('#category').val();
        d.criteria = 'quiz';
      },
      beforeSend: function () {
        $('#page-loader').show();
      },
      complete: function () {
        $('#page-loader').hide();
      }
    },
    columns: [
      {
        data: 'question_master_id',
        orderable: false,
        render: function (data) {
          const checked = selectedQuestions.has(data.toString()) ? 'checked' : '';
          return `<input type="checkbox" class="question-checkbox" value="${data}" ${checked}>`;
        }
      },
      { data: 'question' },
      { data: 'category_name' },
      { data: 'media' }
    ],
    initComplete: function () {
      $('#dataGrid_filter input[type=search]').addClass('responsive-input');
    }
  });

  $('#category').on('change', function () {
    dataTable.ajax.reload();
  });

  // Track checkbox changes
  $('#dataGrid').on('change', '.question-checkbox', function () {
    const id = this.value;
    this.checked ? selectedQuestions.add(id) : selectedQuestions.delete(id);

    // Update header checkbox based on visible rows
    const allVisible = $('#dataGrid .question-checkbox').length;
    const selectedVisible = $('#dataGrid .question-checkbox:checked').length;
    $('#select-all').prop('checked', allVisible > 0 && allVisible === selectedVisible);
  });

  // Handle "select all" toggle
  $('#dataGrid').on('change', '#select-all', function () {
    const isChecked = this.checked;
    $('#dataGrid .question-checkbox').each(function () {
      this.checked = isChecked;
      const id = this.value;
      isChecked ? selectedQuestions.add(id) : selectedQuestions.delete(id);
    });
  });

  // Restore checkbox states on table draw
  $('#dataGrid').on('draw.dt', function () {
    $('#dataGrid .question-checkbox').each(function () {
      const id = this.value;
      this.checked = selectedQuestions.has(id);
    });

    // Sync "select-all" checkbox
    const allVisible = $('#dataGrid .question-checkbox').length;
    const selectedVisible = $('#dataGrid .question-checkbox:checked').length;
    $('#select-all').prop('checked', allVisible > 0 && allVisible === selectedVisible);
  });

  // Form submission
$('#quizForm').on('submit', function (e) {
  e.preventDefault();

  const selectedIds = Array.from(selectedQuestions);

  // Pass selected questions
  $('#selected_questions').val(JSON.stringify(selectedIds));

  const formData = new FormData(this);

  fetch('apis/add_quiz_api.php', {
    method: 'POST',
    body: formData
  })
    .then(res => res.json())
    .then(response => {
      if (response.status === 'success') {
        showAlert(response.message, 'success');
        $('#quizForm')[0].reset();
      } else {
        showAlert(response.message, 'danger');
      }
    })
    .catch(error => {
      console.error(error);
      showAlert('An error occurred while processing your request.', 'danger');
    });
});

});

</script>
</body>
</html>