<?php 
$page_name = 'Add Submodule';

require_once('includes/connection.php');
require_once('includes/header.php');

?>

  <div class="content-wrapper">
    <section class="content-header">
      <span class="p-10">
        ADD SUBMODULE
      </span>
      <ol class="breadcrumb">
        <li><a href="masters.php"> Masters</a></li>
        <li><a href="submodule_master.php">Submodule</a></li>
        <li class="active">Add Submodule</li>
      </ol>
    </section>
    
    
    <section class="content">
      <div class="box box-default">
        <div class="box-header with-border">
          <p class="box-title">*All fields marked with an asterisk are required</p>
            <div class="col-md-4 response-msg" id="responseMessage">
            </div>  
        </div>

            <form id="submoduleForm">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Submodule Name <span class="text-danger">*</span></label>
                                <input class="form-control" type="text" autocomplete="off" id="submodule_name" name="submodule_name" required>
                            </div>
                        </div>
                        
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Module Name <span class="text-danger">*</span></label>
                          <select class="form-control select2" id="module" name="module" style="width: 100%;" required></select>
                        </div>
                      </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Description (Optional)</label>
                                <textarea class="form-control" type="text" autocomplete="off" id="description" name="description"></textarea>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="radio">
                                    <input name="block_submodule" value="0" type="radio" id="Option_2" class="with-gap radio-col-red" checked="">
                                    <label for="Option_2">Active</label>
                                </div>
                                <div class="radio">
                                    <input name="block_submodule" value="1" type="radio" id="Option_1" class="with-gap radio-col-red">
                                    <label for="Option_1">Inactive</label>
                                </div>
                            </div>
                        </div>

                    </div>
                    
                
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                        <a href="submodule_master.php"  class="btn btn-secondary"> Back</a>
                    </div>
                </div>
            </form>
      </div>
    </section>
  </div>


<?php require_once('includes/footer.php'); ?>
  
<script>
$(document).ready(function() {

function escapeHtml(text) {
    return $('<div>').text(text).html();
}


function populateModules(selectorId, selectedId = null) {
    $.ajax({
        url: './apis/module_dropdown_api_1.php',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data && Array.isArray(data.modules)) {
                let options = '<option value="">Select Module</option>';
                data.modules.forEach(function(module) {
                    const selectedAttr = selectedId == module.id ? 'selected' : '';
                    options += `<option value="${module.id}" ${selectedAttr}>${escapeHtml(module.name)}</option>`;
                });
                $(`#${selectorId}`).html(options).trigger('change');
            } else {
                console.error('Invalid response format from country_api.php', data);
            }
        },
        error: function(xhr, status, error) {
            console.error('Failed to load countries:', error);
        }
    });
}

populateModules('module');    

    // Handle form submission
    $('#submoduleForm').on('submit', function(event) {
        event.preventDefault();

        const status = $('input[name="block_submodule"]:checked').val();

        var formData = {
            'submodule_name': $('#submodule_name').val(),
            'description': $('#description').val(),
            'module_id': $('#module').val(),
            'status': status  
        };


        // Make the API request to save the data
        $.ajax({
            url: 'apis/add_submodule_api.php',
            method: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(formData),
            success: function(data) {
                if (data.status === 'success') {
                    showAlert(data.message, 'success');

                    $('#submoduleForm')[0].reset();
                    $('#submodule_name').val(null).trigger('change');
                    $('#module').val(null).trigger('change');
                } else {
                    showAlert(data.message, 'danger');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                showAlert('An error occurred while submitting the form.', 'danger');
            }
        });
    });
});
</script>

</body>
</html>